(function (app) {
    app.service('spsservice', function ($q) {
        //var site = 'siteAbsoluteUrl'; //Site Collection
        var site = 'webAbsoluteUrl'; // Sub sitio

        this.attach_data = function (url, buffer) {
            var deferred = $q.defer();
            var endpoint = _spPageContextInfo.webAbsoluteUrl + "/_api/web/"+url;          
            deferred.notify('notify endpoint:' + endpoint);
            $.ajax({
                url: endpoint,
                method: 'POST',
                data: buffer,
                processData: false,
                headers: {
                 "Accept": "application/json; odata=verbose",
                 "content-type": "application/json; odata=verbose",
                 "X-RequestDigest": document.getElementById("__REQUESTDIGEST").value,
                 "content-length": buffer.byteLength
                },
              
                success: function (data) {
                    deferred.resolve(data);
                },
                error: function (data) {
                    deferred.reject(data);
                }, 
                beforeSend: function () {
                    deferred.notify('notify beforesend');
                },
                complete: function () {
                    deferred.notify('notify complete');
                }
            });

            return deferred.promise
        }

        this.remove_attach = function (url) {
            var deferred = $q.defer();
            var endpoint = _spPageContextInfo.webAbsoluteUrl + "/_api/web/"+url;          
            deferred.notify('notify endpoint:' + endpoint);
            $.ajax({
                url: endpoint,
                method: 'DELETE',
                headers: {
                 "X-RequestDigest": document.getElementById("__REQUESTDIGEST").value
                },
              
                success: function (data) {
                    deferred.resolve(data);
                },
                error: function (data) {
                    deferred.reject(data);
                }, 
                beforeSend: function () {
                    deferred.notify('notify beforesend');
                },
                complete: function () {
                    deferred.notify('notify complete');
                }
            });

            return deferred.promise
        }

        this.delete_data = function (url) {
            var deferred = $q.defer();
            var endpoint = _spPageContextInfo.webAbsoluteUrl + "/_api/web/"+url;          
            deferred.notify('notify endpoint:' + endpoint);
            
            $.ajax({  
                url: endpoint,
                type: "POST",  
                contentType: "application/json;odata=verbose",  
                headers: {  
                    "Accept": "application/json;odata=verbose",  
                    "X-RequestDigest": $("#__REQUESTDIGEST").val(),  
                    "IF-MATCH": "*",  
                    "X-HTTP-Method": "DELETE",  
                },  
                success: function(data) {  
                    deferred.resolve(data);
                },  
                error: function(data) {  
                    // debugger;
                    deferred.reject(data);
                }  
            });  

            return deferred.promise
        }

        this.put_data = function (url, data) {
            var deferred = $q.defer();
            deferred.notify('notify endpoint:' + url);
           
            var endpoint = _spPageContextInfo.webAbsoluteUrl + "/_api/web/"+url;     
            $.ajax({
                contentType: "application/json;odata=verbose",
                url: endpoint,
                method: "POST",
                headers: {
                    "Accept": "application/json;odata=verbose",
                    "X-RequestDigest": $("#__REQUESTDIGEST").val(),
                    "X-HTTP-Method": "MERGE",
                    "If-Match": "*"
                },
                data:  JSON.stringify(data),
                success: function (data) {
                    deferred.resolve(data);
                },
                error: function (data) {
                    deferred.reject(data);
                }
            });

            return deferred.promise
        }

        this.post_data = function (url, data) {
            var deferred = $q.defer();
            var endpoint = _spPageContextInfo.webAbsoluteUrl + "/_api/web/"+url;          
            deferred.notify('notify endpoint:' + endpoint);
            $.ajax({
                url: endpoint,
                method: "POST",
                headers: {  
                    "Accept": "application/json;odata=verbose",  
                    "Content-Type": "application/json;odata=verbose",  
                    "X-RequestDigest": $("#__REQUESTDIGEST").val(),  
                    "If-Match": "*"
                },  
                data:  JSON.stringify(data),
                success: function (data) {
                    deferred.resolve(data);
                },
                error: function (data) {
                    debugger;
                    deferred.reject(data);
                }
            });

            return deferred.promise
        }

        this.get_data = function (qry) {
            var deferred = $q.defer();
            var endpoint = _spPageContextInfo.siteAbsoluteUrl + qry;         

            deferred.notify('notify endpoint:' + endpoint);
            $.ajax({
                url: endpoint,
                method: "GET",
                headers: { "Accept": "application/json; odata=verbose" },
                success: function (data) {
                    deferred.resolve(data);
                },
                error: function (data) {
                    deferred.reject(data);
                }, beforeSend: function () {
                    // Handle the beforeSend event
                    deferred.notify('notify beforesend');
                },
                complete: function () {
                    // Handle the complete event
                    deferred.notify('notify complete');
                }
            });

            return deferred.promise
        }

        this.get_type = function (qry) {
            var deferred = $q.defer();
            var endpoint = qry;
                                  
            deferred.notify('notify endpoint:' + endpoint);
            $.ajax({
                url: endpoint,
                method: "GET",
                headers: { "Accept": "application/json; odata=verbose" },
                success: function (data) {
                    deferred.resolve(data);
                },
                error: function (data) {
                    deferred.reject(data);
                }, beforeSend: function () {
                    // Handle the beforeSend event
                    deferred.notify('notify beforesend');
                },
                complete: function () {
                    // Handle the complete event
                    deferred.notify('notify complete');
                }
            });

            return deferred.promise
        }

        this.get_generic = function (qry) {
            var deferred = $q.defer();
            var endpoint = qry;         

            deferred.notify('notify endpoint:' + endpoint);
            $.ajax({
                url: endpoint,
                method: "GET",
                success: function (data) {
                    deferred.resolve(data);
                },
                error: function (data) {
                    deferred.reject(data);
                }, beforeSend: function () {
                    deferred.notify('notify beforesend');
                },
                complete: function () {
                    deferred.notify('notify complete');
                }
            });

            return deferred.promise
        }
        
    });
}(angular.module('spsmodule')));