(function (app) {
    app
        .controller('objetivosController', function ($scope, $rootScope, SweetAlert, spsservice, $filter, $location) {             
            $rootScope.menuActivo();
            $rootScope.obteniendoDatos = true;
            $scope.listName = "Objetivos";

             //cargar tabla inicial
            $rootScope.modulo = ""
            $rootScope.datatable = [];    
            $rootScope.data = [];       
          
            
            //obtener info de usuario conectado
            $scope.getUrlBase = function () {
                $scope.columnsGet = "Id,ID_de_objetivo,Propietario_x0020_del_x0020_obje,Categor_x00ed_a,Tipo_,Objetivo,Indicador,Meta,Ponderaci_x00f3_n,Tipo_x0020_de_x0020_C_x00e1_lcul,Real,OData__x0025__x0020_Final_x0020_de_x00,Fecha_x0020_de_x0020_Inicio,Fecha_x0020_de_x0020_T_x00e9_rmi,Nombre_x0020_de_x0020_usuario_x0,Unidad_x0020_de_x0020_Negocio,Sociedad,Propietario_x0020_del_x0020_obje0,Propietario_x0020_del_x0020_obje1,ID_x0020_de_x0020_usuario_x0020_,Propietario_x0020_del_x0020_obje2,Propietario_x0020_del_x0020_obje3,Nombre_x0020_del_x0020_superviso,Apellidos_x0020_del_x0020_superv,Estado";
                $scope.orderBy = "&$orderby=ID_de_objetivo";            
                $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('" + $scope.listName + "')/Items?$select=" + $scope.columnsGet + $scope.orderBy + "&$top=5000";                
                $rootScope.getData($scope.urlGetBase);
            }
                        
            //************ iniciar actualizar token para consulta base del listado
            try {
                $.ajax({
                    url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                    async: true,
                    type: "POST",
                    headers: {
                        "Accept": "application/json; odata=verbose"
                    },
                    success: function (response) {
                        var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                        $('#__REQUESTDIGEST').val(_DigestToken);

                        //############# LOGICA 
                        spsservice.get_data("/_api/web/currentuser?$expand=Groups").then(function (resp) {
                            if (resp.d.Groups.results.length > 0) { //tiene un grupo                        
                                $rootScope.user = {
                                    'Id': resp.d.Id,
                                    'Email': resp.d.Email,
                                    'Nombre': resp.d.Title,
                                    'Username': resp.d.Email.split("@")[0]
                                };
            
                                for (let index = 0; index < resp.d.Groups.results.length; index++) {
                                    //check administrador
                                    if (resp.d.Groups.results[index].Title == "Administradores") {
                                        $rootScope.isAdministrador = true;
                                    }
            
                                    //check evaluador
                                    if (resp.d.Groups.results[index].Title == "Evaluadores") {
                                        $rootScope.isEvaluador = true;
                                    }
                                }
            
                                //validar acceso al menu
                                if(!$rootScope.isAdministrador && $rootScope.isEvaluador){
                                    $location.path("/");
                                }
            
                                $scope.getUrlBase();
                            }
                        });

                    },
                    error: function () {
                        console.log("error refresh token");
                    }
                });
            } catch (err) {
                console.log("requestDigestToken error : " + err.message);
            }
            //************ fin actualizar token                              
            //end obtener info de usuario conectado

            $scope.generarReporte = function (data) {                                  
                    var itemsFilter = data;
                    if(itemsFilter.length > 0){                                               
                        var _exportObj = [];

                    for (let i = 0; i < itemsFilter.length; i++) {
                        _exportObj.push(
                            {   
                                'Estado': itemsFilter[i].Estado,
                                'ID de objetivo': itemsFilter[i].ID_de_objetivo,
                                'Propietario del objetivo Nombre de usuario': itemsFilter[i].Propietario_x0020_del_x0020_obje,
                                'Categoría': itemsFilter[i].Categor_x00ed_a,
                                'Tipo': itemsFilter[i].Tipo_,
                                'Objetivo': itemsFilter[i].Objetivo,
                                'Indicador': itemsFilter[i].Indicador,
                                'Meta': itemsFilter[i].Meta,
                                'Ponderación': itemsFilter[i].Ponderaci_x00f3_n,
                                'Tipo de Cálculo': itemsFilter[i].Tipo_x0020_de_x0020_C_x00e1_lcul,
                                'Real': itemsFilter[i].Real,
                                '% Final de Cumplimiento': itemsFilter[i].OData__x0025__x0020_Final_x0020_de_x00,
                                'Fecha de Inicio': itemsFilter[i].Fecha_x0020_de_x0020_Inicio,
                                'Fecha de Término': itemsFilter[i].Fecha_x0020_de_x0020_T_x00e9_rmi,
                                'Nombre de usuario de supervisor': itemsFilter[i].Nombre_x0020_de_x0020_usuario_x0,
                                'Unidad de Negocio': itemsFilter[i].Unidad_x0020_de_x0020_Negocio,
                                'Sociedad': itemsFilter[i].Sociedad,
                                'Propietario del objetivo Gerencia/Subgerencia': itemsFilter[i].Propietario_x0020_del_x0020_obje0,
                                'Propietario del objetivo Subdivisión de personal': itemsFilter[i].Propietario_x0020_del_x0020_obje1,
                                'ID de usuario del propietario del objetivo': itemsFilter[i].ID_x0020_de_x0020_usuario_x0020_,
                                'Propietario del objetivo Nombre': itemsFilter[i].Propietario_x0020_del_x0020_obje2,
                                'Propietario del objetivo Apellidos': itemsFilter[i].Propietario_x0020_del_x0020_obje3,
                                'Nombre del supervisor': itemsFilter[i].Nombre_x0020_del_x0020_superviso,
                                'Apellidos del supervisor': itemsFilter[i].Apellidos_x0020_del_x0020_superv
                            }
                        );                        
                    }
                    //generar excel from object               
                    var ws = XLSX.utils.json_to_sheet(_exportObj);
                    var wb = XLSX.utils.book_new();
                    XLSX.utils.book_append_sheet(wb, ws, "Objetivos");
                    var wbout = XLSX.write(wb, {
                        bookType: 'xlsx',
                        type: 'binary'
                    });

                    function s2ab(s) {
                        var buf = new ArrayBuffer(s.length);
                        var view = new Uint8Array(buf);
                        for (var i = 0; i != s.length; ++i) view[i] = s.charCodeAt(i) & 0xFF;
                        return buf;
                    }
                    saveAs(new Blob([s2ab(wbout)], {
                        type: "application/octet-stream"
                    }), "objetivos.xlsx");                           
                }
            };
                                 
            //crt
            $scope.eliminarLogico = function (id) {                
                SweetAlert.swal({
                        title: "¿Está seguro de Eliminar el objetivo?",
                        text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#ff8800",
                        confirmButtonText: "Si, Eliminar el objetivo!",
                        cancelButtonText: "Salir",
                        closeOnConfirm: true
                    },
                    function (isConfirm) {                        
                        if (isConfirm) {
                            
                            //************ iniciar actualizar token
                            try {
                                $.ajax({
                                    url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                                    async: true,
                                    type: "POST",
                                    headers: {
                                        "Accept": "application/json; odata=verbose"
                                    },
                                    success: function (response) {
                                        var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                                        $('#__REQUESTDIGEST').val(_DigestToken);

                                        //############# LOGICA 
                                        var url = "lists/getbytitle('Objetivos')/items(" + id + ")";
                                        var data = {
                                            '__metadata': {
                                                'type': 'SP.Data.ObjetivosListItem'
                                            },
                                            'Estado': 'Delete'

                                        };
                                        
                                        spsservice.put_data(url, data).then(function (response) {
                                            $rootScope.data.filter(function(item){
                                                if(item.Id == id){
                                                    item.Estado = "Delete"
                                                }
                                            });
                                        
                                            SweetAlert.swal("Objetivo eliminado", "", "success");
                                        });

                                    },
                                    error: function () {
                                        console.log("error refresh token");
                                    }
                                });
                            } catch (err) {
                                console.log("requestDigestToken error : " + err.message);
                            }
                            //************ fin actualizar token                                                        
                        }
                    });
            }

            //crt - volver al estado update
            $scope.actualizarLogico = function (id) {             
                SweetAlert.swal({
                        title: "¿Está seguro de actualizar el objetivo?",
                        text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#ff8800",
                        confirmButtonText: "Si, actualizar el objetivo!",
                        cancelButtonText: "Salir",
                        closeOnConfirm: true
                    },
                    function (isConfirm) {
                        if (isConfirm) {                            
                            //************ iniciar actualizar token
                            try {
                                $.ajax({
                                    url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                                    async: true,
                                    type: "POST",
                                    headers: {
                                        "Accept": "application/json; odata=verbose"
                                    },
                                    success: function (response) {
                                        var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                                        $('#__REQUESTDIGEST').val(_DigestToken);

                                        //############# LOGICA 
                                        var url = "lists/getbytitle('Objetivos')/items(" + id + ")";
                                        var data = {
                                            '__metadata': {
                                                'type': 'SP.Data.ObjetivosListItem'
                                            },
                                            'Estado': 'Update'

                                        };
                                        
                                        spsservice.put_data(url, data).then(function (response) {
                                            $rootScope.data.filter(function(item){
                                                if(item.Id == id){
                                                    item.Estado = "Update"
                                                }
                                            });
                                        
                                            SweetAlert.swal("Objetivo actualizado", "", "success");
                                        });

                                    },
                                    error: function () {
                                        console.log("error refresh token");
                                    }
                                });
                            } catch (err) {
                                console.log("requestDigestToken error : " + err.message);
                            }
                            //************ fin actualizar token                                                        
                        }
                    });
            }
        
            $scope.limpiarFiltros = function(){ 
                $rootScope.filtro = [];
            };

            $scope.obtenerSubgerencias = function(sociedad){
                $scope.subgerencias_sociedad = $rootScope.subgerencias.filter(x => x.Sociedad == sociedad);                 
            }                       
        })
}(angular.module('spsmodule')));