(function () {

    angular.module('spsmodule', [ 'ui.bootstrap', 'ngFileUpload' , 'ngRoute', 'ngSanitize', 'oitozero.ngSweetAlert','ngCsv', 'angular-js-xlsx'])
 
    .config(["$routeProvider", function ($routeProvider) {




        $routeProvider.when("/", {
            templateUrl: "../SitePages/pages/Home.html",
            controller: "homeController"
        })
        .when("/Administracion", {
            templateUrl: "../SitePages/pages/Administracion.html",
            controller: "administracionController"
        })

        .when("/Evaluaciones", {
            templateUrl: "../SitePages/pages/Evaluaciones.html",
            controller: "evaluacionesController"
        })
        .when("/Objetivos", {
            templateUrl: "../SitePages/pages/Objetivos.html",
            controller: "objetivosController"
        })
        .when("/Jefes", {
            templateUrl: "../SitePages/pages/Jefes.html",
            controller: "jefesController"
        })
        .when("/EscalasDeProduccion", {
            templateUrl: "../SitePages/pages/Escalas.html",
            controller: "escalasController"
        })
        .when("/Objetivos/:id", {
            templateUrl: "../SitePages/pages/detalleObjetivo.html",
            controller: "detalleObjetivo",
            resolve: {
                id: function ($route) {
                    return $route.current.params.id;
                }
            }
        })
        .when("/Jefe/:id", {
            templateUrl: "../SitePages/pages/detalleJefes.html",
            controller: "detalleJefes",
            resolve: {
                id: function ($route) {
                    return $route.current.params.id;
                }
            }
        })
    }])

    .directive('preventEnterSubmit', function () {
        return function (scope, el, attrs) {
          el.bind('keydown', function (event) {
            if (13 == event.which) {
                event.preventDefault(); // Doesn't work at all
                window.stop(); // Works in all browsers but IE...
                document.execCommand('Stop'); // Works in IE
                return false; // Don't even know why it's here. Does nothing.
            }
          });
        };
    })
    
    .directive('yrInteger', function () {
        return {
            restrict: 'A',
            link: function(scope, element, attrs) {
            
              element.on('keypress', function(event) {

                
        
                if ( !isIntegerChar() ) 
                  event.preventDefault();
                
                function isIntegerChar() {
                  return /[0-9.,]|-/.test(
                    String.fromCharCode(event.which))
                }
        
              })       
            
            }
        }
    });

})();