(function (app) {
    app
        .controller('jefesController', function ($scope, $rootScope, SweetAlert, spsservice, $filter, $location) {

            $rootScope.menuActivo();
            $rootScope.obteniendoDatos = true;            
            $scope.listName = "Jefes";

             //cargar tabla inicial
            $rootScope.modulo = ""
            $rootScope.datatable = [];    
            $rootScope.data = [];       
    
            
                     
            //obtener info de usuario conectado
            $scope.getUrlBase = function () {
                $scope.columnsGet = "Id,Estado,EVALUADOR,EVALUADO,NOMBRES_EVALUADOR,APELLIDOS_EVALUADOR,NOMBRES_EVALUADO,APELLIDOS_EVALUADO";
                $scope.orderBy = "&$orderby=EVALUADOR";            
                $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('" + $scope.listName + "')/Items?$select=" + $scope.columnsGet + $scope.orderBy + "&$top=5000";
                $rootScope.getData($scope.urlGetBase);
            }

          
            //************ iniciar actualizar token
            try {
                $.ajax({
                    url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                    async: true,
                    type: "POST",
                    headers: {
                        "Accept": "application/json; odata=verbose"
                    },
                    success: function (response) {
                        var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                        $('#__REQUESTDIGEST').val(_DigestToken);

                        //############# LOGICA 
                        spsservice.get_data("/_api/web/currentuser?$expand=Groups").then(function (resp) {
                            if (resp.d.Groups.results.length > 0) { //tiene un grupo                        
                                $rootScope.user = {
                                    'Id': resp.d.Id,
                                    'Email': resp.d.Email,
                                    'Nombre': resp.d.Title,
                                    'Username': resp.d.Email.split("@")[0]
                                };
            
                                for (let index = 0; index < resp.d.Groups.results.length; index++) {
                                    //check administrador
                                    if (resp.d.Groups.results[index].Title == "Administradores") {
                                        $rootScope.isAdministrador = true;
                                    }
            
                                    //check evaluador
                                    if (resp.d.Groups.results[index].Title == "Evaluadores") {
                                        $rootScope.isEvaluador = true;
                                    }
                                }
            
                                //validar acceso al menu
                                if(!$rootScope.isAdministrador && $rootScope.isEvaluador){
                                    $location.path("/");
                                }
            
                                $scope.getUrlBase();
                            }
                        });

                    },
                    error: function () {
                        console.log("error refresh token");
                    }
                });
            } catch (err) {
                console.log("requestDigestToken error : " + err.message);
            }
            //************ fin actualizar token
                   
            
            //end obtener info de usuario conectado
             

            $scope.generarReporte = function (data) {                                  
                var itemsFilter = data;
               
                    if(itemsFilter.length > 0){
                       
                        
                        var _exportObj = [];

                    for (let i = 0; i < itemsFilter.length; i++) {
                        
                        _exportObj.push(
                            {   
                                'EVALUADOR': itemsFilter[i].EVALUADOR,
                                'NOMBRES EVALUADOR': itemsFilter[i]["NOMBRES_EVALUADOR"],
                                'APELLIDOS EVALUADOR': itemsFilter[i]["APELLIDOS_EVALUADOR"],
                                'EVALUADO': itemsFilter[i].EVALUADO
                            }
                        );
                        
                    }



                    //generar excel from object               
                    var ws = XLSX.utils.json_to_sheet(_exportObj);
                    var wb = XLSX.utils.book_new();
                    XLSX.utils.book_append_sheet(wb, ws, "Jefes");
                    var wbout = XLSX.write(wb, {
                        bookType: 'xlsx',
                        type: 'binary'
                    });

                    function s2ab(s) {
                        var buf = new ArrayBuffer(s.length);
                        var view = new Uint8Array(buf);
                        for (var i = 0; i != s.length; ++i) view[i] = s.charCodeAt(i) & 0xFF;
                        return buf;
                    }
                    saveAs(new Blob([s2ab(wbout)], {
                        type: "application/octet-stream"
                    }), "Jefes.xlsx");   
                        
                    }
                                                  
      
            }
                    
            //crt
            $scope.eliminarLogico = function (id) {
                SweetAlert.swal({
                        title: "¿Está seguro de eliminar el jefe?",
                        text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#ff8800",
                        confirmButtonText: "Sí, Eliminar el jefe!",
                        cancelButtonText: "Salir",
                        closeOnConfirm: true
                    },
                    function (isConfirm) {
                        if (isConfirm) {   
                            
                            //************ iniciar actualizar token
                            try {
                                $.ajax({
                                    url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                                    async: true,
                                    type: "POST",
                                    headers: {
                                        "Accept": "application/json; odata=verbose"
                                    },
                                    success: function (response) {
                                        var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                                        $('#__REQUESTDIGEST').val(_DigestToken);

                                        //############# LOGICA 
                                        var url = "lists/getbytitle('" + $scope.listName + "')/items(" + id + ")";
                                        var data = {
                                            '__metadata': {
                                                'type': 'SP.Data.JefesListItem'
                                            },
                                            'Estado': 'Delete'

                                        };
                                        
                                        spsservice.put_data(url, data).then(function (response) {
                                            $rootScope.data.filter(function(item){
                                                if(item.Id == id){
                                                    item.Estado = "Delete"
                                                }
                                            });                          
                                            SweetAlert.swal("Jefe eliminado", "", "success");
                                        });

                                    },
                                    error: function () {
                                        console.log("error refresh token");
                                    }
                                });
                            } catch (err) {
                                console.log("requestDigestToken error : " + err.message);
                            }
                            //************ fin actualizar token                                                        
                        }
                    });
            }

            //crt
            $scope.actualizarLogico = function (id) {
                SweetAlert.swal({
                        title: "¿Está seguro de modificar el jefe?",
                        text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#ff8800",
                        confirmButtonText: "Sí, modificar el jefe!",
                        cancelButtonText: "Salir",
                        closeOnConfirm: true
                    },
                    function (isConfirm) {
                        if (isConfirm) {
                            //************ iniciar actualizar token
                            try {
                                $.ajax({
                                    url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                                    async: true,
                                    type: "POST",
                                    headers: {
                                        "Accept": "application/json; odata=verbose"
                                    },
                                    success: function (response) {
                                        var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                                        $('#__REQUESTDIGEST').val(_DigestToken);

                                        //############# LOGICA 
                                        var url = "lists/getbytitle('Jefes')/items(" + id + ")";
                                        var data = {
                                            '__metadata': {
                                                'type': 'SP.Data.JefesListItem'
                                            },
                                            'Estado': 'Modificado'

                                        };
                                        
                                        spsservice.put_data(url, data).then(function (response) {
                                            $rootScope.data.filter(function(item){
                                                if(item.Id == id){
                                                    item.Estado = "Modificado"
                                                }
                                            });
                                        
                                            SweetAlert.swal("Jefe modificado", "", "success");
                                        });

                                    },
                                    error: function () {
                                        console.log("error refresh token");
                                    }
                                });
                            } catch (err) {
                                console.log("requestDigestToken error : " + err.message);
                            }
                            //************ fin actualizar token                            
                        }
                    });
            }
        
            $scope.limpiarFiltros = function(){ 
                $rootScope.filtro = [];
            }

                
        })
}(angular.module('spsmodule')));