(function (app) {
    app
        .controller('evaluacionesController', function ($scope, $rootScope, spsservice, SweetAlert, $uibModal, $filter) {
            $rootScope.menuActivo();
            $rootScope.obteniendoDatos = true;
            //cargar tabla inicial
            $rootScope.modulo = "Evaluaciones"
            $rootScope.datatable = [];
            $rootScope.data = [];
                             
            //obtener info de usuario conectado
            debugger;
            $scope.getUrlBase = function () {
                if ($rootScope.isAdministrador) {
                    $scope.listName = "Objetivos";
                    $scope.columnsGet = "Estado,Id,Indicador_mod,ID_de_objetivo,OData__x0025__x0020_Final_x0020_de_x00,Categor_x00ed_a,Fecha_x0020_de_x0020_Inicio,Fecha_x0020_de_x0020_T_x00e9_rmi,Propietario_x0020_del_x0020_obje,Propietario_x0020_del_x0020_obje2,Propietario_x0020_del_x0020_obje3,Nombre_x0020_de_x0020_usuario_x0,Objetivo,Indicador,Tipo_x0020_de_x0020_C_x00e1_lcul,Meta,Ponderaci_x00f3_n,resultado,cumplimiento,OData__x0025__final_de_cumplimiento,cumplimiento_ponderado,tramo,Estado_envio";
                    $scope.orderBy = ""; // "&$orderby=Propietario_x0020_del_x0020_obje2";
                    $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('" + $scope.listName + "')/Items?$select=" + $scope.columnsGet + $scope.orderBy + "&$top=5000";     
                    //quitar filtro &$filter=Estado eq 'Update'                
                } else {
                    $scope.listName = "Objetivos";
                    $scope.columnsGet = "Estado,Id,ID_de_objetivo,OData__x0025__x0020_Final_x0020_de_x00,Fecha_x0020_de_x0020_Inicio,Fecha_x0020_de_x0020_T_x00e9_rmi,Categor_x00ed_a,Propietario_x0020_del_x0020_obje,Propietario_x0020_del_x0020_obje2,Propietario_x0020_del_x0020_obje3,Nombre_x0020_de_x0020_usuario_x0,Objetivo,Indicador,Tipo_x0020_de_x0020_C_x00e1_lcul,Meta,Ponderaci_x00f3_n,resultado,cumplimiento,OData__x0025__final_de_cumplimiento,cumplimiento_ponderado,tramo,Estado_envio";
                    $scope.orderBy = ""; // "&$orderby=ID_de_objetivo";
                    $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('" + $scope.listName + "')/Items?$select=" + $scope.columnsGet + $scope.orderBy + "&$filter=Nombre_x0020_de_x0020_usuario_x0 eq '" + $rootScope.user.Username + "'&$top=5000";
                    //and Estado eq 'Update'
                }
               
                $rootScope.getData($scope.urlGetBase);
            }

            
            //************ iniciar actualizar token
            try {
                $.ajax({
                    url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                    async: true,
                    type: "POST",
                    headers: {
                        "Accept": "application/json; odata=verbose"
                    },
                    success: function (response) {
                        var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                        $('#__REQUESTDIGEST').val(_DigestToken);

                        //############# LOGICA 
                        spsservice.get_data("/_api/web/currentuser?$expand=Groups").then(function (resp) {
                            if (resp.d.Groups.results.length > 0) { //tiene un grupo                        
                                $rootScope.user = {
                                    'Id': resp.d.Id,
                                    'Email': resp.d.Email,
                                    'Nombre': resp.d.Title,
                                    'Username': resp.d.Email.split("@")[0].toUpperCase() //pasar a mayusc
                                };
            
                                for (let index = 0; index < resp.d.Groups.results.length; index++) {
                                    //check administrador
                                    if (resp.d.Groups.results[index].Title == "Administradores") {
                                        $rootScope.isAdministrador = true;
                                    }
            
                                    //check evaluador
                                    if (resp.d.Groups.results[index].Title == "Evaluadores") {
                                        $rootScope.isEvaluador = true;
                                    }
                                }
                                $scope.getUrlBase();
                            }
                        });
                    },
                    error: function () {
                        console.log("error refresh token");
                    }
                });
            } catch (err) {
                console.log("requestDigestToken error : " + err.message);
            }
            //************ fin actualizar token
                              
            //end obtener info de usuario conectado
                 
            //crt
            $scope.actualizarCalculo = function (datos) {

                console.log("ID: " + datos.ID_de_objetivo);

                //************ iniciar actualizar token
                try {
                    $.ajax({
                        url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                        async: true,
                        type: "POST",
                        headers: {
                            "Accept": "application/json; odata=verbose"
                        },
                        success: function (response) {
                            var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                            $('#__REQUESTDIGEST').val(_DigestToken);

                            //############# LOGICA 
                            for (let i = 0; i < $rootScope.data.length; i++) {
                                //inverso
                                if ($rootScope.data[i].ID_de_objetivo == datos.ID_de_objetivo) {
                                    if (datos.Tipo_x0020_de_x0020_C_x00e1_lcul == "Inverso") {
                                        $rootScope.data[i].cumplimiento = ((2 - (datos.resultado / datos.Meta)) * 100).toFixed(1);
                                        $rootScope.data[i].Estado_envio = "Pendiente de envío";
                                        var _porcFinalCumpliento = $rootScope.data[i].cumplimiento;
                                        $rootScope.data[i].OData__x0025__final_de_cumplimiento = _porcFinalCumpliento >= 130 ? 130 : _porcFinalCumpliento;
            
                                    } else { // directo                                        
                                        $rootScope.data[i].cumplimiento = ((datos.resultado / datos.Meta) * 100).toFixed(1);
                                        $rootScope.data[i].Estado_envio = "Pendiente de envío";            
                                        var _porcFinalCumpliento = $rootScope.data[i].cumplimiento;                        
                                        $rootScope.data[i].OData__x0025__final_de_cumplimiento = _porcFinalCumpliento >= 130 ? 130 : _porcFinalCumpliento;
                                        //verificar la escala                        
                                        if (datos.Indicador_mod != "Sin escala") {
            
                                            for (let j = 0; j < datos.TramosEscala.length; j++) {
                                                //buscar tramo
                                                if ($rootScope.data[i].cumplimiento >= parseFloat(datos.TramosEscala[j].desde) && $rootScope.data[i].cumplimiento <= parseFloat(datos.TramosEscala[j].hasta)) {
                                                    //este es el tramo
                                                    $rootScope.data[i].OData__x0025__final_de_cumplimiento = datos.TramosEscala[j].ponderacion;
                                                    break;
                                                }
                                            }
                                        }
                                    }
                                    //termino logico tipo de calculo
            

                                    //calculos de cumplimientos
                                    $rootScope.data[i].cumplimiento_ponderado = ($rootScope.data[i].OData__x0025__final_de_cumplimiento * (datos.Ponderaci_x00f3_n / 100)).toFixed(1).toString();                       

                                    
                                    //Evaluacion del resultado de cumplimiento
                                    if ($rootScope.data[i].cumplimiento < 0) {
                                        SweetAlert.swal("El cumplimiento calculado es inferior a cero. Verificar resultado ingresado y volver a calcular.", "", "error");
                                        $rootScope.data[i].Estado_envio = "No evaluado"
                                    }
               
                                    var data = {
                                        '__metadata': {
                                            'type': 'SP.Data.ObjetivosListItem'
                                        },
                                        'cumplimiento': ($rootScope.data[i].cumplimiento).toString(),
                                        'resultado': $rootScope.data[i].resultado,
                                        'OData__x0025__final_de_cumplimiento': ($rootScope.data[i].OData__x0025__final_de_cumplimiento).toString(),
                                        'cumplimiento_ponderado': $rootScope.data[i].cumplimiento_ponderado,
                                        'Estado_envio': $rootScope.data[i].Estado_envio
                                    };
                                    spsservice.put_data("lists/getbytitle('Objetivos')/items(" + $rootScope.data[i].ID + ")", data).then(function(){

                                        $rootScope.data[i].cumplimiento = $rootScope.data[i].cumplimiento;


                                    })
                                    break;
                                }                                                
                            }

                        },
                        error: function () {
                            console.log("error refresh token");
                        }
                    });
                } catch (err) {
                    console.log("requestDigestToken error : " + err.message);
                }
                //************ fin actualizar token                               
            };

            $scope.limpiarCalculo = function (datos) {

                //************ iniciar actualizar token
                try {
                    $.ajax({
                        url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                        async: true,
                        type: "POST",
                        headers: {
                            "Accept": "application/json; odata=verbose"
                        },
                        success: function (response) {
                            var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                            $('#__REQUESTDIGEST').val(_DigestToken);

                            //############# LOGICA 
                            for (let i = 0; i < $rootScope.data.length; i++) {

                                if ($rootScope.data[i].ID == datos.ID) {
            
                                    $rootScope.data[i].cumplimiento = null
                                    $rootScope.data[i].resultado = null
                                    $rootScope.data[i].Estado_envio = "No evaluado"
                                    $rootScope.data[i].OData__x0025__final_de_cumplimiento = null
                                    $rootScope.data[i].cumplimiento_ponderado = null
            
                                    var data = {
                                        '__metadata': {
                                            'type': 'SP.Data.ObjetivosListItem'
                                        },
                                        'cumplimiento': null,
                                        'resultado': null,
                                        'OData__x0025__final_de_cumplimiento': null,
                                        'cumplimiento_ponderado': null,
                                        'Estado_envio': "No evaluado"
            
                                    };
            
                                    spsservice.put_data("lists/getbytitle('Objetivos')/items(" + $rootScope.data[i].ID + ")", data).then(function() {
                                        $rootScope.data[i].cumplimiento = $rootScope.data[i].cumplimiento;
                                    })
            
                                    break;
                                }
                            }

                        },
                        error: function () {
                            console.log("error refresh token");
                        }
                    });
                } catch (err) {
                    console.log("requestDigestToken error : " + err.message);
                }
                //************ fin actualizar token                
            };

            $scope.generarReporte = function (data) {
                var itemsFilter = data;

                if (itemsFilter.length > 0) {
                    var _exportObj = [];
                    for (let i = 0; i < itemsFilter.length; i++) {
                        _exportObj.push({
                            'Estado': itemsFilter[i].Estado,
                            'Usuario evaluado': itemsFilter[i].Propietario_x0020_del_x0020_obje,
                            'Nombres evaluado': itemsFilter[i].Propietario_x0020_del_x0020_obje2,
                            'Apellidos evaluado': itemsFilter[i].Propietario_x0020_del_x0020_obje3,
                            'Id del objetivo': itemsFilter[i].ID_de_objetivo,
                            'Objetivo': itemsFilter[i].Objetivo,
                            'Indicador': itemsFilter[i].Indicador,
                            'Escala': itemsFilter[i].Indicador_mod,
                            'Tipo de cálculo': itemsFilter[i].Tipo_x0020_de_x0020_C_x00e1_lcul,
                            'Meta': itemsFilter[i].Meta,
                            'Ponderación': itemsFilter[i].Ponderaci_x00f3_n,
                            'Resultado': itemsFilter[i].resultado,
                            'Cumplimiento': itemsFilter[i].cumplimiento,
                            '% Final de Cumplimiento': itemsFilter[i].OData__x0025__final_de_cumplimiento,
                            'Cumplimiento ponderado': itemsFilter[i].cumplimiento_ponderado,
                        });
                    }

                    //generar excel from object               
                    var ws = XLSX.utils.json_to_sheet(_exportObj);
                    var wb = XLSX.utils.book_new();
                    XLSX.utils.book_append_sheet(wb, ws, "Evaluaciones");
                    var wbout = XLSX.write(wb, {
                        bookType: 'xlsx',
                        type: 'binary'
                    });

                    function s2ab(s) {
                        var buf = new ArrayBuffer(s.length);
                        var view = new Uint8Array(buf);
                        for (var i = 0; i != s.length; ++i) view[i] = s.charCodeAt(i) & 0xFF;
                        return buf;
                    }
                    saveAs(new Blob([s2ab(wbout)], {
                        type: "application/octet-stream"
                    }), "Evaluaciones.xlsx");

                }

            };

            $scope.filtrarCSV = function(data){        
    

                $scope.dataExportDataFinal = [];


                 //reutilizar for para armar arreglo arrCargaFinal
                 $scope.dataExportDataFinal = [{
                    'col1': 'OBJ_PLAN_ID',
                    'col2': 6
                }];

                $scope.dataExportDataFinal.push({
                    'col1': 'OBJ_PLAN_NAME',
                    'col2': 'Objetivos ' + $rootScope.anoActual
                })

                $scope.dataExportDataFinal.push({
                    'col1': 'DATE',
                    'col2': 'Mon Jul 08 15:13:02 UTC ' + $rootScope.anoActual
                })

                $scope.dataExportDataFinal.push({
                    'col1': 'MAX_ERROR'
                })

                //columns                     
                $scope.dataExportDataFinal.push({
                    'col1': '^TYPE',
                    'col2': 'ACTION',
                    'col3': 'ID',
                    'col4': 'SUBID',
                    'col5': 'GUID',
                    'col6': 'SUBGUID',
                    'col7': 'FILTER_USERNAME',
                    'col8': 'FILTER_MGR_ID',
                    'col9': 'FILTER_CUSTOM05',
                    'col0': 'FILTER_DEPT',
                    'col11': 'FILTER_DIV',
                    'col12': 'FILTER_JOBCODE',
                    'col13': 'FILTER_LOC',
                    'col14': 'OBJECTIVE_CATEGORY',
                    'col15': 'OBJECTIVE_PARENTID',
                    'col16': 'OBJECTIVE_PUBLIC',
                    'col17': 'OBJECTIVE_name',
                    'col18': 'OBJECTIVE_metric',
                    'col19': 'OBJECTIVE_bizx-target',
                    'col20': 'OBJECTIVE_weight',
                    'col21': 'OBJECTIVE_tipocalc',
                    'col22': 'OBJECTIVE_target-baseline', // OBJECTIVE_target-baseline
                    'col23': 'OBJECTIVE_bizx-actual',
                    'col24': 'OBJECTIVE_actual-achievement',
                    'col25': 'OBJECTIVE_rating',
                    'col26': 'OBJECTIVE_start',
                    'col27': 'OBJECTIVE_due',
                    'col28': 'METRICLOOKUP_achievement',
                    'col29': 'METRICLOOKUP_rating'
                });

                debugger;

                for (let i = 0; i < data.length; i++) {                                                                            
                    $scope.dataExportDataFinal.push({
                        'col1': 'OBJECTIVE',
                        'col2': data[i].Estado.toUpperCase(), //'ACTION' ,
                        'col3': data[i].ID_de_objetivo, //'ID',
                        'col4': '', //'SUBID',
                        'col5': '', //'GUID',
                        'col6': '', //'SUBGUID',
                        'col7': data[i].Propietario_x0020_del_x0020_obje, //'FILTER_USERNAME',
                        'col8': '', //'FILTER_MGR_ID',
                        'col9': '', //'FILTER_CUSTOM05',
                        'col0': '', //'FILTER_DEPT',
                        'col11': '', //'FILTER_DIV',
                        'col12': '', //'FILTER_JOBCODE',
                        'col13': '', //'FILTER_LOC',
                        'col14': data[i].Categor_x00ed_a, //'OBJECTIVE_CATEGORY',
                        'col15': '', //'OBJECTIVE_PARENTID',
                        'col16': 'Y', //'OBJECTIVE_PUBLIC',
                        'col17': data[i].Objetivo.replace(/(?:\r\n|\r|\n)/g, " "), // 'OBJECTIVE_name',
                        'col18': data[i].Indicador.replace(/(?:\r\n|\r|\n)/g, " "), //'OBJECTIVE_metric',
                        'col19': data[i].Meta, //'OBJECTIVE_bizx-target',
                        'col20': data[i].Ponderaci_x00f3_n, //'OBJECTIVE_weight',
                        'col21': data[i].Tipo_x0020_de_x0020_C_x00e1_lcul == "Directo" ? 1 : 2 , 
                        'col22': 100, //'OBJECTIVE_target-baseline',
                        'col23': data[i].resultado, //'OBJECTIVE_bizx-actual',
                        'col24': data[i].OData__x0025__final_de_cumplimiento, // BECTIVE_actual-achievement',
                        'col25': '', //'OBJECTIVE_rating',
                        'col26': '0' + data[i].Fecha_x0020_de_x0020_Inicio, //'OBJECTIVE_start',
                        'col27': data[i].Fecha_x0020_de_x0020_T_x00e9_rmi, //'OBJECTIVE_due',
                        'col28': '', //'METRICLOOKUP_achievement',
                        'col29': '', //'METRICLOOKUP_rating'
                    })
                }
                return $scope.dataExportDataFinal;
            }

            $scope.filtrarDeleteCSV = function(){        
                

                $scope.dataExportDataFinal = [];


                 //reutilizar for para armar arreglo arrCargaFinal
                 $scope.dataExportDataFinal = [{
                    'col1': 'OBJ_PLAN_ID',
                    'col2': 6
                }];

                $scope.dataExportDataFinal.push({
                    'col1': 'OBJ_PLAN_NAME',
                    'col2': 'Objetivos ' + $rootScope.anoActual
                })

                $scope.dataExportDataFinal.push({
                    'col1': 'DATE',
                    'col2': 'Mon Jul 08 15:13:02 UTC ' + $rootScope.anoActual
                })

                $scope.dataExportDataFinal.push({
                    'col1': 'MAX_ERROR'
                })

                //columns                     
                $scope.dataExportDataFinal.push({
                    'col1': '^TYPE',
                    'col2': 'ACTION',
                    'col3': 'ID',
                    'col4': 'SUBID',
                    'col5': 'GUID',
                    'col6': 'SUBGUID',
                    'col7': 'FILTER_USERNAME',
                    'col8': 'FILTER_MGR_ID',
                    'col9': 'FILTER_CUSTOM05',
                    'col0': 'FILTER_DEPT',
                    'col11': 'FILTER_DIV',
                    'col12': 'FILTER_JOBCODE',
                    'col13': 'FILTER_LOC',
                    'col14': 'OBJECTIVE_CATEGORY',
                    'col15': 'OBJECTIVE_PARENTID',
                    'col16': 'OBJECTIVE_PUBLIC',
                    'col17': 'OBJECTIVE_name',
                    'col18': 'OBJECTIVE_metric',
                    'col19': 'OBJECTIVE_bizx-target',
                    'col20': 'OBJECTIVE_weight',
                    'col21': 'OBJECTIVE_tipocalc',
                    'col22': 'OBJECTIVE_target-baseline', // OBJECTIVE_target-baseline
                    'col23': 'OBJECTIVE_bizx-actual',
                    'col24': 'OBJECTIVE_actual-achievement',
                    'col25': 'OBJECTIVE_rating',
                    'col26': 'OBJECTIVE_start',
                    'col27': 'OBJECTIVE_due',
                    'col28': 'METRICLOOKUP_achievement',
                    'col29': 'METRICLOOKUP_rating'
                });

        

                for (let i = 0; i < $rootScope.dataDelete.length; i++) {                                                                            
                    $scope.dataExportDataFinal.push({
                        'col1': 'OBJECTIVE',
                        'col2': $rootScope.dataDelete[i].Estado.toUpperCase(), //'ACTION' ,
                        'col3': $rootScope.dataDelete[i].ID_de_objetivo, //'ID',
                        'col4': '', //'SUBID',
                        'col5': '', //'GUID',
                        'col6': '', //'SUBGUID',
                        'col7': $rootScope.dataDelete[i].Propietario_x0020_del_x0020_obje, //'FILTER_USERNAME',
                        'col8': '', //'FILTER_MGR_ID',
                        'col9': '', //'FILTER_CUSTOM05',
                        'col0': '', //'FILTER_DEPT',
                        'col11': '', //'FILTER_DIV',
                        'col12': '', //'FILTER_JOBCODE',
                        'col13': '', //'FILTER_LOC',
                        'col14': $rootScope.dataDelete[i].Categor_x00ed_a, //'OBJECTIVE_CATEGORY',
                        'col15': '', //'OBJECTIVE_PARENTID',
                        'col16': 'Y', //'OBJECTIVE_PUBLIC',
                        'col17': $rootScope.dataDelete[i].Objetivo.replace(/(?:\r\n|\r|\n)/g, " "), // 'OBJECTIVE_name',
                        'col18': $rootScope.dataDelete[i].Indicador.replace(/(?:\r\n|\r|\n)/g, " "), //'OBJECTIVE_metric',
                        'col19': $rootScope.dataDelete[i].Meta, //'OBJECTIVE_bizx-target',
                        'col20': $rootScope.dataDelete[i].Ponderaci_x00f3_n, //'OBJECTIVE_weight',
                        'col21': $rootScope.dataDelete[i].Tipo_x0020_de_x0020_C_x00e1_lcul == "Directo" ? 1 : 2 , 
                        'col22': 100, //'OBJECTIVE_target-baseline',
                        'col23': $rootScope.dataDelete[i].resultado, //'OBJECTIVE_bizx-actual',
                        'col24': $rootScope.dataDelete[i].OData__x0025__final_de_cumplimiento, // BECTIVE_actual-achievement',
                        'col25': '', //'OBJECTIVE_rating',
                        'col26': '0' + $rootScope.dataDelete[i].Fecha_x0020_de_x0020_Inicio, //'OBJECTIVE_start',
                        'col27': $rootScope.dataDelete[i].Fecha_x0020_de_x0020_T_x00e9_rmi, //'OBJECTIVE_due',
                        'col28': '', //'METRICLOOKUP_achievement',
                        'col29': '', //'METRICLOOKUP_rating'
                    })
                }
                return $scope.dataExportDataFinal;
            }

            //crt
            $scope.enviarPendientesEvaluar = function (data) {                              
                SweetAlert.swal({
                        title: "¿Está seguro de evaluar los pendientes?",
                        text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#ff8800",
                        confirmButtonText: "Si, evaluar pendientes!",
                        cancelButtonText: "Salir",
                        closeOnConfirm: true
                    },
                    function (isConfirm) {
                        if (isConfirm) {
 
                            //************ iniciar actualizar token
                            try {
                                $.ajax({
                                    url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                                    async: true,
                                    type: "POST",
                                    headers: {
                                        "Accept": "application/json; odata=verbose"
                                    },
                                    success: function (response) {
                                        var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                                        $('#__REQUESTDIGEST').val(_DigestToken);

                                        //############# LOGICA 
                                        for (let i = 0; i < $rootScope.data.length; i++) {

                                            if ($rootScope.data[i].Estado_envio == "Pendiente de envío" && $rootScope.data[i].resultado >= 0) {
            
                                                $rootScope.data[i].Estado_envio = "Enviado"
            
                                                var data = {
                                                    '__metadata': {
                                                        'type': 'SP.Data.ObjetivosListItem'
                                                    },
            
                                                    'Estado_envio': $rootScope.data[i].Estado_envio
            
                                                };
                                                
                                                spsservice.put_data("lists/getbytitle('Objetivos')/items(" + $rootScope.data[i].ID + ")", data).then(function (){
                                                    $rootScope.data[i].Estado_envio = "Enviado";
                                                });
                                            }
                                        }

                                    },
                                    error: function () {
                                        console.log("error refresh token");
                                    }
                                });
                            } catch (err) {
                                console.log("requestDigestToken error : " + err.message);
                            }
                            //************ fin actualizar token                            
                        }
                    });
            }

            //crt
            $scope.volverNoEvaluado = function (datos) {                              
                SweetAlert.swal({
                        title: "¿Está seguro de cambiar el estado?",
                        text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#ff8800",
                        confirmButtonText: "Si, cambiar estado!",
                        cancelButtonText: "Salir",
                        closeOnConfirm: true
                    },
                    function (isConfirm) {
                        if (isConfirm) {


                            //************ iniciar actualizar token
                            try {
                                $.ajax({
                                    url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                                    async: true,
                                    type: "POST",
                                    headers: {
                                        "Accept": "application/json; odata=verbose"
                                    },
                                    success: function (response) {
                                        var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                                        $('#__REQUESTDIGEST').val(_DigestToken);

                                        //############# LOGICA 
                                        for (let i = 0; i < $rootScope.data.length; i++) {

                                            if ($rootScope.data[i].ID == datos.ID) {
            
                                                $rootScope.data[i].Estado_envio = "No evaluado"
            
                                                $rootScope.data[i].cumplimiento = null;
                                                $rootScope.data[i].resultado = null;
                                                $rootScope.data[i].OData__x0025__final_de_cumplimiento = null;
                                                $rootScope.data[i].cumplimiento_ponderado = null;
            
                                                var data = {
                                                    '__metadata': {
                                                        'type': 'SP.Data.ObjetivosListItem'
                                                    },
            
                                                    'Estado_envio': 'No evaluado'
            
                                                };
                                                                       
                                                spsservice.put_data("lists/getbytitle('Objetivos')/items(" + $rootScope.data[i].ID + ")", data).then(function (){
                                                    $rootScope.data[i].cumplimiento = null;
                                                });
            
                                                break;
            
                                            }
                                        }

                                    },
                                    error: function () {
                                        console.log("error refresh token");
                                    }
                                });
                            } catch (err) {
                                console.log("requestDigestToken error : " + err.message);
                            }
                            //************ fin actualizar token                            
                        }
                    });


            }

            $scope.mostrarTramos = function (tramosJSON, size, parentSelector) {

                $rootScope.tramosJson = tramosJSON;

                var parentElem = parentSelector ?
                    angular.element($document[0].querySelector('.modal-demo ' + parentSelector)) : undefined;
                var modalInstance = $uibModal.open({
                    animation: $scope.animationsEnabled,
                    ariaLabelledBy: 'modal-title',
                    ariaDescribedBy: 'modal-body',
                    templateUrl: 'pages/modals/tramos.html',
                    controller: 'tramosController',
                    controllerAs: '$scope',
                    size: size,
                    appendTo: parentElem,
                    resolve: {
                        items: function () {
                            return $scope.items;
                        }
                    }
                });


            };

            $scope.limpiarFiltros = function () {
                $rootScope.filtro = [];
            };
                                  
        })


        .controller('tramosController', function ($scope, $uibModalInstance) {
            $scope.cancel = function () {
                $uibModalInstance.dismiss('cancel');
            }
        })

}(angular.module('spsmodule')));