(function (app) {
    app
        .controller('escalasController', function ($scope, $rootScope, SweetAlert, spsservice, $filter, $location) {             
            $rootScope.menuActivo();
            $rootScope.obteniendoDatos = true;
            
            $scope.listName = "Escalas_de_produccion";
             //cargar tabla inicial
            $rootScope.datatable = [];    
            $rootScope.data = [];  
                
           
         
            

            //obtener info de usuario conectado
            $scope.getUrlBase = function () {
                $scope.columnsGet = "Id,escalas,nivel,desde,hasta,porcentaje1,ponderacion,porcentaje2";
                $scope.orderBy = "&$orderby=escalas desc, nivel asc";            
                $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('" + $scope.listName + "')/Items?$select=" + $scope.columnsGet + $scope.orderBy + "&$top=5000";
                $rootScope.getData($scope.urlGetBase);
            }
  
                
            //************ iniciar actualizar token
            try {
                $.ajax({
                    url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                    async: true,
                    type: "POST",
                    headers: {
                        "Accept": "application/json; odata=verbose"
                    },
                    success: function (response) {
                        var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                        $('#__REQUESTDIGEST').val(_DigestToken);

                        //############# LOGICA 
                        spsservice.get_data("/_api/web/currentuser?$expand=Groups").then(function (resp) {
                            if (resp.d.Groups.results.length > 0) { //tiene un grupo                        
                                $rootScope.user = {
                                    'Id': resp.d.Id,
                                    'Email': resp.d.Email,
                                    'Nombre': resp.d.Title,
                                    'Username': resp.d.Email.split("@")[0]
                                };
            
                                for (let index = 0; index < resp.d.Groups.results.length; index++) {
                                    //check administrador
                                    if (resp.d.Groups.results[index].Title == "Administradores") {
                                        $rootScope.isAdministrador = true;
                                    }
            
                                    //check evaluador
                                    if (resp.d.Groups.results[index].Title == "Evaluadores") {
                                        $rootScope.isEvaluador = true;
                                    }
                                }
            
                                //validar acceso al menu
                                if(!$rootScope.isAdministrador && $rootScope.isEvaluador){
                                    $location.path("/");
                                }
            
                                $scope.getUrlBase();
                            }
                        });

                    },
                    error: function () {
                        console.log("error refresh token");
                    }
                });
            } catch (err) {
                console.log("requestDigestToken error : " + err.message);
            }
            //************ fin actualizar token
            
            //end obtener info de usuario conectado



            $scope.generarReporte = function (data) {  

                
                var itemsFilter = data;
               
                    if(itemsFilter.length > 0){
                       
                        
                        var _exportObj = [];

                    for (let i = 0; i < itemsFilter.length; i++) {
                        _exportObj.push(
                            {   

                                'escalas': itemsFilter[i].escalas,
                                'nivel': itemsFilter[i].nivel,
                                'desde': itemsFilter[i].desde,
                                'hasta': itemsFilter[i].hasta,
                                'porcentaje1': itemsFilter[i].porcentaje1,
                                'ponderacion': itemsFilter[i].ponderacion,
                                'porcentaje2': itemsFilter[i].porcentaje1

                            }
                        );
                        
                    }


                    //generar excel from object               
                    var ws = XLSX.utils.json_to_sheet(_exportObj);
                    var wb = XLSX.utils.book_new();
                    XLSX.utils.book_append_sheet(wb, ws, "EscalasdeProducción");
                    var wbout = XLSX.write(wb, {
                        bookType: 'xlsx',
                        type: 'binary'
                    });

                    function s2ab(s) {
                        var buf = new ArrayBuffer(s.length);
                        var view = new Uint8Array(buf);
                        for (var i = 0; i != s.length; ++i) view[i] = s.charCodeAt(i) & 0xFF;
                        return buf;
                    }
                    saveAs(new Blob([s2ab(wbout)], {
                        type: "application/octet-stream"
                    }), "escalas_produccion.xlsx");   
                        
                    }
            };
                                 
                    
            $scope.limpiarFiltros = function(){ 
                $rootScope.filtro = [];
            };



           
        })
}(angular.module('spsmodule')));