(function (app) {
    app
        .controller('detalleObjetivo', function ($scope, $rootScope, SweetAlert, spsservice, id) {

            $scope.bloqueoInput = true;

            //************ iniciar actualizar token con crt
            try {
                $.ajax({
                    url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                    async: true,
                    type: "POST",
                    headers: {
                        "Accept": "application/json; odata=verbose"
                    },
                    success: function (response) {
                        var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                        $('#__REQUESTDIGEST').val(_DigestToken);

                        //############# LOGICA 
                        var getList = spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('Objetivos')/Items?$select=Id,ID_de_objetivo,	Propietario_x0020_del_x0020_obje,Categor_x00ed_a,Tipo_,Objetivo,Indicador,Meta,Ponderaci_x00f3_n,Tipo_x0020_de_x0020_C_x00e1_lcul,Real,OData__x0025__x0020_Final_x0020_de_x00,Fecha_x0020_de_x0020_Inicio,Fecha_x0020_de_x0020_T_x00e9_rmi,Nombre_x0020_de_x0020_usuario_x0,Unidad_x0020_de_x0020_Negocio,Sociedad,Propietario_x0020_del_x0020_obje0,Propietario_x0020_del_x0020_obje1,ID_x0020_de_x0020_usuario_x0020_,Propietario_x0020_del_x0020_obje2,Propietario_x0020_del_x0020_obje3,Nombre_x0020_del_x0020_superviso,Apellidos_x0020_del_x0020_superv&$filter=Id eq " + id);
                        getList.then(function (resp_sup) {
                            if (resp_sup.d.results.length > 0) {
                                $scope.objetivosDetalle = resp_sup.d.results[0];
                            }            
                        });

                    },
                    error: function () {
                        console.log("error refresh token");
                    }
                });
            } catch (err) {
                console.log("requestDigestToken error : " + err.message);
            }
            //************ fin actualizar token
            
            
            $scope.editarObjetivo = function () {
                $scope.bloqueoInput = false;
            }

            //crt
            $scope.guardarEdicion = function () {                
                SweetAlert.swal({
                        title: "¿Está seguro de modificar el objetivo?",
                        text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#ff8800",
                        confirmButtonText: "Si, modificar el objetivo!",
                        cancelButtonText: "Salir",
                        closeOnConfirm: true
                    },
                    function (isConfirm) {
                        if (isConfirm) {
                            
                            //************ iniciar actualizar token
                            try {
                                $.ajax({
                                    url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                                    async: true,
                                    type: "POST",
                                    headers: {
                                        "Accept": "application/json; odata=verbose"
                                    },
                                    success: function (response) {
                                        var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                                        $('#__REQUESTDIGEST').val(_DigestToken);

                                        //############# LOGICA 
                                        var url = "lists/getbytitle('Objetivos')/items(" + id + ")";
                                        var data = {
                                            '__metadata': {
                                                'type': 'SP.Data.ObjetivosListItem'
                                            },
                                            // 'Propietario_x0020_del_x0020_obje': $scope.objetivosDetalle.Propietario_x0020_del_x0020_obje

                                        };
                                        
                                        var guardarEdicion = spsservice.put_data(url, $scope.objetivosDetalle);
                                        guardarEdicion.then(function (rGuardarEdicion) {
                                            $scope.bloqueoInput = true;
                                            SweetAlert.swal("Objetivo modificado", "", "success");
                                        });

                                    },
                                    error: function () {
                                        console.log("error refresh token");
                                    }
                                });
                            } catch (err) {
                                console.log("requestDigestToken error : " + err.message);
                            }
                            //************ fin actualizar token                                                        
                        }
                    });
            }

            $scope.cancelarEdicion = function () {
                $scope.bloqueoInput = true;
            }

        })

}(angular.module('spsmodule')));