(function (app) {
    app
        .controller('detalleJefes', function ($scope, $rootScope, $route, SweetAlert, spsservice, id) {

            $scope.bloqueoInput = true;

            //************ iniciar actualizar token
            try {
                $.ajax({
                    url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                    async: true,
                    type: "POST",
                    headers: {
                        "Accept": "application/json; odata=verbose"
                    },
                    success: function (response) {
                        var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                        $('#__REQUESTDIGEST').val(_DigestToken);

                        //############# LOGICA 
                        var getList = spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('Jefes')/Items?$select=NOMBRES_EVALUADOR,APELLIDOS_EVALUADOR,Id,Estado,EVALUADOR,EVALUADO,NOMBRES_EVALUADO,APELLIDOS_EVALUADO&$filter=Id eq " + id);
                        getList.then(function (resp_sup) {                                
                            if (resp_sup.d.results.length > 0) {
                                $scope.detalleJefes = resp_sup.d.results[0];
                                $scope.evaluadorAntiguo = resp_sup.d.results[0].EVALUADOR;
                                $scope.nombresEvaluadorAntiguo = resp_sup.d.results[0].NOMBRES_EVALUADOR;
                                $scope.apellidosEvaluadorAntiguo = resp_sup.d.results[0].APELLIDOS_EVALUADOR;
                                $scope.nombresEvaluadoAntiguo = resp_sup.d.results[0].NOMBRES_EVALUADO;
                                $scope.apellidosEvaluadoAntiguo = resp_sup.d.results[0].APELLIDOS_EVALUADO;
                            }
                        });
                    },
                    error: function () {
                        console.log("error refresh token");
                    }
                });
            } catch (err) {
                console.log("requestDigestToken error : " + err.message);
            }
            //************ fin actualizar token


            

            $scope.editarJefe = function () {

                $scope.bloqueoInput = false;
            }

            //crt
            $scope.guardarEdicion = function () {
                SweetAlert.swal({
                        title: "¿Está seguro de modificar el jefe?",
                        text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#ff8800",
                        confirmButtonText: "Sí, modificar el jefe!",
                        cancelButtonText: "Salir",
                        closeOnConfirm: true
                    },
                    function (isConfirm) {
                        if (isConfirm) {


                            //************ iniciar actualizar token
                            try {
                                $.ajax({
                                    url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                                    async: true,
                                    type: "POST",
                                    headers: {
                                        "Accept": "application/json; odata=verbose"
                                    },
                                    success: function (response) {
                                        var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                                        $('#__REQUESTDIGEST').val(_DigestToken);

                                        //############# LOGICA 
                                        var url = "lists/getbytitle('Jefes')/items(" + id + ")";
                                        var data = {
                                            '__metadata': {
                                                'type': 'SP.Data.JefesListItem'
                                            },
                                            'Estado': 'Modificado',
                                            'EVALUADOR': $scope.detalleJefes.EVALUADOR,
                                            'NOMBRES_EVALUADOR': $scope.detalleJefes.NOMBRES_EVALUADOR,
                                            'APELLIDOS_EVALUADOR': $scope.detalleJefes.APELLIDOS_EVALUADOR,

                                        };
                                        
                                        var guardarEdicion = spsservice.put_data(url, data);
                                        guardarEdicion.then(function (rGuardarEdicion) {
                                            
                                            // hacer get revisar this
                                            spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('Objetivos')/Items?&select=ID&$filter=Nombre_x0020_de_x0020_usuario_x0 eq '" + $scope.evaluadorAntiguo + "' and Propietario_x0020_del_x0020_obje eq '" + $scope.detalleJefes.EVALUADO +"'").then(function (resp_sup){
                                                
                                                console.log(resp_sup)
                                                for (let i = 0; i < resp_sup.d.results.length; i++) {
                                                    var data = {
                                                        '__metadata': {
                                                            'type': 'SP.Data.ObjetivossListItem'
                                                        },
                                                        'Nombre_x0020_de_x0020_usuario_x0': $scope.detalleJefes.EVALUADOR,
                                                        'Nombre_x0020_del_x0020_superviso': $scope.detalleJefes.NOMBRES_EVALUADOR,
                                                        'Apellidos_x0020_del_x0020_superv': $scope.detalleJefes.APELLIDOS_EVALUADOR,
                                                        
                                                    };
                                            
                                                    
                                                    spsservice.put_data("lists/getbytitle('Objetivos')/items(" + resp_sup.d.results[i].ID + ")", data);

                                                                    
                                                }
                                            });
                                                                                                    
                                            $scope.bloqueoInput = true;
                                            SweetAlert.swal("Jefe modificado", "", "success");
                                        });

                                    },
                                    error: function () {
                                        console.log("error refresh token");
                                    }
                                });
                            } catch (err) {
                                console.log("requestDigestToken error : " + err.message);
                            }
                            //************ fin actualizar token
                            
                        }
                    });
            }

            $scope.cancelarEdicion = function () {

                $route.reload()

                $scope.bloqueoInput = true;
            }

        })

}(angular.module('spsmodule')));