(function (app) {
    app
        .controller('spscontroller', function ($scope, spsservice, $http, $rootScope, SweetAlert, $window, $location, $route) {

            $rootScope.isAdministrador = false;
            $rootScope.isEvaluador = false;

            //obtener año actual
            debugger;
            var d = new Date();
            $rootScope.anoActual = d.getFullYear();

            //configuracion carga masiva
            $rootScope.factor = 90;
            $rootScope.timer = 15000;
            $rootScope.procesado = 0;
            $rootScope.total = 0;

            $scope.eliminardata = false;
            $scope.nombrelistaeliminar = "";

            $rootScope.obteniendoDatos = true;

            //configuracion paginacion
            $rootScope.maxSize = "200";
            $rootScope.bigTotalItems = 0;
            $rootScope.bigCurrentPage = 1;

            $rootScope.datatable = [];
            $rootScope.data = [];

            $rootScope.filtro = [];


            $rootScope.menuActivo = function () {
                // configuracion de menu            
                angular.element(document.querySelector('#itemHomeMenu')).removeClass('menuIndicadores');
                angular.element(document.querySelector('#itemObjetivosMenu')).removeClass('menuIndicadores');
                angular.element(document.querySelector('#itemEvaluacionesMenu')).removeClass('menuIndicadores');
                angular.element(document.querySelector('#itemAdministracionMenu')).removeClass('menuIndicadores');
                angular.element(document.querySelector('#itemJefesMenu')).removeClass('menuIndicadores');
                angular.element(document.querySelector('#itemEscalasproduccionMenu')).removeClass('menuIndicadores');

                switch ($location.$$url) {
                    case "/":
                        var myEl = angular.element(document.querySelector('#itemHomeMenu'));
                        myEl.addClass('menuIndicadores');
                        break;
                    case "/Objetivos":
                        var myEl = angular.element(document.querySelector('#itemObjetivosMenu'));
                        myEl.addClass('menuIndicadores');
                        break;
                    case "/Evaluaciones":
                        var myEl = angular.element(document.querySelector('#itemEvaluacionesMenu'));
                        myEl.addClass('menuIndicadores');
                        break;
                    case "/Administracion":
                        var myEl = angular.element(document.querySelector('#itemAdministracionMenu'));
                        myEl.addClass('menuIndicadores');
                        break;
                    case "/Jefes":
                        var myEl = angular.element(document.querySelector('#itemJefesMenu'));
                        myEl.addClass('menuIndicadores');
                        break;
                    case "/EscalasDeProduccion":
                        var myEl = angular.element(document.querySelector('#itemEscalasproduccionMenu'));
                        myEl.addClass('menuIndicadores');
                        break;
                }
                // fin configurar menu
            }


            //es de proyecto reuniones
            $scope.salirSistema = function () {
                $window.location.href = _spPageContextInfo.webAbsoluteUrl + "/_layouts/SignOut.aspx";
            }

            $rootScope.goBackend = function () {
                $window.location.href = _spPageContextInfo.webAbsoluteUrl + "/_layouts/15/viewlsts.aspx";
            }

            $rootScope.sociedades = [{
                    "nombre": "AGRICOLA SUPER LTDA (S001)"
                },
                {
                    "nombre": "AGRO TANTEHUE LTDA (S002)"
                },
                {
                    "nombre": "SOPRAVAL S.A. (S006)"
                }
            ];

            $rootScope.subgerencias = [{
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "SUBGERENCIA CRIANZA BROILER (14011001)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "SUBGERENCIA CASABLANCA (14013003)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "SUBGERENCIA SUSTENTABILIDAD (14017001)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "SUBGERENCIA PROYECTOS Y DESARROLLO (14013004)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "SUBGERENCIA CRIANZA (14012002)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "GERENCIA PLANTAS ALIMENTOS (13013001)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "SUBGERENCIA ABUELAS Y REPRODUCTORAS (14011002)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "GERENCIA BIOCORNECHE (13012002)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "SUBGERENCIA LO MIRANDA (14013001)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "SUBGERENCIA REPRODUCTORAS (14012001)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "SUBGERENCIA LONGOVILO (14013002)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "GERENCIA TRANSPORTES PRODUCCIÓN (13016001)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "GERENCIA PRODUCCIÓN AVES (13011001)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "SUBGERENCIA NUTRICIÓN AVES (14011004)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "SUBGERENCIA PERSONAS PRODUCCIÓN ANIMAL (14016001)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "GERENCIA PRODUCCIÓN CERDOS (12012001)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "SUBGERENCIA DESARROLLO AVES (14011003)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "SUBGERENCIA PROYECTOS Y MANTENCIÓN (14011005)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "SUBGERENCIA EXCELENCIA OPERACIONAL CERDOS (14011008)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "SUBGERENCIA SANIDAD AVES (14011007)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "SUBGERENCIA SANIDAD (14012004)"
                },
                {
                    "Sociedad": "AGRICOLA SUPER LTDA (S001)",
                    "Subgerencia": "SUBGERENCIA INVESTIGACIÓN Y DESARROLLO (14012003)"
                },
                {
                    "Sociedad": "AGRO TANTEHUE LTDA (S002)",
                    "Subgerencia": "SUBGERENCIA REPRODUCTORAS (14012001)"
                },
                {
                    "Sociedad": "AGRO TANTEHUE LTDA (S002)",
                    "Subgerencia": "SUBGERENCIA CRIANZA (14012002)"
                },
                {
                    "Sociedad": "AGRO TANTEHUE LTDA (S002)",
                    "Subgerencia": "SUBGERENCIA ABUELAS Y REPRODUCTORAS (14011002)"
                },
                {
                    "Sociedad": "AGRO TANTEHUE LTDA (S002)",
                    "Subgerencia": "GERENCIA TRANSPORTES PRODUCCIÓN (13016001)"
                },
                {
                    "Sociedad": "AGRO TANTEHUE LTDA (S002)",
                    "Subgerencia": "SUBGERENCIA CRIANZA BROILER (14011001)"
                },
                {
                    "Sociedad": "AGRO TANTEHUE LTDA (S002)",
                    "Subgerencia": "GERENCIA PRODUCCIÓN CERDOS (12012001)"
                },
                {
                    "Sociedad": "AGRO TANTEHUE LTDA (S002)",
                    "Subgerencia": "SUBGERENCIA PERSONAS PRODUCCIÓN ANIMAL (14016001)"
                },
                {
                    "Sociedad": "AGRO TANTEHUE LTDA (S002)",
                    "Subgerencia": "SG OPERACIONES Y SOPORTES TI (14074004)"
                },
                {
                    "Sociedad": "AGRO TANTEHUE LTDA (S002)",
                    "Subgerencia": "SUBGERENCIA SANIDAD (14012004)"
                },
                {
                    "Sociedad": "AGRO TANTEHUE LTDA (S002)",
                    "Subgerencia": "SG ADQUISICIONES FAENADORAS (14072002)"
                },
                {
                    "Sociedad": "AGRO TANTEHUE LTDA (S002)",
                    "Subgerencia": "SUBGERENCIA PROYECTOS Y MANTENCIÓN (14011005)"
                },
                {
                    "Sociedad": "AGRO TANTEHUE LTDA (S002)",
                    "Subgerencia": "SUBGERENCIA SUSTENTABILIDAD (14017001)"
                },
                {
                    "Sociedad": "SOPRAVAL S.A. (S006)",
                    "Subgerencia": "SUBGERENCIA PLANTA FAENADORA (14122002)"
                },
                {
                    "Sociedad": "SOPRAVAL S.A. (S006)",
                    "Subgerencia": "SUBGERENCIA PLANTA CECINAS (14122001)"
                },
                {
                    "Sociedad": "SOPRAVAL S.A. (S006)",
                    "Subgerencia": "GERENCIA DIVISIÓN INDUSTRIAL (13122001)"
                },
                {
                    "Sociedad": "SOPRAVAL S.A. (S006)",
                    "Subgerencia": "GERENCIA MEDIOAMBIENTAL (13123001)"
                },
                {
                    "Sociedad": "SOPRAVAL S.A. (S006)",
                    "Subgerencia": "SUBGERENCIA RELACIONES CON LA COMUNIDAD (15128003)"
                },
                {
                    "Sociedad": "SOPRAVAL S.A. (S006)",
                    "Subgerencia": "GERENCIA PERSONAS (13124001)"
                },
                {
                    "Sociedad": "SOPRAVAL S.A. (S006)",
                    "Subgerencia": "GERENCIA PRODUCCIÓN ANIMAL (13121001)"
                },
                {
                    "Sociedad": "SOPRAVAL S.A. (S006)",
                    "Subgerencia": "SG OPERACIONES Y SOPORTES TI (14074004)"
                },
                {
                    "Sociedad": "SOPRAVAL S.A. (S006)",
                    "Subgerencia": "GERENCIA TRANSPORTES PRODUCCIÓN (13016001)"
                },
                {
                    "Sociedad": "SOPRAVAL S.A. (S006)",
                    "Subgerencia": "SUBGERENCIA PERSONAS PRODUCCIÓN ANIMAL (14016001)"
                }
            ];

            $rootScope.estados = [{
                    "nombre": "Update"
                },
                {
                    "nombre": "Delete"
                }
            ];

            $rootScope.estadoenvios = [{
                    "nombre": "No evaluado"
                },
                {
                    "nombre": "Pendiente de envío"
                },
                {
                    "nombre": "Enviado"
                }
            ];

            $rootScope.escalas = [{
                    "nombre": "Con escala"
                },
                {
                    "nombre": "Sin escala"
                }
            ];

            $rootScope.categorias = [{
                    "nombre": "Negocio"
                },
                {
                    "nombre": "Personas"
                }
            ];

            $rootScope.calculos = [{
                    "nombre": "Directo"
                },
                {
                    "nombre": "Inverso"
                }
            ];

            //Obtener datos para tablas
            $rootScope.getData = function (query) {

                $rootScope.procesado = 0;
                $rootScope.total = 0;

                spsservice.get_type(query).then(function (resp_sup) {
                    $rootScope.datatable = $rootScope.datatable.concat(resp_sup.d.results);
                    if (resp_sup.d.__next) {
                        url = resp_sup.d.__next;
                        $rootScope.getData(resp_sup.d.__next);
                    } else {


                        $rootScope.data = $rootScope.datatable;
                        $rootScope.obteniendoDatos = false;
                        //saber en que modulo estoy

                        if ($rootScope.modulo == "Evaluaciones") {
                            debugger;

                            //filtrar por estado update

                            $rootScope.data = $rootScope.data.filter(x => x.Estado == "Update");
                            $rootScope.dataDelete = $rootScope.datatable.filter(x => x.Estado == "Delete");

                            //contar numero de personas a evaluar:
                            $rootScope.personasEvaluar = new Set($rootScope.data.map(item => item.Propietario_x0020_del_x0020_obje)).size;




                            //Obtener las escalas hasta tope de 5000 elementos
                            spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('Escalas_de_produccion')/Items?$select=Id,escalas,nivel,desde,hasta,porcentaje1,ponderacion,porcentaje2&$top=5000&orderby=nivel").then(function (resp_sup_escalas) {

                                //ajustar los indicadores


                                //reutilizar for para armar arreglo arrCargaFinal
                                $rootScope.arrCargaFinal = [{
                                    'col1': 'OBJ_PLAN_ID',
                                    'col2': 6
                                }];

                                $rootScope.arrCargaFinal.push({
                                    'col1': 'OBJ_PLAN_NAME',
                                    'col2': 'Objetivos 2019'
                                })

                                $rootScope.arrCargaFinal.push({
                                    'col1': 'DATE',
                                    'col2': 'Mon Jul 08 15:13:02 UTC 2019'
                                })

                                $rootScope.arrCargaFinal.push({
                                    'col1': 'MAX_ERROR'
                                })

                                //columns                     
                                $rootScope.arrCargaFinal.push({
                                    'col1': '^TYPE',
                                    'col2': 'ACTION',
                                    'col3': 'ID',
                                    'col4': 'SUBID',
                                    'col5': 'GUID',
                                    'col6': 'SUBGUID',
                                    'col7': 'FILTER_USERNAME',
                                    'col8': 'FILTER_MGR_ID',
                                    'col9': 'FILTER_CUSTOM05',
                                    'col0': 'FILTER_DEPT',
                                    'col11': 'FILTER_DIV',
                                    'col12': 'FILTER_JOBCODE',
                                    'col13': 'FILTER_LOC',
                                    'col14': 'OBJECTIVE_CATEGORY',
                                    'col15': 'OBJECTIVE_PARENTID',
                                    'col16': 'OBJECTIVE_PUBLIC',
                                    'col17': 'OBJECTIVE_name',
                                    'col18': 'OBJECTIVE_metric',
                                    'col19': 'OBJECTIVE_bizx-target',
                                    'col20': 'OBJECTIVE_weight',
                                    'col21': 'OBJECTIVE_tipocalc',
                                    'col22': 'OBJECTIVE_target-baseline', // OBJECTIVE_target-baseline
                                    'col23': 'OBJECTIVE_bizx-actual',
                                    'col24': 'OBJECTIVE_actual-achievement',
                                    'col25': 'OBJECTIVE_rating',
                                    'col26': 'OBJECTIVE_start',
                                    'col27': 'OBJECTIVE_due',
                                    'col28': 'METRICLOOKUP_achievement',
                                    'col29': 'METRICLOOKUP_rating'
                                })


                                for (let i = 0; i < $rootScope.data.length; i++) {
                                    $rootScope.arrCargaFinal.push({
                                        'col1': 'OBJECTIVE',
                                        'col2': $rootScope.data[i].Estado.toUpperCase(), //'ACTION' ,
                                        'col3': $rootScope.data[i].ID_de_objetivo, //'ID',
                                        'col4': '', //'SUBID',
                                        'col5': '', //'GUID',
                                        'col6': '', //'SUBGUID',
                                        'col7': $rootScope.data[i].Propietario_x0020_del_x0020_obje, //'FILTER_USERNAME',
                                        'col8': '', //'FILTER_MGR_ID',
                                        'col9': '', //'FILTER_CUSTOM05',
                                        'col0': '', //'FILTER_DEPT',
                                        'col11': '', //'FILTER_DIV',
                                        'col12': '', //'FILTER_JOBCODE',
                                        'col13': '', //'FILTER_LOC',
                                        'col14': $rootScope.data[i].Categor_x00ed_a, //'OBJECTIVE_CATEGORY',
                                        'col15': '', //'OBJECTIVE_PARENTID',
                                        'col16': 'Y', //'OBJECTIVE_PUBLIC',
                                        'col17': $rootScope.data[i].Objetivo.replace(/(?:\r\n|\r|\n)/g, " "), // 'OBJECTIVE_name',
                                        'col18': $rootScope.data[i].Indicador.replace(/(?:\r\n|\r|\n)/g, " "), //'OBJECTIVE_metric',
                                        'col19': $rootScope.data[i].Meta, //'OBJECTIVE_bizx-target',
                                        'col20': $rootScope.data[i].Ponderaci_x00f3_n, //'OBJECTIVE_weight',
                                        'col21': $rootScope.data[i].Tipo_x0020_de_x0020_C_x00e1_lcul == "Directo" ? 1 : 2,
                                        'col22': 100, //'OBJECTIVE_target-baseline',
                                        'col23': $rootScope.data[i].resultado, //'OBJECTIVE_bizx-actual',
                                        'col24': $rootScope.data[i].OData__x0025__final_de_cumplimiento, // BECTIVE_actual-achievement',
                                        'col25': '', //'OBJECTIVE_rating',
                                        'col26': '0' + $rootScope.data[i].Fecha_x0020_de_x0020_Inicio, //'OBJECTIVE_start',
                                        'col27': $rootScope.data[i].Fecha_x0020_de_x0020_T_x00e9_rmi, //'OBJECTIVE_due',
                                        'col28': '', //'METRICLOOKUP_achievement',
                                        'col29': '', //'METRICLOOKUP_rating'
                                    })

                                    //end salida .csv

                                    //generando salida .csv


                                    var indicadorArray = $rootScope.data[i].Indicador.split('/');
                                    var _nombreEscala = indicadorArray[indicadorArray.length - 1];

                                    //Buscar escala en arreglo
                                    debugger;
                                    var _escalaFind = resp_sup_escalas.d.results.filter(x => x.escalas == _nombreEscala);
                                    if (_escalaFind.length == 0) {
                                        $rootScope.data[i].Indicador_mod = "Sin escala";
                                        $rootScope.data[i].Indicador = _nombreEscala;
                                    } else {
                                        $rootScope.data[i].Indicador = _nombreEscala;
                                        $rootScope.data[i].Indicador_mod = "Con escala";
                                        $rootScope.data[i].TramosEscala = _escalaFind;
                                    }



                                }



                                // $rootScope.arrCargaFinal


                            });
                        }

                        //si es eliminacion
                        // 
                        if ($scope.eliminardata) {
                            $scope.eliminardata = false;

                            //INIT inicializar variables #######################################################
                            console.clear();
                            $rootScope.procesado = 0;
                            $rootScope.total = $rootScope.datatable.length;
                            let iteraciones = Math.round($rootScope.total / $rootScope.factor);
                            if (iteraciones == 0) {
                                iteraciones = 1;
                            }
                            var iteracion = 1;
                            console.log(new Date().toLocaleString() + " : " + "Batch conf.... Total: " + $rootScope.total + ", factor: " + $rootScope.factor);
                            console.log(new Date().toLocaleString() + " : " + "Batch start.... iteracion: " + (iteracion) + "/" + iteraciones);
                            //END inicializar variables


                            //INIT iteracion manual #######################################################
                            let final = 0;
                            if ($rootScope.factor > $rootScope.total) {
                                final = $rootScope.total;
                            } else {
                                final = $rootScope.procesado + $rootScope.factor;
                            }

                            try {
                                for ($rootScope.procesado; $rootScope.procesado < final; $rootScope.procesado++) {
                                    spsservice.delete_data("lists/getbytitle('" + $scope.nombrelistaeliminar + "')/items(" + $rootScope.datatable[$rootScope.procesado].Id + ")").then(function () {});
                                }
                            } catch (error) {
                                console.log("ERROR: procesado: " + $rootScope.procesado);
                            }
                            //END iteracion manual

                            //actualizacion barra de progreso #######################################################
                            $rootScope.progresobatch = parseInt(((iteracion * 100) / iteraciones));
                            $('.progress-bar').css('width', $rootScope.progresobatch + '%');
                            $("#theBar").html($rootScope.progresobatch + '%')
                            //END actualizacion barra de progreso


                            //INIT automatizacion #######################################################
                            if ($rootScope.progresobatch < 100) {
                                var id = setInterval(function () {
                                    iteracion = iteracion + 1;
                                    console.log(new Date().toLocaleString() + " : " + "Batch next.... iteracion: " + (iteracion) + "/" + iteraciones);
                                    if ($rootScope.factor > ($rootScope.total - $rootScope.procesado)) {
                                        final = $rootScope.total;
                                    } else {
                                        final = $rootScope.procesado + $rootScope.factor;
                                    }

                                    for ($rootScope.procesado; $rootScope.procesado < final; $rootScope.procesado++) {
                                        spsservice.delete_data("lists/getbytitle('" + $scope.nombrelistaeliminar + "')/items(" + $rootScope.datatable[$rootScope.procesado].Id + ")").then(function () {});

                                    }
                                    //actualizacion barra de progreso
                                    $rootScope.progresobatch = parseInt(((iteracion * 100) / iteraciones));
                                    $rootScope.progresobatch = $rootScope.progresobatch >= 100 ? 100 : $rootScope.progresobatch;
                                    $('.progress-bar').css('width', $rootScope.progresobatch + '%');
                                    $("#theBar").html($rootScope.progresobatch + '%')
                                    //END actualizacion barra de progreso

                                    if ($rootScope.procesado >= $rootScope.total) {
                                        clearInterval(id);
                                        console.log(new Date().toLocaleString() + " : " + "Batch end....");

                                        if ($scope.datacargar) {
                                            $scope.cargarDatos($scope.datacargar);
                                        } else {
                                            SweetAlert.swal("Eliminación terminada!.", "", "success");
                                            $rootScope.procesando = false;
                                            $rootScope.progresobatch = 0;
                                            $rootScope.bloqueopantalla = false;

                                            $rootScope.procesado = 0;
                                            $rootScope.total = 0;
                                        }


                                    }
                                }, $rootScope.timer);
                                //batch end 

                            } else {
                                if ($scope.datacargar) {
                                    $scope.cargarDatos($scope.datacargar);
                                } else {
                                    SweetAlert.swal("Eliminación terminada!.", "", "success");
                                    $rootScope.procesando = false;
                                    $rootScope.progresobatch = 0;
                                    $rootScope.bloqueopantalla = false;

                                    $rootScope.procesado = 0;
                                    $rootScope.total = 0;
                                }


                            }
                            //END automatizacion
                        }
                    }
                });

            }
            //end getdata()


            //crt
            $rootScope.eliminarDatos = function (nombreLista, datacargar, alerta) {
                if (alerta) {

                    SweetAlert.swal({
                            title: "¿Está seguro de eliminar la información?",
                            text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                            type: "warning",
                            showCancelButton: true,
                            confirmButtonColor: "#ff8800",
                            cancelButtonColor: "#DD2B85",
                            confirmButtonText: "Estoy seguro de eliminar la información",
                            cancelButtonText: "Salir",
                            closeOnConfirm: true
                        },
                        function (isConfirm) {
                            if (isConfirm) {

                                //************ iniciar actualizar token
                                try {
                                    $.ajax({
                                        url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                                        async: true,
                                        type: "POST",
                                        headers: {
                                            "Accept": "application/json; odata=verbose"
                                        },
                                        success: function (response) {
                                            var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                                            $('#__REQUESTDIGEST').val(_DigestToken);

                                            //############# LOGICA 
                                            $rootScope.textoBloqueo = "Eliminando información.  No actualizar la página hasta finalizar ...";

                                            $rootScope.procesado = 0;
                                            $rootScope.total = 0;


                                            $rootScope.bloqueopantalla = true;
                                            $rootScope.procesando = true;
                                            $rootScope.progresobatch = 0;

                                            $rootScope.datatable = [];

                                            $scope.nombrelistaeliminar = nombreLista;
                                            // 
                                            $scope.datacargar = datacargar;
                                            $scope.eliminardata = true;
                                            $scope.columnsGet = "Id";
                                            $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('" + nombreLista + "')/Items?$select=" + $scope.columnsGet + "&$top=5000";
                                            $rootScope.getData($scope.urlGetBase);

                                        },
                                        error: function () {
                                            console.log("error refresh token");
                                        }
                                    });
                                } catch (err) {
                                    console.log("requestDigestToken error : " + err.message);
                                }
                                //************ fin actualizar token




                            }
                        });

                } else {


                    //************ iniciar actualizar token
                    try {
                        $.ajax({
                            url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                            async: true,
                            type: "POST",
                            headers: {
                                "Accept": "application/json; odata=verbose"
                            },
                            success: function (response) {
                                var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                                $('#__REQUESTDIGEST').val(_DigestToken);

                                //############# LOGICA 
                                $rootScope.procesado = 0;
                                $rootScope.total = 0;


                                $rootScope.bloqueopantalla = true;
                                $rootScope.procesando = true;
                                $rootScope.progresobatch = 0;

                                $rootScope.datatable = [];

                                $scope.nombrelistaeliminar = nombreLista;
                                // 
                                $scope.datacargar = datacargar;
                                $scope.eliminardata = true;
                                $scope.columnsGet = "Id";
                                $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('" + nombreLista + "')/Items?$select=" + $scope.columnsGet + "&$top=5000";
                                $rootScope.getData($scope.urlGetBase);

                            },
                            error: function () {
                                console.log("error refresh token");
                            }
                        });
                    } catch (err) {
                        console.log("requestDigestToken error : " + err.message);
                    }
                    //************ fin actualizar token                    
                }
            };


            //crt
            $scope.cargarDatos = function (data) {

               
                var excelRows = data;
                //************ iniciar actualizar token
                try {
                    $.ajax({
                        url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                        async: true,
                        type: "POST",
                        headers: {
                            "Accept": "application/json; odata=verbose"
                        },
                        success: function (response) {
                            var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                            $('#__REQUESTDIGEST').val(_DigestToken);

                            //############# LOGICA 
                            // 
                            

                            // INICIO DE CARGA DE ESCALAS        
                            // batch init ########################################################
                            console.clear();

                          
                            $rootScope.procesado = 0;
                            $rootScope.total = excelRows.length;
                            let iteraciones = Math.round($rootScope.total / $rootScope.factor);
                            if (iteraciones == 0) {
                                iteraciones = 1;
                            }

                            let iteracion = 1;
                            console.log(new Date().toLocaleString() + " : " + "Batch conf.... Total: " + $rootScope.total + ", factor: " + $rootScope.factor);
                            console.log(new Date().toLocaleString() + " : " + "Batch start.... iteracion: " + (iteracion) + "/" + iteraciones);

                            //primera iteracion manual
                            let final = 0;

                            if ($rootScope.factor > $rootScope.total) {
                                final = $rootScope.total;
                            } else {
                                final = $rootScope.procesado + $rootScope.factor;
                            }

                            for ($rootScope.procesado; $rootScope.procesado < final; $rootScope.procesado++) {
                                try {
                                    if (excelRows[$rootScope.procesado].__EMPTY != null) {
                                        nombreEscala = excelRows[$rootScope.procesado].__EMPTY;
                                    }

                                    var data = {
                                        '__metadata': {
                                            'type': 'SP.Data.Escalas_x005f_de_x005f_produccionListItem'
                                        },
                                        'escalas': nombreEscala,
                                        'nivel': excelRows[$rootScope.procesado].__EMPTY_1,
                                        'desde': excelRows[$rootScope.procesado].__EMPTY_2,
                                        'hasta': excelRows[$rootScope.procesado].__EMPTY_3,
                                        'porcentaje1': excelRows[$rootScope.procesado].__EMPTY_4,
                                        'ponderacion': excelRows[$rootScope.procesado].__EMPTY_5,
                                        'porcentaje2': excelRows[$rootScope.procesado].__EMPTY_6
                                    };
                                    spsservice.post_data("lists/getbytitle('Escalas_de_produccion')/items", data);

                                } catch (error) {
                                    console.log("ERROR: procesado: " + $rootScope.procesado)
                                }
                            }
                            //end manual

                            $scope.progresobatch = parseInt(((iteracion * 100) / iteraciones));

                            $('.progress-bar').css('width', $scope.progresobatch + '%');
                            $("#theBar").html($scope.progresobatch + '%')

                            if ($scope.progresobatch < 100) {

                                var id = setInterval(function () {
                                    iteracion = 1 + iteracion;
                                    console.log(new Date().toLocaleString() + " : " + "Batch next.... iteracion: " + (iteracion) + "/" + iteraciones);

                                    if ($rootScope.factor > ($rootScope.total - $rootScope.procesado)) {
                                        final = $rootScope.total;
                                    } else {
                                        final = $rootScope.procesado + $rootScope.factor;
                                    }

                                    for ($rootScope.procesado; $rootScope.procesado < final; $rootScope.procesado++) {

                                        try {
                                            if (excelRows[$rootScope.procesado].__EMPTY != null) {
                                                nombreEscala = excelRows[$rootScope.procesado].__EMPTY;
                                            }

                                            var data = {
                                                '__metadata': {
                                                    'type': 'SP.Data.Escalas_x005f_de_x005f_produccionListItem'
                                                },
                                                'escalas': nombreEscala,
                                                'nivel': excelRows[$rootScope.procesado].__EMPTY_1,
                                                'desde': excelRows[$rootScope.procesado].__EMPTY_2,
                                                'hasta': excelRows[$rootScope.procesado].__EMPTY_3,
                                                'porcentaje1': excelRows[$rootScope.procesado].__EMPTY_4,
                                                'ponderacion': excelRows[$rootScope.procesado].__EMPTY_5,
                                                'porcentaje2': excelRows[$rootScope.procesado].__EMPTY_6
                                            };

                                            spsservice.post_data("lists/getbytitle('Escalas_de_produccion')/items", data);

                                        } catch (error) {
                                            console.log("ERROR: procesado: " + $rootScope.procesado)
                                        }

                                    }

                                    $scope.progresobatch = parseInt(((iteracion * 100) / iteraciones));
                                    $scope.progresobatch = $scope.progresobatch >= 100 ? 100 : $scope.progresobatch;
                                    $('.progress-bar').css('width', $scope.progresobatch + '%');
                                    $("#theBar").html($scope.progresobatch + '%')


                                    if ($rootScope.procesado >= $rootScope.total) {

                                        clearInterval(id);
                                        console.log(new Date().toLocaleString() + " : " + "Batch end....");
                                        SweetAlert.swal("Carga de escalas terminado!.", "", "success");
                                        $rootScope.procesando = false;
                                        $scope.progresobatch = 0;
                                        $rootScope.bloqueopantalla = false;

                                        $rootScope.procesado = 0;
                                        $rootScope.total = 0;

                                        $route.reload();
                                    }
                                }, $rootScope.timer);
                                //batch end ########################################################

                            } else {
                                SweetAlert.swal("Carga de escalas terminado!.", "", "success");
                                $rootScope.procesando = false;
                                $scope.progresobatch = 0;
                                $rootScope.bloqueopantalla = false;

                                $rootScope.procesado = 0;
                                $rootScope.total = 0;


                                $route.reload();
                            }
                            // FIN DE CARGA DE ESCALAS

                        },
                        error: function () {
                            console.log("error refresh token");
                        }
                    });
                } catch (err) {
                    console.log("requestDigestToken error : " + err.message);
                }
                //************ fin actualizar token

            }

            $rootScope.actualizar = function () {

                $route.reload()

            }


        }); // end controller
}(angular.module('spsmodule')));