(function (app) {
    app
        .controller('administracionController', function ($scope, SweetAlert, $rootScope, spsservice, $route, $location) {
            $rootScope.menuActivo();


            //obtener info de usuario conectado          
            var esJefeDesarollo = false;
            var esIngenieroDesarrollo = false;
            var excelRows;

            //************ iniciar actualizar token
                try {
                    $.ajax({
                        url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                        async: true,
                        type: "POST",
                        headers: {
                            "Accept": "application/json; odata=verbose"
                        },
                        success: function (response) {
                            var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                            $('#__REQUESTDIGEST').val(_DigestToken);

                            //############# LOGICA 
                            spsservice.get_data("/_api/web/currentuser?$expand=Groups").then(function (resp) {
                                if (resp.d.Groups.results.length > 0) { //tiene un grupo                        
                                    $rootScope.user = {
                                        'Id': resp.d.Id,
                                        'Email': resp.d.Email,
                                        'Nombre': resp.d.Title,
                                        'Username': resp.d.Email.split("@")[0]
                                    };
                
                                    for (let index = 0; index < resp.d.Groups.results.length; index++) {
                                        //check administrador
                                        if (resp.d.Groups.results[index].Title == "Administradores") {
                                            $rootScope.isAdministrador = true;
                                        }
                
                                        //check evaluador
                                        if (resp.d.Groups.results[index].Title == "Evaluadores") {
                                            $rootScope.isEvaluador = true;
                                        }
                                    }
                
                                    //validar acceso al menu
                                    if (!$rootScope.isAdministrador && $rootScope.isEvaluador) {
                                        $location.path("/");
                                    }
                                }
                            });
                            //end obtener info de usuario conectado

                        },
                        error: function () {
                            console.log("error refresh token");
                        }
                    });
                } catch (err) {
                    console.log("requestDigestToken error : " + err.message);
                }
                //************ fin actualizar token
            
            


            $rootScope.procesando = false;
            $scope.progresobatch = 0;

            $scope.SelectFile = function (file) {

                $scope.SelectedFile = file;
            };

            //Subida de Objetivos
            $scope.Upload = function () {
                if ($scope.SelectedFile != null) {
                    SweetAlert.swal({
                            title: "¿Está seguro de cargar los objetivos?",
                            text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                            type: "warning",
                            showCancelButton: true,
                            confirmButtonColor: "#16AB39",
                            confirmButtonText: "Si, cargar los objetivos!",
                            cancelButtonText: "Salir",
                            closeOnConfirm: true
                        },
                        function (isConfirm) {
                            if (isConfirm) {

                                //************ iniciar actualizar token
                                try {
                                    $.ajax({
                                        url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                                        async: true,
                                        type: "POST",
                                        headers: {
                                            "Accept": "application/json; odata=verbose"
                                        },
                                        success: function (response) {
                                            var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                                            $('#__REQUESTDIGEST').val(_DigestToken);

                                            //############# inicio logica
                                            $rootScope.textoBloqueo = "Cargando información.  No actualizar la página hasta finalizar ...";
                                            $rootScope.procesado = 0;
                                            $rootScope.total = 0;
                                            $rootScope.bloqueopantalla = true;
                                            $rootScope.procesando = true;
                                            $scope.progresobatch = 0;

                                            var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.xls|.xlsx)$/;
                                            if (regex.test($scope.SelectedFile.name.toLowerCase())) {
                                                if (typeof (FileReader) != "undefined") {
                                                    var reader = new FileReader();
                                                    //For Browsers other than IE.
                                                    if (reader.readAsBinaryString) {
                                                        reader.onload = function (e) {

                                                            $scope.ProcessExcel(e.target.result);
                                                        };
                                                        reader.readAsBinaryString($scope.SelectedFile);
                                                    } else {
                                                        //For IE Browser.
                                                        reader.onload = function (e) {
                                                            var data = "";
                                                            var bytes = new Uint8Array(e.target.result);
                                                            for (var i = 0; i < bytes.byteLength; i++) {
                                                                data += String.fromCharCode(bytes[i]);
                                                            }
                                                            $scope.ProcessExcel(data);
                                                        };
                                                        reader.readAsArrayBuffer($scope.SelectedFile);
                                                    }
                                                } else {
                                                    alert("This browser does not support HTML5.");
                                                    $rootScope.procesando = false;
                                                    $rootScope.bloqueopantalla = false;
                                                }
                                            } else {
                                                alert("Please upload a valid Excel file.");
                                                $rootScope.procesando = false;
                                                $rootScope.bloqueopantalla = false;
                                            }
                                            //fin logica


                                        },
                                        error: function () {
                                            console.log("error refresh token");
                                        }
                                    });
                                } catch (err) {
                                    console.log("requestDigestToken error : " + err.message);
                                }
                                //************ fin actualizar token



                            }

                        });

                } else {
                    SweetAlert.swal("Ops...", "Debe seleccionar un archivo para procesar.", "warning");
                    $rootScope.procesando = false;
                    $rootScope.bloqueopantalla = false;
                }



            };

            $scope.ProcessExcel = function (data) {

                $scope.progresobatch = 0;

                var workbook = XLSX.read(data, {
                    type: 'binary'
                });

                var firstSheet = workbook.SheetNames[0];
                excelRows = XLSX.utils.sheet_to_row_object_array(workbook.Sheets[firstSheet]);

                // 
                if (excelRows.length > 0) {
                    $scope.$apply(function () {

                        //llamar a funcion recursiva
                        $scope.dataObjetivos = [];
                        //Obtener datos para tablas
                        
                        $scope.getDataAdministracion(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('Objetivos')/Items?$select=Id,ID_de_objetivo,Propietario_x0020_del_x0020_obje,Categor_x00ed_a,Tipo_,Objetivo,Indicador,Meta,Ponderaci_x00f3_n,Tipo_x0020_de_x0020_C_x00e1_lcul,Real,OData__x0025__x0020_Final_x0020_de_x00,Fecha_x0020_de_x0020_Inicio,Fecha_x0020_de_x0020_T_x00e9_rmi,Nombre_x0020_de_x0020_usuario_x0,Unidad_x0020_de_x0020_Negocio,Sociedad,Propietario_x0020_del_x0020_obje0,Propietario_x0020_del_x0020_obje1,ID_x0020_de_x0020_usuario_x0020_,Propietario_x0020_del_x0020_obje2,Propietario_x0020_del_x0020_obje3,Nombre_x0020_del_x0020_superviso,Apellidos_x0020_del_x0020_superv,Estado&$orderby=ID desc&$top=5000");




                    });

                }

            };

            $scope.dataObjetivos = [];
            $scope.getDataAdministracion = function (query) {
                spsservice.get_type(query).then(function (resp_sup) {
                    $scope.dataObjetivos = $scope.dataObjetivos.concat(resp_sup.d.results);
                    
                    if (resp_sup.d.__next) {
                        url = resp_sup.d.__next;
                        $scope.getDataAdministracion(resp_sup.d.__next);
                    } else {
                        
                        //termino la funcion recursiva

                        if ($scope.dataObjetivos.length > 0) { //tiene registros?

                            //batch init ########################################################
                            console.clear();


                            $rootScope.procesado = 0;
                            // 10 sec
                            $rootScope.total = excelRows.length;
                            let iteraciones = Math.round($rootScope.total / $rootScope.factor);
                            if (iteraciones == 0) {
                                iteraciones = 1;
                            }

                            let iteracion = 1;
                            console.log(new Date().toLocaleString() + " : " + "Batch conf.... Total: " + $rootScope.total + ", factor: " + $rootScope.factor);
                            console.log(new Date().toLocaleString() + " : " + "Batch start.... iteracion: " + (iteracion) + "/" + iteraciones);



                            //primera iteracion manual
                            let final = 0;

                            if ($rootScope.factor > $rootScope.total) {

                                final = $rootScope.total;

                            } else {

                                final = $rootScope.procesado + $rootScope.factor;

                            }
                            for ($rootScope.procesado; $rootScope.procesado < final; $rootScope.procesado++) {

                                try {

                                    // st.replace(/"/g, '\\"');

                                    var _objetivo = $scope.dataObjetivos.filter(x => x.ID_de_objetivo == excelRows[$rootScope.procesado]["ID de objetivo"]); ///filtro de condición
                                    var data = {
                                        '__metadata': {
                                            'type': 'SP.Data.ObjetivosListItem'
                                        },
                                        'ID_de_objetivo': excelRows[$rootScope.procesado]["ID de objetivo"],
                                        'Propietario_x0020_del_x0020_obje': excelRows[$rootScope.procesado]["Propietario del objetivo Nombre de usuario"],
                                        'Categor_x00ed_a': excelRows[$rootScope.procesado].Categoría,
                                        'Tipo_': excelRows[$rootScope.procesado].Tipo,
                                        'Objetivo': excelRows[$rootScope.procesado].Objetivo,
                                        'Indicador': excelRows[$rootScope.procesado].Indicador,
                                        'Meta': excelRows[$rootScope.procesado].Meta,
                                        'Ponderaci_x00f3_n': excelRows[$rootScope.procesado].Ponderación,
                                        'Tipo_x0020_de_x0020_C_x00e1_lcul': excelRows[$rootScope.procesado]["Tipo de Cálculo"],
                                        'Real': excelRows[$rootScope.procesado].Real != null ? excelRows[$rootScope.procesado].Real : "",
                                        'OData__x0025__x0020_Final_x0020_de_x00': excelRows[$rootScope.procesado]["% Final de Cumplimiento"],
                                        'Fecha_x0020_de_x0020_Inicio': excelRows[$rootScope.procesado]["Fecha de Inicio"],
                                        'Fecha_x0020_de_x0020_T_x00e9_rmi': excelRows[$rootScope.procesado]["Fecha de Término"],
                                        'Nombre_x0020_de_x0020_usuario_x0': excelRows[$rootScope.procesado]["Nombre de usuario de supervisor"].toUpperCase(), // pasar a mayuscula
                                        'Unidad_x0020_de_x0020_Negocio': excelRows[$rootScope.procesado]["Unidad de Negocio"],
                                        'Sociedad': excelRows[$rootScope.procesado].Sociedad,
                                        'Propietario_x0020_del_x0020_obje0': excelRows[$rootScope.procesado]["Propietario del objetivo Gerencia/Subgerencia"],
                                        'Propietario_x0020_del_x0020_obje1': excelRows[$rootScope.procesado]["Propietario del objetivo Subdivisión de personal"],
                                        'ID_x0020_de_x0020_usuario_x0020_': excelRows[$rootScope.procesado]["ID de usuario del propietario del objetivo"],
                                        'Propietario_x0020_del_x0020_obje2': excelRows[$rootScope.procesado]["Propietario del objetivo Nombre"],
                                        'Propietario_x0020_del_x0020_obje3': excelRows[$rootScope.procesado]["Propietario del objetivo Apellidos"],
                                        'Nombre_x0020_del_x0020_superviso': excelRows[$rootScope.procesado]["Nombre del supervisor"],
                                        'Apellidos_x0020_del_x0020_superv': excelRows[$rootScope.procesado]["Apellidos del supervisor"]
                                    };


                                    if (_objetivo.length == 0) {

                                        spsservice.post_data("lists/getbytitle('Objetivos')/items", data);

                                    } else {

                                        spsservice.put_data("lists/getbytitle('Objetivos')/items(" + _objetivo[0].ID + ")", data);

                                    }


                                } catch (error) {

                                    console.log("ERROR: procesado: " + $rootScope.procesado)

                                }
                            }
                            //end manual

                            $scope.progresobatch = parseInt(((iteracion * 100) / iteraciones));

                            $('.progress-bar').css('width', $scope.progresobatch + '%');
                            $("#theBar").html($scope.progresobatch + '%')

                            if ($scope.progresobatch < 100) {

                                var id = setInterval(function () {
                                    // console.log(new Date().toLocaleString() + " : " + "Batch start.... iteraciones: " + iteraciones);   
                                    iteracion = iteracion + 1;
                                    console.log(new Date().toLocaleString() + " : " + "Batch next.... iteracion: " + (iteracion) + "/" + iteraciones);

                                    // let final = $rootScope.procesado + $rootScope.factor;     

                                    if ($rootScope.factor > ($rootScope.total - $rootScope.procesado)) {
                                        final = $rootScope.total;
                                    } else {
                                        final = $rootScope.procesado + $rootScope.factor;
                                    }

                                    for ($rootScope.procesado; $rootScope.procesado < final; $rootScope.procesado++) {

                                        try {

                                            var _objetivo = $scope.dataObjetivos.filter(x => x.ID_de_objetivo == excelRows[$rootScope.procesado]["ID de objetivo"]);
                                            var data = {
                                                '__metadata': {
                                                    'type': 'SP.Data.ObjetivosListItem'
                                                },
                                                'ID_de_objetivo': excelRows[$rootScope.procesado]["ID de objetivo"],
                                                'Propietario_x0020_del_x0020_obje': excelRows[$rootScope.procesado]["Propietario del objetivo Nombre de usuario"],
                                                'Categor_x00ed_a': excelRows[$rootScope.procesado].Categoría,
                                                'Tipo_': excelRows[$rootScope.procesado].Tipo,
                                                'Objetivo': excelRows[$rootScope.procesado].Objetivo,
                                                'Indicador': excelRows[$rootScope.procesado].Indicador,
                                                'Meta': excelRows[$rootScope.procesado].Meta,
                                                'Ponderaci_x00f3_n': excelRows[$rootScope.procesado].Ponderación,
                                                'Tipo_x0020_de_x0020_C_x00e1_lcul': excelRows[$rootScope.procesado]["Tipo de Cálculo"],
                                                'Real': excelRows[$rootScope.procesado].Real,
                                                'OData__x0025__x0020_Final_x0020_de_x00': excelRows[$rootScope.procesado]["% Final de Cumplimiento"],
                                                'Fecha_x0020_de_x0020_Inicio': excelRows[$rootScope.procesado]["Fecha de Inicio"],
                                                'Fecha_x0020_de_x0020_T_x00e9_rmi': excelRows[$rootScope.procesado]["Fecha de Término"],
                                                'Nombre_x0020_de_x0020_usuario_x0': excelRows[$rootScope.procesado]["Nombre de usuario de supervisor"].toUpperCase(), //pasar a
                                                'Unidad_x0020_de_x0020_Negocio': excelRows[$rootScope.procesado]["Unidad de Negocio"],
                                                'Sociedad': excelRows[$rootScope.procesado].Sociedad,
                                                'Propietario_x0020_del_x0020_obje0': excelRows[$rootScope.procesado]["Propietario del objetivo Gerencia/Subgerencia"],
                                                'Propietario_x0020_del_x0020_obje1': excelRows[$rootScope.procesado]["Propietario del objetivo Subdivisión de personal"],
                                                'ID_x0020_de_x0020_usuario_x0020_': excelRows[$rootScope.procesado]["ID de usuario del propietario del objetivo"],
                                                'Propietario_x0020_del_x0020_obje2': excelRows[$rootScope.procesado]["Propietario del objetivo Nombre"],
                                                'Propietario_x0020_del_x0020_obje3': excelRows[$rootScope.procesado]["Propietario del objetivo Apellidos"],
                                                'Nombre_x0020_del_x0020_superviso': excelRows[$rootScope.procesado]["Nombre del supervisor"],
                                                'Apellidos_x0020_del_x0020_superv': excelRows[$rootScope.procesado]["Apellidos del supervisor"]
                                            };

                                            if (_objetivo.length == 0) {

                                                spsservice.post_data("lists/getbytitle('Objetivos')/items", data);

                                            } else {

                                                spsservice.put_data("lists/getbytitle('Objetivos')/items(" + _objetivo[0].ID + ")", data);
                                            }

                                        } catch (error) {

                                            console.log("ERROR: procesado: " + $rootScope.procesado)

                                        }

                                    }

                                    $scope.progresobatch = parseInt(((iteracion * 100) / iteraciones));
                                    $scope.progresobatch = $scope.progresobatch >= 100 ? 100 : $scope.progresobatch;
                                    $('.progress-bar').css('width', $scope.progresobatch + '%');
                                    $("#theBar").html($scope.progresobatch + '%')


                                    if ($rootScope.procesado >= $rootScope.total) {

                                        clearInterval(id);
                                        console.log(new Date().toLocaleString() + " : " + "Batch end....");
                                        SweetAlert.swal("Carga de objetivos terminado!.", "", "success");
                                        $rootScope.procesando = false;
                                        $scope.progresobatch = 0;
                                        $rootScope.bloqueopantalla = false;

                                        $rootScope.procesado = 0;
                                        $rootScope.total = 0;
                                        $route.reload();
                                    }
                                }, $rootScope.timer);
                                //batch end ########################################################

                            } else {
                                SweetAlert.swal("Carga de objetivos terminado!.", "", "success");
                                $rootScope.procesando = false;
                                $scope.progresobatch = 0;
                                $rootScope.bloqueopantalla = false;

                                $rootScope.procesado = 0;
                                $rootScope.total = 0;
                                $route.reload();
                            }



                        } else { //primera carga

                            //batch init ########################################################
                            console.clear();


                            $rootScope.procesado = 0;

                            $rootScope.total = excelRows.length;
                            let iteraciones = Math.round($rootScope.total / $rootScope.factor);
                            if (iteraciones == 0) {
                                iteraciones = 1;
                            }

                            let iteracion = 1;
                            console.log(new Date().toLocaleString() + " : " + "Batch conf.... Total: " + $rootScope.total + ", factor: " + $rootScope.factor);
                            console.log(new Date().toLocaleString() + " : " + "Batch start.... iteracion: " + (iteracion) + "/" + iteraciones);



                            //primera iteracion manual
                            let final = 0;

                            if ($rootScope.factor > $rootScope.total) {

                                final = $rootScope.total;

                            } else {

                                final = $rootScope.procesado + $rootScope.factor;

                            }
                            for ($rootScope.procesado; $rootScope.procesado < final; $rootScope.procesado++) {



                                try {
                                    var data = {
                                        '__metadata': {
                                            'type': 'SP.Data.ObjetivosListItem'
                                        },
                                        'ID_de_objetivo': excelRows[$rootScope.procesado]["ID de objetivo"],
                                        'Propietario_x0020_del_x0020_obje': excelRows[$rootScope.procesado]["Propietario del objetivo Nombre de usuario"],
                                        'Categor_x00ed_a': excelRows[$rootScope.procesado].Categoría,
                                        'Tipo_': excelRows[$rootScope.procesado].Tipo,
                                        'Objetivo': excelRows[$rootScope.procesado].Objetivo,
                                        'Indicador': excelRows[$rootScope.procesado].Indicador,
                                        'Meta': excelRows[$rootScope.procesado].Meta,
                                        'Ponderaci_x00f3_n': excelRows[$rootScope.procesado].Ponderación,
                                        'Tipo_x0020_de_x0020_C_x00e1_lcul': excelRows[$rootScope.procesado]["Tipo de Cálculo"],
                                        'Real': excelRows[$rootScope.procesado].Real != null ? excelRows[$rootScope.procesado].Real : "",
                                        'OData__x0025__x0020_Final_x0020_de_x00': excelRows[$rootScope.procesado]["% Final de Cumplimiento"],
                                        'Fecha_x0020_de_x0020_Inicio': excelRows[$rootScope.procesado]["Fecha de Inicio"],
                                        'Fecha_x0020_de_x0020_T_x00e9_rmi': excelRows[$rootScope.procesado]["Fecha de Término"],
                                        'Nombre_x0020_de_x0020_usuario_x0': excelRows[$rootScope.procesado]["Nombre de usuario de supervisor"].toUpperCase(),
                                        'Unidad_x0020_de_x0020_Negocio': excelRows[$rootScope.procesado]["Unidad de Negocio"],
                                        'Sociedad': excelRows[$rootScope.procesado].Sociedad,
                                        'Propietario_x0020_del_x0020_obje0': excelRows[$rootScope.procesado]["Propietario del objetivo Gerencia/Subgerencia"],
                                        'Propietario_x0020_del_x0020_obje1': excelRows[$rootScope.procesado]["Propietario del objetivo Subdivisión de personal"],
                                        'ID_x0020_de_x0020_usuario_x0020_': excelRows[$rootScope.procesado]["ID de usuario del propietario del objetivo"],
                                        'Propietario_x0020_del_x0020_obje2': excelRows[$rootScope.procesado]["Propietario del objetivo Nombre"],
                                        'Propietario_x0020_del_x0020_obje3': excelRows[$rootScope.procesado]["Propietario del objetivo Apellidos"],
                                        'Nombre_x0020_del_x0020_superviso': excelRows[$rootScope.procesado]["Nombre del supervisor"],
                                        'Apellidos_x0020_del_x0020_superv': excelRows[$rootScope.procesado]["Apellidos del supervisor"]
                                    };

                                    spsservice.post_data("lists/getbytitle('Objetivos')/items", data);

                                } catch (error) {

                                    console.log("ERROR: procesado: " + $rootScope.procesado)

                                }
                            }
                            //end manual

                            $scope.progresobatch = parseInt(((iteracion * 100) / iteraciones));

                            $('.progress-bar').css('width', $scope.progresobatch + '%');
                            $("#theBar").html($scope.progresobatch + '%')

                            if ($scope.progresobatch < 100) {

                                var id = setInterval(function () {
                                    // console.log(new Date().toLocaleString() + " : " + "Batch start.... iteraciones: " + iteraciones);    
                                    iteracion = 1 + iteracion;
                                    console.log(new Date().toLocaleString() + " : " + "Batch next.... iteracion: " + (iteracion) + "/" + iteraciones);

                                    // let final = $rootScope.procesado + $rootScope.factor;     

                                    if ($rootScope.factor > ($rootScope.total - $rootScope.procesado)) {
                                        final = $rootScope.total;
                                    } else {
                                        final = $rootScope.procesado + $rootScope.factor;
                                    }

                                    for ($rootScope.procesado; $rootScope.procesado < final; $rootScope.procesado++) {



                                        try {


                                            var data = {
                                                '__metadata': {
                                                    'type': 'SP.Data.ObjetivosListItem'
                                                },
                                                'ID_de_objetivo': excelRows[$rootScope.procesado]["ID de objetivo"],
                                                'Propietario_x0020_del_x0020_obje': excelRows[$rootScope.procesado]["Propietario del objetivo Nombre de usuario"],
                                                'Categor_x00ed_a': excelRows[$rootScope.procesado].Categoría,
                                                'Tipo_': excelRows[$rootScope.procesado].Tipo,
                                                'Objetivo': excelRows[$rootScope.procesado].Objetivo,
                                                'Indicador': excelRows[$rootScope.procesado].Indicador,
                                                'Meta': excelRows[$rootScope.procesado].Meta,
                                                'Ponderaci_x00f3_n': excelRows[$rootScope.procesado].Ponderación,
                                                'Tipo_x0020_de_x0020_C_x00e1_lcul': excelRows[$rootScope.procesado]["Tipo de Cálculo"],
                                                'Real': excelRows[$rootScope.procesado].Real,
                                                'OData__x0025__x0020_Final_x0020_de_x00': excelRows[$rootScope.procesado]["% Final de Cumplimiento"],
                                                'Fecha_x0020_de_x0020_Inicio': excelRows[$rootScope.procesado]["Fecha de Inicio"],
                                                'Fecha_x0020_de_x0020_T_x00e9_rmi': excelRows[$rootScope.procesado]["Fecha de Término"],
                                                'Nombre_x0020_de_x0020_usuario_x0': excelRows[$rootScope.procesado]["Nombre de usuario de supervisor"].toUpperCase(),
                                                'Unidad_x0020_de_x0020_Negocio': excelRows[$rootScope.procesado]["Unidad de Negocio"],
                                                'Sociedad': excelRows[$rootScope.procesado].Sociedad,
                                                'Propietario_x0020_del_x0020_obje0': excelRows[$rootScope.procesado]["Propietario del objetivo Gerencia/Subgerencia"],
                                                'Propietario_x0020_del_x0020_obje1': excelRows[$rootScope.procesado]["Propietario del objetivo Subdivisión de personal"],
                                                'ID_x0020_de_x0020_usuario_x0020_': excelRows[$rootScope.procesado]["ID de usuario del propietario del objetivo"],
                                                'Propietario_x0020_del_x0020_obje2': excelRows[$rootScope.procesado]["Propietario del objetivo Nombre"],
                                                'Propietario_x0020_del_x0020_obje3': excelRows[$rootScope.procesado]["Propietario del objetivo Apellidos"],
                                                'Nombre_x0020_del_x0020_superviso': excelRows[$rootScope.procesado]["Nombre del supervisor"],
                                                'Apellidos_x0020_del_x0020_superv': excelRows[$rootScope.procesado]["Apellidos del supervisor"]
                                            };

                                            spsservice.post_data("lists/getbytitle('Objetivos')/items", data);

                                        } catch (error) {

                                            console.log("ERROR: procesado: " + $rootScope.procesado)

                                        }


                                    }

                                    $scope.progresobatch = parseInt(((iteracion * 100) / iteraciones));
                                    $scope.progresobatch = $scope.progresobatch >= 100 ? 100 : $scope.progresobatch;
                                    $('.progress-bar').css('width', $scope.progresobatch + '%');
                                    $("#theBar").html($scope.progresobatch + '%')


                                    if ($rootScope.procesado >= $rootScope.total) {

                                        clearInterval(id);
                                        console.log(new Date().toLocaleString() + " : " + "Batch end....");
                                        SweetAlert.swal("Carga de objetivos terminado!.", "", "success");
                                        $rootScope.procesando = false;
                                        $scope.progresobatch = 0;
                                        $rootScope.bloqueopantalla = false;

                                        $rootScope.procesado = 0;
                                        $rootScope.total = 0;
                                        $route.reload();
                                    }
                                }, $rootScope.timer);
                                //batch end ########################################################

                            } else {
                                SweetAlert.swal("Carga de objetivos terminado!.", "", "success");
                                $rootScope.procesando = false;
                                $scope.progresobatch = 0;
                                $rootScope.bloqueopantalla = false;

                                $rootScope.procesado = 0;
                                $rootScope.total = 0;
                                $route.reload();
                            }
                            // }//eliminar
                        } // fin primera carga







                    }
                });
            }




            //Subida de Jefes
            $scope.UploadJefes = function () {

                if ($scope.SelectedFile != null) {
                   
                    SweetAlert.swal({
                            title: "¿Está seguro de cargar los jefes?",
                            text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                            type: "warning",
                            showCancelButton: true,
                            confirmButtonColor: "#16AB39",
                            confirmButtonText: "Si, cargar los jefes!",
                            cancelButtonText: "Salir",
                            closeOnConfirm: true
                        },
                        function (isConfirm) {
                            if (isConfirm) {

                                //************ iniciar actualizar token
                                try {
                                    $.ajax({
                                        url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                                        async: true,
                                        type: "POST",
                                        headers: {
                                            "Accept": "application/json; odata=verbose"
                                        },
                                        success: function (response) {
                                            var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                                            $('#__REQUESTDIGEST').val(_DigestToken);

                                            //############# LOGICA 
                                            $rootScope.textoBloqueo = "Cargando información.  No actualizar la página hasta finalizar ...";

                                            $rootScope.procesado = 0;
                                            $rootScope.total = 0;



                                            $rootScope.bloqueopantalla = true;
                                            $rootScope.procesando = true;
                                            $scope.progresobatch = 0;

                                            var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.xls|.xlsx)$/;
                                            if (regex.test($scope.SelectedFile.name.toLowerCase())) {

                                                if (typeof (FileReader) != "undefined") {

                                                    var reader = new FileReader();
                                                    //For Browsers other than IE.
                                                    if (reader.readAsBinaryString) {

                                                        reader.onload = function (e) {

                                                            $scope.ProcessExcelJefes(e.target.result);

                                                        };

                                                        reader.readAsBinaryString($scope.SelectedFile);

                                                    } else {
                                                        //For IE Browser.
                                                        reader.onload = function (e) {

                                                            var data = "";
                                                            var bytes = new Uint8Array(e.target.result);
                                                            for (var i = 0; i < bytes.byteLength; i++) {
                                                                data += String.fromCharCode(bytes[i]);
                                                            }

                                                            $scope.ProcessExcelJefes(data);

                                                        };

                                                        reader.readAsArrayBuffer($scope.SelectedFile);

                                                    }
                                                } else {

                                                    alert("This browser does not support HTML5.");
                                                    $rootScope.procesando = false;
                                                    $rootScope.bloqueopantalla = false;
                                                }
                                            } else {

                                                alert("Please upload a valid Excel file.");
                                                $rootScope.procesando = false;
                                                $rootScope.bloqueopantalla = false;
                                            }

                                

                                        },
                                        error: function () {
                                            console.log("error refresh token");
                                        }
                                    });
                                } catch (err) {
                                    console.log("requestDigestToken error : " + err.message);
                                }
                                //************ fin actualizar token


                                

                            }

                        });
                } else {

                    SweetAlert.swal("Ops...", "Debe seleccionar un archivo para procesar.", "warning");
                    $rootScope.procesando = false;
                    $rootScope.bloqueopantalla = false;
                }


            };

            $scope.ProcessExcelJefes = function (data) {



                $scope.progresobatch = 0;

                var workbook = XLSX.read(data, {

                    type: 'binary'

                });

                var firstSheet = workbook.SheetNames[0];

                var excelRows = XLSX.utils.sheet_to_row_object_array(workbook.Sheets[firstSheet]);

                if (excelRows.length > 0) {

                    $scope.$apply(function () {

                        spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('Jefes')/Items?$select=Id,EVALUADOR,EVALUADO&$top=5000").then(function (resp_sup) {


                            if (resp_sup.d.results.length > 0) {

                                //batch init ########################################################

                                console.clear();


                                $rootScope.procesado = 0;
                                $rootScope.total = excelRows.length;
                                let iteraciones = Math.round($rootScope.total / $rootScope.factor);
                                if (iteraciones == 0) {

                                    iteraciones = 1;

                                }

                                let iteracion = 1;
                                console.log(new Date().toLocaleString() + " : " + "Batch conf.... Total: " + $rootScope.total + ", factor: " + $rootScope.factor);
                                console.log(new Date().toLocaleString() + " : " + "Batch start.... iteracion: " + (iteracion) + "/" + iteraciones);



                                //primera iteracion manual
                                let final = 0;

                                if ($rootScope.factor > $rootScope.total) {

                                    final = $rootScope.total;

                                } else {

                                    final = $rootScope.procesado + $rootScope.factor;

                                }
                                for ($rootScope.procesado; $rootScope.procesado < final; $rootScope.procesado++) {

                                    try {

                                        var _jefes = resp_sup.d.results.filter(x => x.EVALUADOR == excelRows[$rootScope.procesado].EVALUADOR && x.EVALUADO == excelRows[$rootScope.procesado].EVALUADO);
                                        var data = {

                                            '__metadata': {
                                                'type': 'SP.Data.JefesListItem'
                                            },
                                            'EVALUADOR': excelRows[$rootScope.procesado].EVALUADOR,
                                            'EVALUADO': excelRows[$rootScope.procesado].EVALUADO,
                                            'NOMBRES_EVALUADOR': excelRows[$rootScope.procesado]["NOMBRES EVALUADOR"],
                                            'APELLIDOS_EVALUADOR': excelRows[$rootScope.procesado]["APELLIDOS EVALUADOR"],
                                            'NOMBRES_EVALUADO': excelRows[$rootScope.procesado]["NOMBRE EVALUADO"],
                                            'APELLIDOS_EVALUADO': excelRows[$rootScope.procesado]["APELLIDOS EVALUADO"]


                                        };



                                        if (_jefes.length == 0) {

                                            spsservice.post_data("lists/getbytitle('Jefes')/items", data);

                                        } else {

                                            spsservice.put_data("lists/getbytitle('Jefes')/items(" + _jefes[0].ID + ")", data);
                                        }

                                    } catch (error) {

                                        console.log("ERROR: procesado: " + $rootScope.procesado)

                                    }

                                }
                                //end manual

                                $scope.progresobatch = parseInt(((iteracion * 100) / iteraciones));

                                $('.progress-bar').css('width', $scope.progresobatch + '%');

                                $("#theBar").html($scope.progresobatch + '%')

                                if ($scope.progresobatch < 100) {

                                    var id = setInterval(function () {
                                        // console.log(new Date().toLocaleString() + " : " + "Batch start.... iteraciones: " + iteraciones);  
                                        iteracion = iteracion + 1;
                                        console.log(new Date().toLocaleString() + " : " + "Batch next.... iteracion: " + (iteracion) + "/" + iteraciones);

                                        // let final = $rootScope.procesado + $rootScope.factor;     


                                        if ($rootScope.factor > ($rootScope.total - $rootScope.procesado)) {

                                            final = $rootScope.total;

                                        } else {

                                            final = $rootScope.procesado + $rootScope.factor;

                                        }

                                        for ($rootScope.procesado; $rootScope.procesado < final; $rootScope.procesado++) {

                                            try {



                                                var _jefes = resp_sup.d.results.filter(x => x.EVALUADOR == excelRows[$rootScope.procesado].EVALUADOR && x.EVALUADO == excelRows[$rootScope.procesado].EVALUADO);
                                                var data = {
                                                    '__metadata': {
                                                        'type': 'SP.Data.JefesListItem'
                                                    },
                                                    'EVALUADOR': excelRows[$rootScope.procesado].EVALUADOR,
                                                    'EVALUADO': excelRows[$rootScope.procesado].EVALUADO,
                                                    'NOMBRES_EVALUADOR': excelRows[$rootScope.procesado]["NOMBRES EVALUADOR"],
                                                    'APELLIDOS_EVALUADOR': excelRows[$rootScope.procesado]["APELLIDOS EVALUADOR"],
                                                    'NOMBRES_EVALUADO': excelRows[$rootScope.procesado]["NOMBRE EVALUADO"],
                                                    'APELLIDOS_EVALUADO': excelRows[$rootScope.procesado]["APELLIDOS EVALUADO"]
                                                };

                                                if (_jefes.length == 0) {

                                                    spsservice.post_data("lists/getbytitle('Jefes')/items", data);

                                                } else {

                                                    spsservice.put_data("lists/getbytitle('Jefes')/items(" + _jefes[0].ID + ")", data);
                                                }

                                            } catch (error) {

                                                console.log("ERROR: procesado: " + $rootScope.procesado)
                                            }

                                        }

                                        $scope.progresobatch = parseInt(((iteracion * 100) / iteraciones));

                                        $scope.progresobatch = $scope.progresobatch >= 100 ? 100 : $scope.progresobatch;

                                        $('.progress-bar').css('width', $scope.progresobatch + '%');

                                        $("#theBar").html($scope.progresobatch + '%')


                                        if ($rootScope.procesado >= $rootScope.total) {

                                            clearInterval(id);

                                            console.log(new Date().toLocaleString() + " : " + "Batch end....");

                                            SweetAlert.swal("Carga de jefes terminado!.", "", "success");

                                            $rootScope.procesando = false;

                                            $scope.progresobatch = 0;

                                            $rootScope.bloqueopantalla = false;

                                            $rootScope.procesado = 0;
                                            $rootScope.total = 0;

                                            $route.reload();

                                        }
                                    }, $rootScope.timer);
                                    //batch end ########################################################

                                } else {

                                    SweetAlert.swal("Carga de jefes terminado!.", "", "success");
                                    $rootScope.procesando = false;
                                    $scope.progresobatch = 0;
                                    $rootScope.bloqueopantalla = false;

                                    $rootScope.procesado = 0;
                                    $rootScope.total = 0;

                                    $route.reload();

                                }

                            } else { //primera carga

                                // for (let i = 0; i < excelRows.length; i++) {

                                //     var url = "lists/getbytitle('Jefes')/items";
                                //     var data = {

                                //         '__metadata': {

                                //             'type': 'SP.Data.JefesListItem'
                                //         },
                                //         'EVALUADOR': excelRows[i].EVALUADOR,
                                //         'EVALUADO': excelRows[i].EVALUADO

                                //     };

                                //     spsservice.post_data(url, data);
                                // }


                                //batch init ########################################################
                                console.clear();


                                $rootScope.procesado = 0;
                                $rootScope.total = excelRows.length;
                                let iteraciones = Math.round($rootScope.total / $rootScope.factor);
                                if (iteraciones == 0) {
                                    iteraciones = 1;
                                }

                                let iteracion = 1;
                                console.log(new Date().toLocaleString() + " : " + "Batch conf.... Total: " + $rootScope.total + ", factor: " + $rootScope.factor);
                                console.log(new Date().toLocaleString() + " : " + "Batch start.... iteracion: " + (iteracion) + "/" + iteraciones);



                                //primera iteracion manual
                                let final = 0;

                                if ($rootScope.factor > $rootScope.total) {

                                    final = $rootScope.total;

                                } else {

                                    final = $rootScope.procesado + $rootScope.factor;

                                }
                                for ($rootScope.procesado; $rootScope.procesado < final; $rootScope.procesado++) {

                                    try {
                                        var data = {
                                            '__metadata': {
                                                'type': 'SP.Data.JefesListItem'
                                            },
                                            'EVALUADOR': excelRows[$rootScope.procesado].EVALUADOR,
                                            'EVALUADO': excelRows[$rootScope.procesado].EVALUADO,
                                            'NOMBRES_EVALUADOR': excelRows[$rootScope.procesado]["NOMBRES EVALUADOR"],
                                            'APELLIDOS_EVALUADOR': excelRows[$rootScope.procesado]["APELLIDOS EVALUADOR"],
                                            'NOMBRES_EVALUADO': excelRows[$rootScope.procesado]["NOMBRE EVALUADO"],
                                            'APELLIDOS_EVALUADO': excelRows[$rootScope.procesado]["APELLIDOS EVALUADO"]
                                        };

                                        spsservice.post_data("lists/getbytitle('Jefes')/items", data);

                                    } catch (error) {

                                        console.log("ERROR: procesado: " + $rootScope.procesado)

                                    }
                                }
                                //end manual

                                $scope.progresobatch = parseInt(((iteracion * 100) / iteraciones));

                                $('.progress-bar').css('width', $scope.progresobatch + '%');
                                $("#theBar").html($scope.progresobatch + '%')

                                if ($scope.progresobatch < 100) {

                                    var id = setInterval(function () {
                                        // console.log(new Date().toLocaleString() + " : " + "Batch start.... iteraciones: " + iteraciones);      
                                        iteracion = 1 + iteracion;
                                        console.log(new Date().toLocaleString() + " : " + "Batch next.... iteracion: " + (iteracion) + "/" + iteraciones);

                                        // let final = $rootScope.procesado + $rootScope.factor;     

                                        if ($rootScope.factor > ($rootScope.total - $rootScope.procesado)) {
                                            final = $rootScope.total;
                                        } else {
                                            final = $rootScope.procesado + $rootScope.factor;
                                        }

                                        for ($rootScope.procesado; $rootScope.procesado < final; $rootScope.procesado++) {

                                            try {


                                                var data = {
                                                    '__metadata': {
                                                        'type': 'SP.Data.JefesListItem'
                                                    },
                                                    'EVALUADOR': excelRows[$rootScope.procesado].EVALUADOR,
                                                    'EVALUADO': excelRows[$rootScope.procesado].EVALUADO,
                                                    'NOMBRES_EVALUADOR': excelRows[$rootScope.procesado]["NOMBRES EVALUADOR"],
                                                    'APELLIDOS_EVALUADOR': excelRows[$rootScope.procesado]["APELLIDOS EVALUADOR"],
                                                    'NOMBRES_EVALUADO': excelRows[$rootScope.procesado]["NOMBRE EVALUADO"],
                                                    'APELLIDOS_EVALUADO': excelRows[$rootScope.procesado]["APELLIDOS EVALUADO"]
                                                };

                                                spsservice.post_data("lists/getbytitle('Jefes')/items", data);

                                            } catch (error) {

                                                console.log("ERROR: procesado: " + $rootScope.procesado)

                                            }

                                        }

                                        $scope.progresobatch = parseInt(((iteracion * 100) / iteraciones));
                                        $scope.progresobatch = $scope.progresobatch >= 100 ? 100 : $scope.progresobatch;
                                        $('.progress-bar').css('width', $scope.progresobatch + '%');
                                        $("#theBar").html($scope.progresobatch + '%')


                                        if ($rootScope.procesado >= $rootScope.total) {

                                            clearInterval(id);
                                            console.log(new Date().toLocaleString() + " : " + "Batch end....");
                                            SweetAlert.swal("Carga de jefes terminado!.", "", "success");
                                            $rootScope.procesando = false;
                                            $scope.progresobatch = 0;
                                            $rootScope.bloqueopantalla = false;

                                            $rootScope.procesado = 0;
                                            $rootScope.total = 0;

                                            $route.reload();
                                        }
                                    }, $rootScope.timer);
                                    //batch end ########################################################

                                } else {
                                    SweetAlert.swal("Carga de jefes terminado!.", "", "success");
                                    $rootScope.procesando = false;
                                    $scope.progresobatch = 0;
                                    $rootScope.bloqueopantalla = false;

                                    $rootScope.procesado = 0;
                                    $rootScope.total = 0;

                                    $route.reload();
                                }



                            } // fin primera carga

                        });

                    });

                }

            };

            //Subida de escalas (carga total y se deben eliminar las evaluaciones hasta el momento)
            $scope.UploadEscalas = function () {
               
                if ($scope.SelectedFile != null) {


                    SweetAlert.swal({
                            title: "¿Está seguro de cargar las escalas?",
                            text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                            type: "warning",
                            showCancelButton: true,
                            confirmButtonColor: "#16AB39",
                            confirmButtonText: "Si, cargar las escalas",
                            cancelButtonText: "Salir",
                            closeOnConfirm: true
                        },
                        function (isConfirm) {
                            if (isConfirm) {

                              

                                //************ iniciar actualizar token
                                try {
                                    $.ajax({
                                        url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                                        async: true,
                                        type: "POST",
                                        headers: {
                                            "Accept": "application/json; odata=verbose"
                                        },
                                        success: function (response) {
                                            var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                                            $('#__REQUESTDIGEST').val(_DigestToken);

                                            //############# LOGICA 
                                            $rootScope.textoBloqueo = "Cargando información.  No actualizar la página hasta finalizar ...";

                                            $rootScope.procesado = 0;
                                            $rootScope.total = 0;
            
            
            
                                            //Realizar eliminacion masiva de todas las escalas
            
                                            $rootScope.bloqueopantalla = true;
            
                                            $rootScope.procesando = true;
            
                                            $scope.progresobatch = 0;
            
                                            var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.xls|.xlsx)$/;
                                            if (regex.test($scope.SelectedFile.name.toLowerCase())) {
            
                                                if (typeof (FileReader) != "undefined") {
            
                                                    var reader = new FileReader();
            
                                                    //For Browsers other than IE.
                                                    if (reader.readAsBinaryString) {
            
                                                        reader.onload = function (e) {
            
                                                            $scope.ProcessExcelEscalas(e.target.result);
                                                        };
            
                                                        reader.readAsBinaryString($scope.SelectedFile);
            
                                                    } else {
                                                        //For IE Browser.
                                                        reader.onload = function (e) {
            
                                                            var data = "";
                                                            var bytes = new Uint8Array(e.target.result);
                                                            for (var i = 0; i < bytes.byteLength; i++) {
            
                                                                data += String.fromCharCode(bytes[i]);
            
                                                            }
            
                                                            $scope.ProcessExcelEscalas(data);
            
                                                        };
            
                                                        reader.readAsArrayBuffer($scope.SelectedFile);
            
                                                    }
                                                } else {
            
                                                    alert("This browser does not support HTML5.");
                                                    $rootScope.procesando = false;
                                                    $rootScope.bloqueopantalla = false;
            
                                                }
                                            } else {
            
                                                alert("Please upload a valid Excel file.");
                                                $rootScope.procesando = false;
                                                $rootScope.bloqueopantalla = false;
            
                                            }
            
                                            

                                        },
                                        error: function () {
                                            console.log("error refresh token");
                                        }
                                    });
                                } catch (err) {
                                    console.log("requestDigestToken error : " + err.message);
                                }
                                //************ fin actualizar token

                               

                            }

                        });
                } else {

                    SweetAlert.swal("Ops...", "Debe seleccionar un archivo para procesar.", "warning");
                    $rootScope.procesando = false;
                    $rootScope.bloqueopantalla = false;

                }

            };

            $scope.ProcessExcelEscalas = function (data) {


                var nombreEscala = "";
                $scope.progresobatch = 0;

                var workbook = XLSX.read(data, {

                    type: 'binary'

                });

                var firstSheet = workbook.SheetNames[0];
                var excelRows = XLSX.utils.sheet_to_row_object_array(workbook.Sheets[firstSheet]);

                // 
                if (excelRows.length > 0) {


                    $scope.$apply(function () {

                        $rootScope.eliminarDatos("Escalas_de_produccion", excelRows, false);                        
                    });

                }

            };
            /// fin escalas

        })

}(angular.module('spsmodule')));