(function (app) {
    app
        .controller('spscontroller', function ($scope, spsservice, $http, $rootScope, SweetAlert, $window, $uibModal, $location) {



            $rootScope.menuActivo = function () {
                debugger;
                // configuracion de menu            
                angular.element(document.querySelector('#itemHomeMenu')).removeClass('menuIndicadores');
                angular.element(document.querySelector('#itemAsuntos')).removeClass('menuIndicadores');
                angular.element(document.querySelector('#itemActividades')).removeClass('menuIndicadores');
                angular.element(document.querySelector('#itemStakeholders')).removeClass('menuIndicadores');
                angular.element(document.querySelector('#itemSkyview')).removeClass('menuIndicadores');

                switch ($location.$$url.split("/")[1]) {
                    
                    case "":
                        var myEl = angular.element(document.querySelector('#itemHomeMenu'));
                        myEl.addClass('menuIndicadores');
                        break;
                    case "Asuntos":
                        var myEl = angular.element(document.querySelector('#itemAsuntos'));
                        myEl.addClass('menuIndicadores');
                        break;
                    case "Actividades":
                        var myEl = angular.element(document.querySelector('#itemActividades'));
                        myEl.addClass('menuIndicadores');
                        break;
                    case "Stakeholders":
                        var myEl = angular.element(document.querySelector('#itemStakeholders'));
                        myEl.addClass('menuIndicadores');
                        break;
                    case "Skyview":
                        var myEl = angular.element(document.querySelector('#itemSkyview'));
                        myEl.addClass('menuIndicadores');
                        break;
                  


                }
                // fin configurar menu
            }



            $rootScope.isAdmin = false;

            $rootScope.monthNames = [{
                nombre: "Enero"
            },
            {
                nombre: "Febrero"
            },
            {
                nombre: "Marzo"
            },
            {
                nombre: "Abril"
            },
            {
                nombre: "Mayo"
            },
            {
                nombre: "Junio"
            },
            {
                nombre: "Julio"
            },
            {
                nombre: "Agosto"
            },
            {
                nombre: "Septiembre"
            },
            {
                nombre: "Octubre"
            },
            {
                nombre: "Noviembre"
            },
            {
                nombre: "Diciembre"
            }
        ];

        var fechaActual = new Date();
        $rootScope.anio = fechaActual.getFullYear();
        $rootScope._anio = $rootScope.anio.toString();
        //JSON AÑOS DE SELECT
        $rootScope.anioCarga = [];


        var anioInicial = 2017


        for (anioInicial; anioInicial <= $rootScope.anio; anioInicial++) {
            $rootScope.anioCarga.push({
                "anio": anioInicial
            })

        }
        

            $rootScope.filtro = {};

            $scope.salirSistema = function () {
                $window.location.href = _spPageContextInfo.webAbsoluteUrl + "/_layouts/SignOut.aspx";
            }

            $rootScope.goBackend = function () {
                $window.location.href = _spPageContextInfo.webAbsoluteUrl + "/_layouts/15/viewlsts.aspx";
            }

            setTimeout(function () {
                $rootScope.refreshToken();
            }, 200000);

            $rootScope.refreshToken = function () {
                try {
                    $.ajax({
                        url: _spPageContextInfo.webAbsoluteUrl + "/_api/contextinfo",
                        async: true,
                        type: "POST",
                        headers: {
                            "Accept": "application/json; odata=verbose"
                        },
                        success: function (response) {
                            var _DigestToken = response.d.GetContextWebInformation.FormDigestValue;
                            $('#__REQUESTDIGEST').val(_DigestToken);
                            console.log("refreshToken actualizado");
                        },
                        error: function () {
                            console.log("error refresh token");
                        }
                    });
                } catch (err) {
                    console.log("requestDigestToken: " + err.message);
                }
            }

            $rootScope.volver = function (routePath) {

                $location.path('/' + routePath);
            };


            $rootScope.obtenerComunasUsuario = function (operacion) {
                $rootScope.comunasUsuarioData = $rootScope.comunasUsuario.filter(x => x.Zona == operacion || x.Zona == "");
            }



            //verificar perfil de usuario
            $rootScope.checkAdmin = function () {
                // 
                var qry = "/_api/web/currentuser?$expand=Groups&$select=Id,Groups,Email";
                var getData = spsservice.get_data(qry);
                getData.then(function (resp) {
                    if (resp.d.Groups.results.length > 0) {
                        $rootScope.userid = resp.d.Id;
                        $rootScope.userEmail = resp.d.Email;

                        //Obtener zonas del usuario
                        let _filterZona = "";
                        $rootScope.filterOperacion = "";
                        $rootScope.zonasUsuario = [];
                        for (i = 0; i < resp.d.Groups.results.length; i++) {

                            if (resp.d.Groups.results[i].Title.startsWith("AdministradorComunidades")) {

                                $rootScope.isAdmin = true;
                            }


                            if (resp.d.Groups.results[i].Title.startsWith("Zona")) {

                                $rootScope.zonasUsuario.push({
                                    "zona": resp.d.Groups.results[i].Title
                                });

                                if (_filterZona == "") {
                                    _filterZona += "&$filter=Zona eq '" + resp.d.Groups.results[i].Title + "'";
                                    $rootScope.filterOperacion += "&$filter=(Operacion eq '" + resp.d.Groups.results[i].Title + "'";
                                } else {
                                    _filterZona += " or Zona eq '" + resp.d.Groups.results[i].Title + "'";
                                    $rootScope.filterOperacion += " or Operacion eq '" + resp.d.Groups.results[i].Title + "'";
                                }
                            }
                        }

                        if ($rootScope.filterOperacion != "") {
                            $rootScope.filterOperacion += ")";
                        }





                        //Obtener Comunas segun zona de usuario
                        //Obtener ZonasComunas            
                        spsservice.get_type('lists/getbytitle', 'ZonasComunas', "/Items?$select=ID,Zona,Comuna&$top=5000" + _filterZona + "&$orderby=Comuna asc").then(function (_zonascomunasResponse) {
                            if (_zonascomunasResponse.d.results.length > 0) {
                                $rootScope.comunasUsuario = _zonascomunasResponse.d.results;
                                $rootScope.comunasUsuario.push({
                                    "Comuna": "Otra",
                                    "Zona": ""
                                });

                            }
                        });
                        // fin obtener stackeholders


                    }
                });
            };

            $rootScope.checkAdmin();


            //Obtener parametros

            var getParametros = spsservice.get_type('lists/getbytitle', 'Parametros', "/Items?$select=ID,Title,Valor,RelacionadoId&$top=2000&$orderby=Valor");
            getParametros.then(function (rParametros) {
                //console.log(rParametros.d.results);
                if (rParametros.d.results.length > 0) {
                    $rootScope.parametros = rParametros.d.results;
                    
                    $rootScope.operaciones = $rootScope.parametros.filter(x => x.Title == 'Operacion');
                    $rootScope.ambitos = $rootScope.parametros.filter(x => x.Title == 'Ambito');
                    $rootScope.comunas = $rootScope.parametros.filter(x => x.Title == 'Comuna');
                    $rootScope.tipoStakeholder = $rootScope.parametros.filter(x => x.Title == 'TipoStakeholder');
                    $rootScope.categoriaStakeholder = $rootScope.parametros.filter(x => x.Title == 'CategoriaStakeholder');

                    $rootScope.tipoInstitucionSkyview = $rootScope.parametros.filter(x => x.Title == 'TipoInstitucionSkyview');

                    

                }
            });
            // fin obtener 




            //Obtener stackeholders       
            $rootScope.ObtenerStackeholders = function () {
                spsservice.get_type('lists/getbytitle', 'Stakeholder', "/Items?$select=Relevancia,Title,ID,Rol,Tipoo,Operacion,Comuna,OtraComuna,Author/Title,Editor/Title&$orderby=ID desc&$expand=Author,Editor&$top=5000").then(function (rStake) {

                    if (rStake.d.results.length > 0) {
                        $rootScope.stakeholdersData = rStake.d.results;
                    }
                });
            }
            // fin obtener stackeholders

            $rootScope.ObtenerStackeholders();


           

            //$rootScope.ObtenerSkyview();

            //Obtener Organizaciones            
            spsservice.get_type('lists/getbytitle', 'Organizaciones', "/Items?$select=*&$top=5000").then(function (rOrganizaciones) {
                if (rOrganizaciones.d.results.length > 0) {
                    $rootScope.organizacionesData = rOrganizaciones.d.results;
                }
            });
            //Fin obtener Organizaciones



            $scope.showModalCrearAdjudicacion = function (fileselected, size, parentSelector) {
                $rootScope.fileselected = fileselected;
                var parentElem = parentSelector ?
                    angular.element($document[0].querySelector('.modal-demo ' + parentSelector)) : undefined;
                var modalInstance = $uibModal.open({
                    animation: true,
                    ariaLabelledBy: 'modal-title',
                    ariaDescribedBy: 'modal-body',
                    templateUrl: 'pages/modalCrearAdjudicacion.html',
                    controller: 'modalCrearAdjudicacionController',
                    controllerAs: '$scope',
                    size: size,
                    appendTo: parentElem,
                    resolve: {
                        items: function () {
                            return $scope.items;
                        }
                    }
                });
            };

        })


        .controller('modalCrearAdjudicacionController', function ($scope, spsservice, $http, $rootScope, SweetAlert, $window, $uibModal, $location, $uibModalInstance) {
            $scope.crearAdjudicacion = function (numAdjudicacion) {
                var url = "lists/getbytitle('Adjudicaciones')/items";
                var data = {
                    '__metadata': {
                        'type': 'SP.Data.AdjudicacionesListItem'
                    },
                    'Title': numAdjudicacion,
                };
                spsservice.post_data(url, data).then(function (_adjudicaciones) {
                    if (_adjudicaciones.d != null) {
                        SweetAlert.swal("Adjudicación creada.", "", "success");

                        $uibModalInstance.dismiss('cancel');
                        $location.path("/Adjudicaciones/" + _adjudicaciones.d.ID);
                    }
                });
            }

            $scope.cerrarModal = function () {
                $uibModalInstance.dismiss('cancel');
            }

        })

        .controller('DetalleAdjudicacionController', function ($scope, spsservice, $http, $rootScope, SweetAlert, $window, $uibModal, numAdjudicacion, $route, $location) {



            $scope.numAdjudicacion = numAdjudicacion;


            $scope.obtenerDatosVista = function () {
                //Obtener info adjudicacion          
                spsservice.get_generic_url(_spPageContextInfo.siteAbsoluteUrl + "/_api/web/lists/getbytitle('Adjudicaciones')/items?$select=*,Author/Title,Editor/Title&$Expand=Author,Editor&$filter=ID eq " + numAdjudicacion).then(function (_adjudicacion) {
                    $scope.adjudicacion = _adjudicacion.d.results[0];
                });


                //Obtener archivos          
                //select=*,Author/Title,Editor/Title&$Expand=Author,Editor
                spsservice.get_generic_url(_spPageContextInfo.siteAbsoluteUrl + "/_api/web/lists/getbytitle('AdjudicacionArchivos')/items?$select=Author/Title,Editor/Title,FileLeafRef,File_x0020_Type,FileRef,ID,FileSizeDisplay,*&$Expand=Author,Editor&$filter=AdjudicacionId eq " + numAdjudicacion).then(function (_adjudicacionArchivos) {
                    $scope.archivos = _adjudicacionArchivos.d.results;
                });
            }



            $scope.obtenerDatosVista();


            $scope.volverAdjudicaciones = function () {
                $location.path("/Adjudicaciones");
            }

            $scope.showModalModificarArchivo = function (infoArchivoEdicion, size, parentSelector) {
                $rootScope.infoArchivoEdicion = infoArchivoEdicion;
                var parentElem = parentSelector ?
                    angular.element($document[0].querySelector('.modal-demo ' + parentSelector)) : undefined;
                var modalInstance = $uibModal.open({
                    animation: true,
                    ariaLabelledBy: 'modal-title',
                    ariaDescribedBy: 'modal-body',
                    templateUrl: 'pages/modalModificarArchivo.html',
                    controller: 'ModificarArchivoController',
                    controllerAs: '$scope',
                    size: size,
                    appendTo: parentElem,
                    resolve: {
                        items: function () {
                            return $scope.items;
                        }
                    }
                });
            };

            $scope.showModalControlCambios = function (infoArchivoControlCambios, size, parentSelector) {
                $rootScope.infoArchivoControlCambios = infoArchivoControlCambios;
                var parentElem = parentSelector ?
                    angular.element($document[0].querySelector('.modal-demo ' + parentSelector)) : undefined;
                var modalInstance = $uibModal.open({
                    animation: true,
                    ariaLabelledBy: 'modal-title',
                    ariaDescribedBy: 'modal-body',
                    templateUrl: 'pages/modalControlCambiosArchivo.html',
                    controller: 'ModalControlCambiosArchivoController',
                    controllerAs: '$scope',
                    size: size,
                    appendTo: parentElem,
                    resolve: {
                        items: function () {
                            return $scope.items;
                        }
                    }
                });
            };

            $scope.showModalComentarios = function (infoArchivoComentarios, size, parentSelector) {
                $rootScope.infoArchivoComentarios = infoArchivoComentarios;
                var parentElem = parentSelector ?
                    angular.element($document[0].querySelector('.modal-demo ' + parentSelector)) : undefined;
                var modalInstance = $uibModal.open({
                    animation: true,
                    ariaLabelledBy: 'modal-title',
                    ariaDescribedBy: 'modal-body',
                    templateUrl: 'pages/modalComentariosArchivo.html',
                    controller: 'ModalComentariosArchivoController',
                    controllerAs: '$scope',
                    size: size,
                    appendTo: parentElem,
                    resolve: {
                        items: function () {
                            return $scope.items;
                        }
                    }
                });
            };


            $scope.subirArchivo = function () {
                SweetAlert.swal({
                        title: "¿Está seguro de subir el archivo?",
                        text: "",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#DD6B55",
                        confirmButtonText: "Si, subir!",
                        cancelButtonText: "Cancelar",
                        closeOnClickOutside: true,
                        closeOnEsc: true,
                        allowOutsideClick: false,
                        closeOnConfirm: true
                    },
                    function (isConfirm) {
                        if (isConfirm) {
                            var file = document.getElementById("archivoAdjudicacion").files[0];
                            // var name = file.name.replace(/-/g, '');

                            $rootScope.getFileBuffer(file).then(function (buffer) {
                                var urlAttachment = "GetFolderByServerRelativeUrl('AdjudicacionArchivos')/Files/add(url='" + file.name + "',overwrite=true)";
                                spsservice.attach_data(urlAttachment, buffer).then(function (resp) {

                                    //hacer get para obtener ID y modificar 
                                    spsservice.get_generic_url(resp.d.ListItemAllFields.__deferred.uri).then(function (_respAllFields) {
                                        var url = "lists/getbytitle('AdjudicacionArchivos')/items(" + _respAllFields.d.ID + ")";
                                        var data = {
                                            '__metadata': {
                                                'type': 'SP.Data.AdjudicacionArchivosItem'
                                            },
                                            AdjudicacionId: numAdjudicacion,
                                        }
                                        spsservice.put_data(url, data).then(function (data) {

                                            console.log(data)
                                            $route.reload();
                                            SweetAlert.swal("Archivo agregado.", "", "success");
                                        });



                                        //crear version en control de cambios
                                        url = "lists/getbytitle('ControlCambiosArchivos')/items";
                                        data = {
                                            '__metadata': {
                                                'type': 'SP.Data.ControlCambiosArchivosListItem'
                                            },
                                            'Title': "Versión inicial",
                                            'NumeroVersion': 1,
                                            'AdjudicacionArchivosId': _respAllFields.d.ID
                                        };
                                        spsservice.post_data(url, data).then(function (_controlCambiosArchivos) {});


                                    });






                                })
                            })
                        }
                    });
            }

            $rootScope.getFileBuffer = function (file) {
                var deferred = $.Deferred();
                var reader = new FileReader();
                reader.onload = function (e) {
                    deferred.resolve(e.target.result);
                }
                reader.onerror = function (e) {
                    deferred.reject(e.target.error);
                }
                reader.readAsArrayBuffer(file);
                return deferred.promise();
            }


            $scope.solicitudEliminarArchivo = function (ID) {

                var url = "lists/getbytitle('AdjudicacionArchivos')/items(" + ID + ")";
                var data = {
                    '__metadata': {
                        'type': 'SP.Data.AdjudicacionArchivosItem'
                    },
                    Estado: "Flujo eliminación"
                }

                spsservice.put_data(url, data).then(function (data) {

                    $route.reload();
                    SweetAlert.swal("Flujo de eliminación agragado.", "", "success");
                });

            }


            $scope.eliminarArchivo = function (ID) {
                SweetAlert.swal({
                        title: "¿Está seguro de eliminar el archivo?",
                        text: "",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#DD6B55",
                        confirmButtonText: "Si, eliminar!",
                        cancelButtonText: "Cancelar",
                        closeOnClickOutside: true,
                        closeOnEsc: true,
                        allowOutsideClick: false,
                        closeOnConfirm: true
                    },
                    function (isConfirm) {
                        if (isConfirm) {

                            var url = "lists/getbytitle('AdjudicacionArchivos')/Items(" + ID + ")";
                            spsservice.delete_data(url).then(function (_delete) {






                                $route.reload();

                                SweetAlert.swal({
                                    type: "success",
                                    title: "Archivo eliminado",
                                    imageSize: '80x80',
                                    confirmButtonText: 'Aceptar',
                                    showCancelButton: false,
                                });

                            })

                        }
                    });
            }








        })


        .controller('AdjudicacionesController', function ($scope, spsservice, $http, $rootScope, SweetAlert, $window, $uibModal, $location) {


            //cargar calendario con fecha del dia

            if ($rootScope.filtroDesde == null) {
                var today = new Date();
                $rootScope.filtroDesde = new Date(today.getFullYear(), today.getMonth(), today.getDate(), 0, 0, 0);
                $rootScope.filtroHasta = new Date(today.getFullYear(), today.getMonth(), today.getDate(), 0, 0, 0);
            } else {
                $scope.filtroDesde = $rootScope.filtroDesde;
                $scope.filtroHasta = $rootScope.filtroHasta;
            }



            //console.log($rootScope.adjudicaciones);



            $scope.buscarAdjudicacion = function () {

                $rootScope.filtroDesde = $scope.filtroDesde;
                $rootScope.filtroHasta = $scope.filtroHasta;

                // Created ge datetime'2018-10-05T00:00:00Z'
                // new Date( $scope.filtroDesde.getFullYear(),  $scope.filtroDesde.getMonth(),  $scope.filtroDesde.getDate(),0,0,0);

                var filesUrlGet = _spPageContextInfo.siteAbsoluteUrl + "/_api/web/lists/getbytitle('Adjudicaciones')/items?$select=*,Author/Title,Editor/Title&$Expand=Author,Editor&$filter=Created ge datetime'" + $scope.filtroDesde.localeFormat("yyyy-MM-ddT00:00:00Z") + "' and Created le datetime'" + $scope.filtroHasta.localeFormat("yyyy-MM-ddT23:59:59Z") + "'"

                spsservice.get_generic_url(filesUrlGet).then(function (_adjudicacionArchivos) {

                    $rootScope.adjudicaciones = _adjudicacionArchivos.d.results;

                    console.log($scope.archivos);

                });

            }


        })


        .controller('AdjudicacionesPanelGestionController', function ($scope, spsservice, $http, $rootScope, SweetAlert, $window, $uibModal, $location) {





        })


        .controller('ModificarArchivoController', function ($scope, spsservice, $http, $rootScope, SweetAlert, $window, $uibModal, $location, $uibModalInstance, $route) {


            // alert("ModificarArchivoController")



            $scope.cerrarModal = function () {
                $uibModalInstance.dismiss('cancel');
            }


            $scope.modificarArchivo = function () {

                SweetAlert.swal({
                        title: "¿Está seguro de modificar el archivo?",
                        text: "",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#DD6B55",
                        confirmButtonText: "Si, modificar!",
                        cancelButtonText: "Cancelar",
                        closeOnClickOutside: true,
                        closeOnEsc: true,
                        allowOutsideClick: false,
                        closeOnConfirm: true
                    },
                    function (isConfirm) {
                        if (isConfirm) {
                            var file = document.getElementById("archivoAdjudicacionModificado").files[0];

                            //se cargar con el mismo nombre para que haga replace
                            $rootScope.getFileBuffer(file).then(function (buffer) {
                                var urlAttachment = "GetFolderByServerRelativeUrl('AdjudicacionArchivos')/Files/add(url='" + $rootScope.infoArchivoEdicion.FileLeafRef + "',overwrite=true)";
                                spsservice.attach_data(urlAttachment, buffer).then(function (resp) {




                                    let _numeroVersion = $rootScope.infoArchivoEdicion.VersionArchivo + 1;

                                    //modificar version de archivo
                                    var url = "lists/getbytitle('AdjudicacionArchivos')/items(" + $rootScope.infoArchivoEdicion.ID + ")";
                                    var data = {
                                        '__metadata': {
                                            'type': 'SP.Data.AdjudicacionArchivosItem'
                                        },
                                        'VersionArchivo': _numeroVersion
                                    }
                                    spsservice.put_data(url, data).then(function (data) {

                                        console.log(data)
                                        $route.reload();
                                        SweetAlert.swal("Archivo agregado.", "", "success");
                                    });



                                    //crear version en control de cambios
                                    url = "lists/getbytitle('ControlCambiosArchivos')/items";
                                    data = {
                                        '__metadata': {
                                            'type': 'SP.Data.ControlCambiosArchivosListItem'
                                        },
                                        'Title': $scope.detalleArchivoAdjudicacionModificado,
                                        'NumeroVersion': _numeroVersion,
                                        'AdjudicacionArchivosId': $rootScope.infoArchivoEdicion.ID
                                    };
                                    spsservice.post_data(url, data).then(function (_controlCambiosArchivos) {});


                                    $uibModalInstance.dismiss('cancel');
                                    $route.reload();
                                    SweetAlert.swal("Archivo modificado.", "", "success");

                                })
                            })
                        }
                    });


            }

        })

        .controller('ModalControlCambiosArchivoController', function ($scope, spsservice, $http, $rootScope, SweetAlert, $window, $uibModal, $location, $uibModalInstance) {

            var filesUrlGet = _spPageContextInfo.siteAbsoluteUrl + "/_api/web/lists/getbytitle('ControlCambiosArchivos')/items?$select=*,Author/Title,Editor/Title&$Expand=Author,Editor&$filter=AdjudicacionArchivosId eq " + $rootScope.infoArchivoControlCambios.ID;
            spsservice.get_generic_url(filesUrlGet).then(function (_controlCambiosArchivos) {
                $scope.versionesArchivo = _controlCambiosArchivos.d.results;
            });

            $scope.cerrarModal = function () {
                $uibModalInstance.dismiss('cancel');
            }
        })


        .controller('ModalComentariosArchivoController', function ($scope, spsservice, $http, $rootScope, SweetAlert, $window, $uibModal, $location, $uibModalInstance) {




            $scope.obtenerComentarios = function () {
                var filesUrlGet = _spPageContextInfo.siteAbsoluteUrl + "/_api/web/lists/getbytitle('ComentariosArchivos')/items?$select=*,Author/Title,Editor/Title&$Expand=Author,Editor&$filter=AdjudicacionArchivosId eq " + $rootScope.infoArchivoComentarios.ID;
                spsservice.get_generic_url(filesUrlGet).then(function (_comentariosArchivos) {
                    $scope.comentariosArchivos = _comentariosArchivos.d.results;
                });
            }

            $scope.obtenerComentarios();

            $scope.cerrarModal = function () {
                $uibModalInstance.dismiss('cancel');
            }

            $scope.agregarComentario = function (comentarioUsuario) {
                var url = "lists/getbytitle('ComentariosArchivos')/items";
                var data = {
                    '__metadata': {
                        'type': 'SP.Data.ComentariosArchivosListItem'
                    },
                    'Title': comentarioUsuario,
                    'AdjudicacionArchivosId': $rootScope.infoArchivoComentarios.ID
                };
                spsservice.post_data(url, data).then(function (_comentariosArchivos) {
                    if (_comentariosArchivos.d != null) {
                        $scope.obtenerComentarios();
                        SweetAlert.swal("Comentario agregado.", "", "success");

                        // $uibModalInstance.dismiss('cancel');
                        // $location.path("/Adjudicaciones/" + _adjudicaciones.d.ID);
                    }
                });
            }


        })







}(angular.module('spsmodule')));