(function (app) {
    app
        .controller('DetalleAsuntoController', function ($scope, $http, $rootScope, $route, SweetAlert, spsservice, $uibModal, $location, id) {

            // obtiene 1 asunto
            var getAsunto = spsservice.get_type('lists/getbytitle', 'Asuntos', "/Items?$select=*&$filter=Id eq " + id);
            getAsunto.then(function (resp_sup) {
                if (resp_sup.d.results.length > 0) {
                    $scope.asunto = resp_sup.d.results[0];
                    $scope.asunto.FechaReunion = new Date($scope.asunto.FechaReunion);
                    $rootScope.obtenerActividades();

                    var _ambito = $scope.ambitos.filter(x => x.Valor == $scope.asunto.Ambito);
                    $rootScope.programas = $rootScope.parametros.filter(x => x.Title == 'Programa' && x.RelacionadoId == _ambito[0].ID);
                    $rootScope.comunasUsuarioData = $rootScope.comunasUsuario.filter(x => x.Zona == $scope.asunto.Operacion || x.Zona == "");
                }
            });

            $scope.verMaps = function(urlMaps){
                
                window.open(urlMaps, "_blank");
            }

            $rootScope.obtenerActividades = function () {
                var getList = spsservice.get_type('lists/getbytitle', 'Actividades', "/Items?$select=FechaActividad,StakeholdersArray,ID,Title,Modified,Descripcion,Operacion,Comuna,OtraComuna,Participantes,Gastado,AsuntoId,Author/Title,Editor/Title,AttachmentFiles/FileName,AttachmentFiles/ServerRelativeUrl&$filter=AsuntoId eq " + $scope.asunto.Id + "&$orderby=ID desc&$expand=Author,Editor,AttachmentFiles");
                getList.then(function (resp_sup) {
                    if (resp_sup.d.results.length > 0) {
                        $scope.Actividades = resp_sup.d.results;
                        for (let i = 0; i < $scope.Actividades.length; i++) {
                            $scope.Actividades[i].StakeholdersArray = JSON.parse($scope.Actividades[i].StakeholdersArray);                       
                        }
                    }
                });
            }

            $scope.modificarAsunto = function () {
                var data = {
                    '__metadata': {
                        'type': 'SP.Data.AsuntosListItem'
                    },
                    'Title': $scope.asunto.Title, //nombre
                    'FechaReunion': $scope.asunto.FechaReunion,
                    'Ambito': $scope.asunto.Ambito,
                    'Programa': $scope.asunto.Programa,
                    // 'Comuna': $scope.asunto.Comuna == 'Otra' ? $scope.asunto.ComunaOtra : $scope.asunto.Comuna,
                    'Ubicacion': $scope.asunto.Ubicacion,
                    'Presupuesto': $scope.asunto.Presupuesto,

                    'Comuna': $scope.asunto.Comuna,
                    'OtraComuna': $scope.asunto.OtraComuna,
                };

                spsservice.put_data("lists/getbytitle('Asuntos')/items(" + $scope.asunto.ID + ")", data).then(function () {
                    SweetAlert.swal("Información guardada.", "", "success");
                    $route.reload();
                    $scope.cancel();

                });

            }

            $scope.eliminarAdjunto = function (fileName, actividadId) {

                $rootScope.refreshToken();
                SweetAlert.swal({
                        title: "¿Está seguro de eliminar el adjunto?",
                        text: "No se puede revertir esta operación.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#DD6B55",
                        confirmButtonText: "Si, eliminar!",
                        cancelButtonText: "Cancelar",
                        closeOnConfirm: false
                    },
                    function (isConfirm) {
                        if (isConfirm) {
                            spsservice.remove_attach("lists/getbytitle('Actividades')/items(" + actividadId + ")/AttachmentFiles/getByFileName('" + fileName + "')").then(function () {
                                $route.reload();
                                SweetAlert.swal("Se eliminó el adjunto.", "", "success");
                            });
                        }
                    });
            }
           
            $scope.showModalAgregarAdjuntoActividad = function (actividadId, size, parentSelector) {

                $rootScope.idActividad = actividadId;

                var parentElem = parentSelector ? angular.element($document[0].querySelector('.modal-demo ' + parentSelector)) : undefined;
                $uibModal.open({
                    animation: true,
                    ariaLabelledBy: 'modal-title',
                    ariaDescribedBy: 'modal-body',
                    backdrop: 'static',
                    templateUrl: 'pages/actividades/modalAgregarAdjuntoActividad.html',
                    controller: 'modalAgregarAdjuntoActividadController',
                    controllerAs: '$scope',
                    size: size,
                    appendTo: parentElem,
                    resolve: {
                        items: function () {
                            return $scope.items;
                        }
                    }
                });
            };

            $scope.showModalAgregarActividad = function (asunto, actividadid, getActStk, modificar, actividades, size, parentSelector) {

                $rootScope.asuntoModal = asunto;
                $rootScope.actividadesModal = actividades;
                $rootScope.idActividad = actividadid;
                $rootScope.modificarActividad = true;
                $rootScope.getActividad = getActStk;

                $rootScope.editarActividad = modificar;

                var parentElem = parentSelector ? angular.element($document[0].querySelector('.modal-demo ' + parentSelector)) : undefined;
                var modalInstance = $uibModal.open({
                    animation: true,
                    ariaLabelledBy: 'modal-title',
                    ariaDescribedBy: 'modal-body',
                    backdrop: 'static',
                    templateUrl: 'pages/actividades/modalAgregarActividad.html',
                    controller: 'modalAgregarActividadController',
                    controllerAs: '$scope',
                    size: size,
                    appendTo: parentElem,
                    resolve: {
                        items: function () {
                            return $scope.items;
                        }
                    }
                });
            };


            $scope.obtenerProgramas = function (ambito) {
                var _ambito = $scope.ambitos.filter(x => x.Valor == ambito);
                $rootScope.programas = $rootScope.parametros.filter(x => x.Title == 'Programa' && x.RelacionadoId == _ambito[0].ID);
            }


        }) //Fin DetalleAsuntoController


        .controller('modalAgregarActividadController', function ($scope, $uibModalInstance, $route, $http, $rootScope, SweetAlert, spsservice, $uibModal, $location, $window, $timeout, $interval) {


            $rootScope.blockInputModal = false;
            $scope.actividad = [];

            $scope.btnModificar = true;

            
            $scope.actividad.Operacion = $rootScope.asuntoModal.Operacion;

            $scope.stakeholdersActividad = [];



            //Obtener comunas segun la zona del asunto
            $rootScope.obtenerComunasUsuario($rootScope.asuntoModal.Operacion);


            //Obtener stackeholders ---> debe ser segun la zona del asunto
            spsservice.get_type('lists/getbytitle', 'Stakeholder', "/Items?$select=*&$top=5000").then(function (rStake) {
                if (rStake.d.results.length > 0) {
                    $rootScope.stakeholdersData = rStake.d.results;
                }
            });
            // fin obtener stackeholders

            if ($rootScope.getActividad) {
                $scope.blockInputModal = false;
                spsservice.get_type('lists/getbytitle', 'Actividades', "/Items?$select=*&$filter=Id eq " + $rootScope.idActividad).then(function (rActividades) {
                    if (rActividades.d.results.length > 0) {
                        $scope.actividad = rActividades.d.results[0];
                        //Formato fecha
                        $scope.actividad.FechaActividad = new Date($scope.actividad.FechaActividad);
                        $scope.obtenerActividadesStakeholders();


                    }
                });
            }


            $scope.obtenerActividadesStakeholders = function () {
                spsservice.get_type('lists/getbytitle', 'ActividadesStakeholders', "/Items?$select=ID,Stakeholder/Title,Stakeholder/Rol,Stakeholder/Tipoo,Stakeholder/Organizacion,Stakeholder/Categoria&$filter=ActividadId eq " + $rootScope.idActividad + "&$expand=Stakeholder").then(function (rStaksActividades) {
                    $scope.stakeholdersActividad = rStaksActividades.d.results;
                    
                    //custom names stakeholders
                    for (let i = 0; i < $scope.stakeholdersActividad.length; i++) {
                        $scope.stakeholdersActividad[i].Nombre = $scope.stakeholdersActividad[i].Stakeholder.Title;
                        $scope.stakeholdersActividad[i].Rol = $scope.stakeholdersActividad[i].Stakeholder.Rol;
                        $scope.stakeholdersActividad[i].Tipo = $scope.stakeholdersActividad[i].Stakeholder.Tipoo;
                        $scope.stakeholdersActividad[i].Organizacion = $scope.stakeholdersActividad[i].Tipo == "Funcionario Publico" ? $scope.stakeholdersActividad[i].Stakeholder.Organizacion : $scope.stakeholdersActividad[i].Stakeholder.Categoria;
                    }

                    //actualizar array stakeholder
                    let _stakeholders = [];
                    var url = "lists/getbytitle('Actividades')/items(" + $rootScope.idActividad + ")";
                    var data = {
                        '__metadata': {
                            'type': 'SP.Data.ActividadesListItem'
                        },
                        'StakeholdersArray': JSON.stringify($scope.stakeholdersActividad)
                    };
                   
                    spsservice.put_data(url, data).then(function () {});
                });
            }


            $scope.AgregarStakeholderActividad = function (idStakeholder, nombre, rol, tipoo, organizacion, categoria) {

                $scope.stakeholdersActividad.push({
                    "StakeholderId": idStakeholder,
                    "Nombre": nombre,
                    "Rol": rol,
                    "Tipo": tipoo,
                    "Organizacion": tipoo == "Funcionario Publico" ? organizacion : categoria
                });
                $scope.person.selected = null;
            }

            $scope.AgregarStakeholderActividadDirecto = function (StakeholderID) {
                var url = "lists/getbytitle('ActividadesStakeholders')/items";
                var data = {
                    '__metadata': {
                        'type': 'SP.Data.ActividadesStakeholdersListItem'
                    },
                    'ActividadId': $rootScope.idActividad,
                    'StakeholderId': StakeholderID,

                };
                spsservice.post_data(url, data).then(function () {
                    $scope.obtenerActividadesStakeholders();
                    $scope.person.selected = null;
                    SweetAlert.swal("Stakeholder agregado", "", "success");

                });
            }



            $scope.grabarActividad = function () {

                $rootScope.bloqueopantalla = true;
                $rootScope.refreshToken();

                SweetAlert.swal({
                        title: "¿Está seguro(a) de crear la Actividad?",
                        text: "No debe actualizar la página hasta que el proceso haya finalizado.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#16AB39",
                        confirmButtonText: "Si, agregar Actividad!",
                        cancelButtonText: "Cancelar",
                        closeOnConfirm: true
                    },
                    function (isConfirm) {
                        if (isConfirm) {

                            var url = "lists/getbytitle('Actividades')/items";
                            var data = {
                                '__metadata': {
                                    'type': 'SP.Data.ActividadesListItem'
                                },
                                'Title': $scope.actividad.Title,
                                'FechaActividad': $scope.actividad.FechaActividad,
                                'Descripcion': $scope.actividad.Descripcion,
                                'AsuntoId': $rootScope.asuntoModal.ID,
                                'Operacion': $rootScope.asuntoModal.Operacion,
                                'Comuna': $scope.actividad.Comuna,
                                'OtraComuna': $scope.actividad.OtraComuna,
                                'Participantes': $scope.actividad.Participantes,
                                'Gastado': $scope.actividad.Gastado,
                                'StakeholdersArray': JSON.stringify($scope.stakeholdersActividad)
                            };

                            
                            spsservice.post_data(url, data).then(function (rGabraActividad) {
                                if (rGabraActividad.d != null) {
                                    for (let i = 0; i < $scope.stakeholdersActividad.length; i++) {
                                        var url = "lists/getbytitle('ActividadesStakeholders')/items";
                                        var data = {
                                            '__metadata': {
                                                'type': 'SP.Data.ActividadesStakeholdersListItem'
                                            },
                                            'ActividadId': rGabraActividad.d.ID,
                                            'StakeholderId': $scope.stakeholdersActividad[i].StakeholderId,

                                        };
                                        
                                        spsservice.post_data(url, data).then(function () {});
                                    } // fin ciclo

                                    $scope.actualizarInformacionAsunto($rootScope.actividadesModal, $rootScope.asuntoModal.ID);
                                }
                            });
                        } else {
                            $rootScope.bloqueopantalla = false;
                        }
                    });
                //fin guardar nuevo                
            };

            $scope.guardar = function () {
                

                var url = "lists/getbytitle('Actividades')/items(" + $rootScope.idActividad + ")";
                var data = {
                    '__metadata': {
                        'type': 'SP.Data.ActividadesListItem'
                    },
                    'Title': $scope.actividad.Title,
                    'FechaActividad': $scope.actividad.FechaActividad,
                    'Descripcion': $scope.actividad.Descripcion,
                    'AsuntoId': $rootScope.asuntoModal.ID,
                    'Operacion': $rootScope.asuntoModal.Operacion,
                    'Comuna': $scope.actividad.Comuna,
                    'OtraComuna': $scope.actividad.OtraComuna,
                    'Participantes': $scope.actividad.Participantes,
                    'Gastado': $scope.actividad.Gastado
                };
                spsservice.put_data(url, data).then(function () {
                    $scope.actualizarInformacionAsunto($rootScope.actividadesModal, $rootScope.asuntoModal.ID);
                });
            }


            $scope.eliminarStakeholderActividad = function (actividadesStakeholdersID) {
                

                var url = "lists/getbytitle('ActividadesStakeholders')/items(" + actividadesStakeholdersID + ")";
                spsservice.delete_data(url).then(function () {
                    // $scope.obtenerComunicaciones();
                    $scope.obtenerActividadesStakeholders();
                    SweetAlert.swal("Stakeholder removido", "", "success");
                })

            }

            $scope.actualizarInformacionAsunto = function (actividades, asuntoId) {
                //actualiza valor gastado de presupuesto del asunto y total de participantes       

                if (actividades != null) {
                    let _gastado = 0;
                    let _totalParticipantes = 0;
                    for (let j = 0; j < actividades.length; j++) {

                        

                        //verificar datos para actividad actual
                        if (actividades[j].ID == $rootScope.idActividad) {
                            _gastado += $scope.actividad.Gastado;
                            _totalParticipantes += $scope.actividad.Participantes;
                        } else {
                            _gastado += actividades[j].Gastado;
                            _totalParticipantes += actividades[j].Participantes;
                        }
                    }

                    if (!$rootScope.editarActividad) {
                        _totalParticipantes += $scope.actividad.Participantes;
                        _gastado += $scope.actividad.Gastado
                    }


                    
                    spsservice.put_data(
                        "lists/getbytitle('Asuntos')/items(" + asuntoId + ")", {
                            '__metadata': {
                                'type': 'SP.Data.AsuntosListItem'
                            },
                            'Gastado': _gastado,
                            'Participantes': _totalParticipantes
                        }
                    ).then(function () {

                        SweetAlert.swal("Información guardada.", "", "success");
                        $rootScope.bloqueopantalla = false;
                        $route.reload();
                        $scope.cancel();
                    });
                } else {
                    spsservice.put_data(
                        "lists/getbytitle('Asuntos')/items(" + asuntoId + ")", {
                            '__metadata': {
                                'type': 'SP.Data.AsuntosListItem'
                            },
                            'Gastado': $scope.actividad.Gastado,
                            'Participantes': $scope.actividad.Participantes
                        }
                    ).then(function () {

                        SweetAlert.swal("Información guardada.", "", "success");
                        $rootScope.bloqueopantalla = false;
                        $route.reload();
                        $scope.cancel();
                    });
                }


            }

            $scope.cancel = function () {
                $uibModalInstance.dismiss('cancel');
            }




            $scope.disabled = undefined;
            $scope.searchEnabled = undefined;

            $scope.setInputFocus = function () {
                $scope.$broadcast('UiSelectDemo1');
            };

            $scope.enable = function () {
                $scope.disabled = false;
            };

            $scope.disable = function () {
                $scope.disabled = true;
            };

            $scope.enableSearch = function () {
                $scope.searchEnabled = true;
            };

            $scope.disableSearch = function () {
                $scope.searchEnabled = false;
            };

            $scope.clear = function () {
                $scope.person.selected = undefined;
                $scope.address.selected = undefined;
                $scope.country.selected = undefined;
            };

            $scope.someGroupFn = function (item) {

                if (item.name[0] >= 'A' && item.name[0] <= 'M')
                    return 'From A - M';

                if (item.name[0] >= 'N' && item.name[0] <= 'Z')
                    return 'From N - Z';

            };

            $scope.firstLetterGroupFn = function (item) {
                return item.name[0];
            };

            $scope.reverseOrderFilterFn = function (groups) {
                return groups.reverse();
            };

            $scope.personAsync = {
                selected: "wladimir@email.com"
            };
            $scope.peopleAsync = [];

            $timeout(function () {
                $scope.peopleAsync = [{
                        name: 'Adam',
                        email: 'adam@email.com',
                        age: 12,
                        country: 'United States'
                    },
                    {
                        name: 'Amalie',
                        email: 'amalie@email.com',
                        age: 12,
                        country: 'Argentina'
                    },
                    {
                        name: 'Estefanía',
                        email: 'estefania@email.com',
                        age: 21,
                        country: 'Argentina'
                    },
                    {
                        name: 'Adrian',
                        email: 'adrian@email.com',
                        age: 21,
                        country: 'Ecuador'
                    },
                    {
                        name: 'Wladimir',
                        email: 'wladimir@email.com',
                        age: 30,
                        country: 'Ecuador'
                    },
                    {
                        name: 'Samantha',
                        email: 'samantha@email.com',
                        age: 30,
                        country: 'United States'
                    },
                    {
                        name: 'Nicole',
                        email: 'nicole@email.com',
                        age: 43,
                        country: 'Colombia'
                    },
                    {
                        name: 'Natasha',
                        email: 'natasha@email.com',
                        age: 54,
                        country: 'Ecuador'
                    },
                    {
                        name: 'Michael',
                        email: 'michael@email.com',
                        age: 15,
                        country: 'Colombia'
                    },
                    {
                        name: 'Nicolás',
                        email: 'nicole@email.com',
                        age: 43,
                        country: 'Colombia'
                    }
                ];
            }, 3000);

            $scope.counter = 0;
            $scope.onSelectCallback = function (item, model) {
                $scope.counter++;
                $scope.eventResult = {
                    item: item,
                    model: model
                };
            };

            $scope.removed = function (item, model) {
                $scope.lastRemoved = {
                    item: item,
                    model: model
                };
            };

            $scope.tagTransform = function (newTag) {
                var item = {
                    name: newTag,
                    email: newTag.toLowerCase() + '@email.com',
                    age: 'unknown',
                    country: 'unknown'
                };

                return item;
            };

            $scope.peopleObj = {
                '1': {
                    name: 'Adam',
                    email: 'adam@email.com',
                    age: 12,
                    country: 'United States'
                },
                '2': {
                    name: 'Amalie',
                    email: 'amalie@email.com',
                    age: 12,
                    country: 'Argentina'
                },
                '3': {
                    name: 'Estefanía',
                    email: 'estefania@email.com',
                    age: 21,
                    country: 'Argentina'
                },
                '4': {
                    name: 'Adrian',
                    email: 'adrian@email.com',
                    age: 21,
                    country: 'Ecuador'
                },
                '5': {
                    name: 'Wladimir',
                    email: 'wladimir@email.com',
                    age: 30,
                    country: 'Ecuador'
                },
                '6': {
                    name: 'Samantha',
                    email: 'samantha@email.com',
                    age: 30,
                    country: 'United States'
                },
                '7': {
                    name: 'Nicole',
                    email: 'nicole@email.com',
                    age: 43,
                    country: 'Colombia'
                },
                '8': {
                    name: 'Natasha',
                    email: 'natasha@email.com',
                    age: 54,
                    country: 'Ecuador'
                },
                '9': {
                    name: 'Michael',
                    email: 'michael@email.com',
                    age: 15,
                    country: 'Colombia'
                },
                '10': {
                    name: 'Nicolás',
                    email: 'nicolas@email.com',
                    age: 43,
                    country: 'Colombia'
                }
            };

            $scope.person = {};

            $scope.person.selectedValue = $scope.peopleObj[3];
            $scope.person.selectedSingle = 'Samantha';
            $scope.person.selectedSingleKey = '5';
            // To run the demos with a preselected person object, uncomment the line below.
            //$scope.person.selected = $scope.person.selectedValue;

            //   $scope.people = [
            //     { name: 'Adam',      email: 'adam@email.com',      age: 12, country: 'United States' },
            //     { name: 'Amalie',    email: 'amalie@email.com',    age: 12, country: 'Argentina' },
            //     { name: 'Estefanía', email: 'estefania@email.com', age: 21, country: 'Argentina' },
            //     { name: 'Adrian',    email: 'adrian@email.com',    age: 21, country: 'Ecuador' },
            //     { name: 'Wladimir',  email: 'wladimir@email.com',  age: 30, country: 'Ecuador' },
            //     { name: 'Samantha',  email: 'samantha@email.com',  age: 30, country: 'United States' },
            //     { name: 'Nicole',    email: 'nicole@email.com',    age: 43, country: 'Colombia' },
            //     { name: 'Natasha',   email: 'natasha@email.com',   age: 54, country: 'Ecuador' },
            //     { name: 'Michael',   email: 'michael@email.com',   age: 15, country: 'Colombia' },
            //     { name: 'Nicolás',   email: 'nicolas@email.com',    age: 43, country: 'Colombia' }
            //   ];

            $scope.people = $rootScope.stakeholdersData;


            $scope.availableColors = ['Red', 'Green', 'Blue', 'Yellow', 'Magenta', 'Maroon', 'Umbra', 'Turquoise'];

            $scope.singleDemo = {};
            $scope.singleDemo.color = '';
            $scope.multipleDemo = {};
            // $scope.multipleDemo.colors = ['Blue', 'Red'];
            // $scope.multipleDemo.colors2 = ['Blue', 'Red'];
            // $scope.multipleDemo.selectedPeople = [$scope.people[5], $scope.people[4]];
            // $scope.multipleDemo.selectedPeople2 = $scope.multipleDemo.selectedPeople;
            // $scope.multipleDemo.selectedPeopleWithGroupBy = [$scope.people[8], $scope.people[6]];
            // $scope.multipleDemo.selectedPeopleSimple = ['samantha@email.com', 'wladimir@email.com'];
            // $scope.multipleDemo.removeSelectIsFalse = [$scope.people[2], $scope.people[0]];

            $scope.appendToBodyDemo = {
                remainingToggleTime: 0,
                present: true,
                startToggleTimer: function () {
                    var scope = $scope.appendToBodyDemo;
                    var promise = $interval(function () {
                        if (scope.remainingTime < 1000) {
                            $interval.cancel(promise);
                            scope.present = !scope.present;
                            scope.remainingTime = 0;
                        } else {
                            scope.remainingTime -= 1000;
                        }
                    }, 1000);
                    scope.remainingTime = 3000;
                }
            };

            $scope.address = {};
            $scope.refreshAddresses = function (address) {
                var params = {
                    address: address,
                    sensor: false
                };
                return $http.get(
                    'http://maps.googleapis.com/maps/api/geocode/json', {
                        params: params
                    }
                ).then(function (response) {
                    $scope.addresses = response.data.results;
                });
            };

            $scope.addPerson = function (item, model) {
                if (item.hasOwnProperty('isTag')) {
                    delete item.isTag;
                    $scope.people.push(item);
                }
            }








        })

        .controller('modalAgregarAdjuntoActividadController', function ($scope, $uibModalInstance, $route, $http, $rootScope, SweetAlert, spsservice, $uibModal, $location, $window, $timeout, $interval) {

            //funcion buffer
            var getFileBuffer = function (file) {
                var deferred = $.Deferred();
                var reader = new FileReader();
                reader.onload = function (e) {
                    deferred.resolve(e.target.result);
                }
                reader.onerror = function (e) {
                    deferred.reject(e.target.error);
                }
                reader.readAsArrayBuffer(file);
                return deferred.promise();
            }

            $scope.cerrarModal = function () {
                $uibModalInstance.dismiss('cancel');
            }

            //Se agrega adjunto al elemento de Actividad
            $scope.agregarAdjunto = function () {

                $rootScope.refreshToken();
                $scope.botonAdjunto = 'Adjuntando ...';
                $scope.subiendoAdjunto = true;
                var file = document.getElementById('adjunto').files[0];
                if (file) {
                    getFileBuffer(file).then(function (buffer) {
                        var url = "lists/getbytitle('Actividades')/items(" + $rootScope.idActividad + ")/AttachmentFiles/add(FileName='" + file.name + "')";
                        spsservice.attach_data(url, buffer).then(function () {
                            $uibModalInstance.dismiss('cancel');
                            $route.reload();
                        });
                    });
                } else {
                    $scope.botonAdjunto = 'Adjuntar';
                    $scope.subiendoAdjunto = false;
                    alert("Debe agregar un archivo para adjuntar.")
                }
            }
        })


}(angular.module('spsmodule')));