(function (app) {
    app
        .controller('CrearReunionesController', function ($scope, $http, $rootScope, SweetAlert, spsservice, $uibModal, $location) {

          

            $rootScope.reunion = [];
            $scope.noMostrar = true;

            $scope.crearReunion = function () {
                $rootScope.refreshToken();

                var url = "lists/getbytitle('Reuniones')/items";
                var data = {
                    '__metadata': {
                        'type': 'SP.Data.ReunionesListItem'
                    },
                    'Title': $rootScope.reunion.Title,
                    'fecha_x0020_reunion': $rootScope.reunion.fecha_x0020_reunion,
                    'lugar': $rootScope.reunion.lugar,
                    'EstadoReunion': "Borrador",
                    'GestionadaLeyLobby': $rootScope.reunion.GestionadaLeyLobby
                };

                var grabarReunion = spsservice.post_data(url, data);
                grabarReunion.then(function (rBorradorReunionPost) {
                    if (rBorradorReunionPost.d != null) {
                        debugger;
                        $rootScope.reunion = rBorradorReunionPost.d
                        SweetAlert.swal("Reunión creada.", "", "success");
                        $scope.noMostrar = false;
                    }
                });
            }

            //Agregar tema
            $scope.agregarTemas = function () {
                $rootScope.refreshToken();
                SweetAlert.swal({
                        title: "¿Está seguro de agregar el tema?",
                        text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#16AB39",
                        confirmButtonText: "Si, agregar tema!",
                        cancelButtonText: "Salir",
                        closeOnConfirm: true
                    },
                    function (isConfirm) {
                        if (isConfirm) {
                            var url = "lists/getbytitle('Temas')/items";
                            var data = {
                                '__metadata': {
                                    'type': 'SP.Data.TemasListItem'
                                },
                                'tema': $scope.temaAgregado,
                                'observacion': $scope.observacion,
                                'reunionId': $rootScope.reunion.Id
                            };

                            var grabarTemas = spsservice.post_data(url, data);
                            grabarTemas.then(function (rTemaRespuesta) {
                                if (rTemaRespuesta.d != null) {

                                    SweetAlert.swal("Tema agregado", "", "success");
                                    var getList = spsservice.get_type('lists/getbytitle', 'Temas', "/Items?$select=ID,tema,observacion&$filter=reunionId eq " + $rootScope.reunion.Id);
                                    getList.then(function (resp_sup) {
                                        if (resp_sup.d.results.length > 0) {

                                            $scope.temasReunion = resp_sup.d.results;
                                        }
                                    });
                                    $scope.temaAgregado = ""
                                    $scope.observacion = ""
                                }
                            });
                        }
                    });




            }

            //Agregar asistente
            $scope.agregarAsistentes = function () {
                $rootScope.refreshToken();

                SweetAlert.swal({
                        title: "¿Está seguro de agregar el asistente?",
                        text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#16AB39",
                        confirmButtonText: "Si, agregar asistente!",
                        cancelButtonText: "Salir",
                        closeOnConfirm: true
                    },
                    function (isConfirm) {
                        if (isConfirm) {
                            var url = "lists/getbytitle('Asistentes')/items";
                            var data = {
                                '__metadata': {
                                    'type': 'SP.Data.AsistentesListItem'
                                },
                                'nombre': $scope.nombreAsistente,
                                'cargo': $scope.cargoAsistente,
                                'gerencia': $scope.gerenciaAsistente,
                                'reunionesId': $rootScope.reunion.Id,
                                'TipoAsistente': "Asistente"
                            };
                            var grabarAsistentes = spsservice.post_data(url, data);
                            grabarAsistentes.then(function (rGrabarAsistentes) {
                                if (rGrabarAsistentes.d != null) {
                                    SweetAlert.swal("Asistente agregado", "", "success");

                                    var getList = spsservice.get_type('lists/getbytitle', 'Asistentes', "/Items?$select=ID,nombre,cargo,gerencia,TipoAsistente&$filter=reunionesId eq " + $rootScope.reunion.Id + " and TipoAsistente eq 'Asistente'");
                                    getList.then(function (resp_sup) {
                                        if (resp_sup.d.results.length > 0) {
                                            $scope.asistentes = resp_sup.d.results;
                                        }
                                    });
                                    $scope.nombreAsistente = ""
                                    $scope.cargoAsistente = ""
                                    $scope.gerenciaAsistente = ""
                                }
                            })
                        }
                    });



            }


            //Agregar fucnionario público
            $scope.agregarFfpp = function () {
                $rootScope.refreshToken();
                SweetAlert.swal({
                    title: "¿Está seguro de agregar el funcionario?",
                    text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#16AB39",
                    confirmButtonText: "Si, de agregar el funcionario!",
                    cancelButtonText: "Salir",
                    closeOnConfirm: true
                },
                function (isConfirm) {
                    if (isConfirm) {
                        debugger;

                        var url = "lists/getbytitle('Asistentes')/items";
                        var data = {
                            '__metadata': {
                                'type': 'SP.Data.AsistentesListItem'
                            },
                            'nombre': $scope.nombreffpp,
                            'cargo': $scope.cargoffpp,
                            'ffpp': $scope.ffpp,
                            'reunionesId': $rootScope.reunion.Id,
                            'TipoAsistente': "Funcionario"
                        };
                        var grabarFfpp = spsservice.post_data(url, data);
                        grabarFfpp.then(function (rGrabarFfpp) {
                            if (rGrabarFfpp.d != null) {
                                SweetAlert.swal("Funcionario agregado", "", "success");

                                var getList = spsservice.get_type('lists/getbytitle', 'Asistentes', "/Items?$select=ID,nombre,cargo,ffpp,TipoAsistente&$filter=reunionesId eq " + $rootScope.reunion.Id + " and TipoAsistente eq 'Funcionario'");
                                getList.then(function (resp_sup) {
                                    if (resp_sup.d.results.length > 0) {
                                        $scope.funcionarios = resp_sup.d.results;
                                    }
                                });
                                $scope.nombreffpp = ""
                                $scope.cargoffpp = ""
                                $scope.ffpp = ""
                            }
                        })
                    }
                });
            }

            $scope.confirmarReunion = function () {
                $rootScope.refreshToken();
                SweetAlert.swal({
                        title: "¿Está seguro de confirmar la reunión?",
                        text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#16AB39",
                        confirmButtonText: "Si, confirmar la reunión!",
                        cancelButtonText: "Salir",
                        closeOnConfirm: true
                    },
                    function (isConfirm) {
                        if (isConfirm) {

                            var url = "lists/getbytitle('Reuniones')/items(" + $rootScope.reunion.Id + ")";
                            var data = {
                                '__metadata': {
                                    'type': 'SP.Data.ReunionesListItem'
                                },
                                'EstadoReunion': 'Confirmada'
                            };
                            var cambiarConfirmarReunionPut = spsservice.put_data(url, data);
                            cambiarConfirmarReunionPut.then(function (rCambiarConfirmarReunionPut) {

                                var getList = spsservice.get_type('lists/getbytitle', 'Reuniones', "/Items?$select=Id,GestionadaLeyLobby,Title,lugar,fecha_x0020_reunion,EstadoReunion&$filter=Id eq " + $rootScope.reunion.Id);
                                getList.then(function (resp_sup) {
                                    if (resp_sup.d.results.length > 0) {
                                        $rootScope.reunion = resp_sup.d.results[0];

                                    }

                                });

                                SweetAlert.swal("Reunión confirmada", "", "success");
                            })
                        }
                    });

            }

            $scope.eliminarReunion = function () {
                $rootScope.refreshToken();
                SweetAlert.swal({
                        title: "¿Está seguro de eliminar el borrador?",
                        text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#16AB39",
                        confirmButtonText: "Si, eliminar el borrador!",
                        cancelButtonText: "Salir",
                        closeOnConfirm: true
                    },
                    function (isConfirm) {
                        if (isConfirm) {

                            var url = "lists/getbytitle('Reuniones')/items(" + id + ")";
                            var data = {
                                '__metadata': {
                                    'type': 'SP.Data.ReunionesListItem'
                                },

                            };
                            var eliminarReunionBorrador = spsservice.delete_data(url, data);
                            eliminarReunionBorrador.then(function (rEliminarReunionBorrador) {


                                $location.path('/');
                                SweetAlert.swal("Borrador eliminado", "", "success");


                            })
                        }
                    });

            }

            $scope.modificarReunion = function () {
                $rootScope.refreshToken();
                var url = "lists/getbytitle('Reuniones')/items(" + $rootScope.reunion.Id + ")";
                var data = {
                    '__metadata': {
                        'type': 'SP.Data.ReunionesListItem'
                    },
                    'Title': $rootScope.reunion.Title,
                    'fecha_x0020_reunion': $rootScope.reunion.fecha_x0020_reunion,
                    'lugar': $rootScope.reunion.lugar,
                    'GestionadaLeyLobby': $rootScope.reunion.GestionadaLeyLobby
                };
                var modificarReunion = spsservice.put_data(url, data);
                modificarReunion.then(function (rModificarReunion) {
                    SweetAlert.swal("Reunión modificada", "", "success");
                });
            }
            $scope.eliminarTemas = function (ID) {
                $rootScope.refreshToken();
                SweetAlert.swal({
                        title: "¿Está seguro de eliminar el tema?",
                        text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#16AB39",
                        confirmButtonText: "Si, eliminar el tema!",
                        cancelButtonText: "Salir",
                        closeOnConfirm: true
                    },
                    function (isConfirm) {
                        if (isConfirm) {

                            var url = "lists/getbytitle('Temas')/items(" + ID + ")";
                            var eliminaTema = spsservice.delete_data(url);
                            eliminaTema.then(function (rEliminaTema) {
                                var getList = spsservice.get_type('lists/getbytitle', 'Temas', "/Items?$select=Id,tema,observacion&$filter=reunionId eq " + $rootScope.reunion.Id);
                                getList.then(function (resp_sup) {
                                    $scope.temasReunion = resp_sup.d.results;
                                });
                                SweetAlert.swal("Tema eliminado", "", "success");
                            })
                        }
                    });
            }

            $scope.eliminarAsistentes = function (ID) {
                $rootScope.refreshToken();
                SweetAlert.swal({
                        title: "¿Está seguro de eliminar el asistente?",
                        text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#16AB39",
                        confirmButtonText: "Si, eliminar el asistente!",
                        cancelButtonText: "Salir",
                        closeOnConfirm: true
                    },
                    function (isConfirm) {
                        if (isConfirm) {
                            debugger;
                            var url = "lists/getbytitle('Asistentes')/items(" + ID + ")";
                            var eliminaAsistente = spsservice.delete_data(url);
                            eliminaAsistente.then(function (rEliminaAsistente) {
                                var getList = spsservice.get_type('lists/getbytitle', 'Asistentes', "/Items?$select=TipoAsistente,Id,nombre,cargo,gerencia,ffpp&$filter=reunionesId eq " + $rootScope.reunion.Id);
                                getList.then(function (resp_sup) {
                                    $scope.asistentes_ = resp_sup.d.results;
                                    // $rootScope.parametros = resp.d.results;
                                    $scope.asistentes = $scope.asistentes_.filter(x => x.TipoAsistente == 'Asistente');
                                    $scope.funcionarios = $scope.asistentes_.filter(x => x.TipoAsistente == 'Funcionario');

                                });
                                SweetAlert.swal("Asistente eliminado", "", "success");
                            })
                        }
                    });
            }

            $scope.eliminarFuncionarios = function (ID) {
                $rootScope.refreshToken();
                SweetAlert.swal({
                        title: "¿Está seguro de eliminar el funcionario?",
                        text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#16AB39",
                        confirmButtonText: "Si, eliminar el funcionario!",
                        cancelButtonText: "Salir",
                        closeOnConfirm: true
                    },
                    function (isConfirm) {
                        if (isConfirm) {
                            debugger;
                            var url = "lists/getbytitle('Asistentes')/items(" + ID + ")";
                            var eliminaFuncionario = spsservice.delete_data(url);
                            eliminaFuncionario.then(function (rEliminaFuncionario) {
                                var getList = spsservice.get_type('lists/getbytitle', 'Asistentes', "/Items?$select=TipoAsistente,Id,nombre,cargo,gerencia,ffpp&$filter=reunionesId eq " + $rootScope.reunion.Id);
                                getList.then(function (resp_sup) {
                                    $scope.asistentes_ = resp_sup.d.results;
                                    // $rootScope.parametros = resp.d.results;
                                    $scope.asistentes = $scope.asistentes_.filter(x => x.TipoAsistente == 'Asistente');
                                    $scope.funcionarios = $scope.asistentes_.filter(x => x.TipoAsistente == 'Funcionario');

                                });
                                SweetAlert.swal("Funcionario eliminado", "", "success");
                            })
                        }
                    });
            }

        });

}(angular.module('spsmodule')));