(function (app) {
    app
        .controller('CrearAsuntoController', function ($scope, $http, $rootScope, SweetAlert, spsservice, $uibModal, $location, $window, $route) {
            $scope.bloqueo = false;

            $rootScope.bloqueopantalla = false;

            $rootScope.menuActivo();
            
            
            //Inicializar variable para asignar zona por defecto al tener solo 1
            $scope.asunto = new Object();
            if ($rootScope.zonasUsuario.length == 1) {
                $scope.asunto.Operacion = $rootScope.zonasUsuario[0].zona;
            }

            $scope.obtenerProgramas = function (ambito) {
                $rootScope.programas = $rootScope.parametros.filter(x => x.Title == 'Programa' && x.RelacionadoId == ambito.ID);
            }

            $scope.crearAsunto = function () {
                $rootScope.bloqueopantalla = true;
                $rootScope.refreshToken();

                SweetAlert.swal({
                        title: "¿Está seguro(a) de crear el Asunto?",
                        text: "No debe actualizar la página hasta que el proceso haya finalizado.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#16AB39",
                        confirmButtonText: "Si, agregar Asunto!",
                        cancelButtonText: "Cancelar",
                        closeOnConfirm: true
                    },
                    function (isConfirm) {
                        if (isConfirm) {
                            var url = "lists/getbytitle('Asuntos')/items";
                            var data = {
                                '__metadata': {
                                    'type': 'SP.Data.AsuntosListItem'
                                },
                                'Title': $scope.asunto.Title, //nombre
                                'FechaReunion': $scope.asunto.FechaReunion,
                                'Operacion': $scope.asunto.Operacion,
                                'Ambito': $scope.asunto.Ambito.Valor,
                                'Programa': $scope.asunto.Programa.Valor,
                                //'Comuna': $scope.asunto.Comuna.Comuna == 'Otra' ? $scope.asunto.ComunaOtra : $scope.asunto.Comuna.Comuna,
                                'Ubicacion': $scope.asunto.Ubicacion,
                                'Estado': "Creado",
                                'Presupuesto': $scope.asunto.Presupuesto,

                                'Comuna': $scope.asunto.Comuna.Comuna,
                                'OtraComuna': $scope.asunto.OtraComuna,


                            };
                            var crearAsunto = spsservice.post_data(url, data);
                            crearAsunto.then(function (rCrearAsunto) {
                                if (rCrearAsunto.d != null) {
                                    $location.path('/Asunto/' + rCrearAsunto.d.ID)
                                    SweetAlert.swal("Asunto creado.", "", "success");   
                                    $rootScope.bloqueopantalla = false;                                 
                                    $scope.bloqueo = true;
                                }
                            });
                        }
                        else{
                            $rootScope.bloqueopantalla = false;
                        }

                    });
            }
        })





}(angular.module('spsmodule')));