(function () {

    angular.module('spsmodule', [ 'ui.bootstrap', 'ngFileUpload' , 'ngRoute', 'ngSanitize', 'oitozero.ngSweetAlert','ngCsv', 'angular-js-xlsx'])
 
    .config(["$routeProvider", function ($routeProvider) {
        
        $routeProvider.when("/", {
            templateUrl: "../SitePages/pages/Home.html",
            controller: "homeController"
        })
        .when("/Administracion", {
            templateUrl: "../SitePages/pages/Administracion.html",
            controller: "administracionController"
        })
        .when("/CrearObjetivo", {
            templateUrl: "../SitePages/pages/CrearObjetivo.html",
            controller: "crearObjetivoController"
        })
        .when("/Evaluaciones", {
            templateUrl: "../SitePages/pages/Evaluaciones.html",
            controller: "evaluacionesController"
        })
        .when("/Objetivos", {
            templateUrl: "../SitePages/pages/Objetivos.html",
            controller: "objetivosController"
        })
        .when("/Objetivos/:refresh", {
            templateUrl: "../SitePages/pages/Objetivos.html",
            controller: "objetivosController"
        })

        .when("/Competencias", {
            templateUrl: "../SitePages/pages/Competencias.html",
            controller: "competenciasController"
        })
        .when("/Competencias/:refresh", {
            templateUrl: "../SitePages/pages/Competencias.html",
            controller: "competenciasController"
        })

        .when("/Competencia/:anio/:id", {
            templateUrl: "../SitePages/pages/detalleCompetencias.html",
            controller: "detalleCompetencia",
            // resolve: {
            //     id: function ($route) {
            //         return $route.current.params.id;
            //     }
            // }
        })
        .when("/TotalGDI", {
            templateUrl: "../SitePages/pages/Gdi.html",
            controller: "gdiController"
        })
        .when("/TotalGDI/:refresh", {
            templateUrl: "../SitePages/pages/Gdi.html",
            controller: "gdiController"
        })

        .when("/TotalGDI/:anio/:id", {
            templateUrl: "../SitePages/pages/detalleGDI.html",
            controller: "detalleGDI",
            // resolve: {
            //     id: function ($route) {
            //         return $route.current.params.id;
            //     }
            // }
        })
        .when("/Dashboard", {
            templateUrl: "../SitePages/pages/Dashboard.html",
            controller: "dashboardController"
        })
        .when("/Objetivos/:anio/:id", {
            templateUrl: "../SitePages/pages/detalleObjetivo.html",
            controller: "detalleObjetivo",
            // resolve: {
            //     id: function ($route) {
            //         return $route.current.params.id
            //     }
            //     ,
            //     anio: function ($route) {
            //         return $route.current.params.anio
            //     }
            
            // }
        })
    }])

    .directive('preventEnterSubmit', function () {
        return function (scope, el, attrs) {
          el.bind('keydown', function (event) {
            if (13 == event.which) {
                event.preventDefault(); // Doesn't work at all
                window.stop(); // Works in all browsers but IE...
                document.execCommand('Stop'); // Works in IE
                return false; // Don't even know why it's here. Does nothing.
            }
          });
        };
    })
    
    .directive('yrInteger', function () {
        return {
            restrict: 'A',
            link: function(scope, element, attrs) {
            
              element.on('keypress', function(event) {

                debugger;
        
                if ( !isIntegerChar() ) 
                  event.preventDefault();
                
                function isIntegerChar() {
                  return /[0-9.,]|-/.test(
                    String.fromCharCode(event.which))
                }
        
              })       
            
            }
        }
    });

})();