(function (app) {
    app
        .controller('homeController', function ($scope, $rootScope, spsservice, $route, SweetAlert) {
            $rootScope.menuActivo();


            $scope.eliminarLista = function (lista, anioLista) {
                $rootScope.anioLista = anioLista

                SweetAlert.swal({
                        title: "¿Está seguro(a) de eliminar la lista?",
                        text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#16AB39",
                        confirmButtonText: "Si, eliminar!",
                        cancelButtonText: "Salir",
                        closeOnConfirm: true
                    },
                    function (isConfirm) {

                        if (isConfirm) {
                            spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/Web/Lists?select=Id&$filter=title eq '" + lista + +$rootScope.anioLista + "'").then(function (checkLista) {
                                if (checkLista.d.results.length == 0) {
                                    alert("Ops..." + lista + +$rootScope.anioLista + " no existe")
                                } else {
                                    
                                    $rootScope.bloqueopantalla = true;
                                    spsservice.delete_list(_spPageContextInfo.webAbsoluteUrl + "/_api/Web/Lists(guid'" + checkLista.d.results[0].Id + "')").then(function () {



                                        spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('Dashboard')/Items?$select=ID&$filter=Ano eq " + $rootScope.anioLista).then(function (resp_sup) {
                                            if (resp_sup.d.results.length > 0) {
                                                switch (lista) {
                                                    case "o":
                                                        var data = {
                                                            '__metadata': {
                                                                'type': "SP.Data.DashboardListItem"
                                                            },
                                                            'N_total_Negocio': null,
                                                            'Promedio_Negocio': null,
                                                            'Min_Negocio': null,
                                                            'Mediana_Negocio': null,
                                                            'Max_Negocio': null,
                                                            'N_total_Persona': null,
                                                            'Promedio_Persona': null,
                                                            'Min_Persona': null,
                                                            'Mediana_Persona': null,
                                                            'Max_Persona': null
                                                        };
                                                        spsservice.put_data("lists/getbytitle('Dashboard')/items(" + resp_sup.d.results[0].ID + ")", data);
                                                        
                                                        $scope.confirmaLista();

                                                        break;

                                                    case "c":
                                                        var data = {
                                                            '__metadata': {
                                                                'type': "SP.Data.DashboardListItem"
                                                            },
                                                            'N_total_Competencia': null,
                                                            'Promedio_Competencia': null,
                                                            'Min_Competencia': null,
                                                            'Mediana_Competencia': null,
                                                            'Max_Competencia': null
                                                        };
                                                        spsservice.put_data("lists/getbytitle('Dashboard')/items(" + resp_sup.d.results[0].ID + ")", data);
                                                        $scope.confirmaLista();

                                                        break;

                                                    case "t":
                                                        var data = {
                                                            '__metadata': {
                                                                'type': "SP.Data.DashboardListItem"
                                                            },
                                                            'N_total_GDI': null,
                                                            'Promedio_GDI': null,
                                                            'Min_GDI': null,
                                                            'Mediana_GDI': null,
                                                            'Max_GDI': null
                                                        };
                                                        spsservice.put_data("lists/getbytitle('Dashboard')/items(" + resp_sup.d.results[0].ID + ")", data);
                                                        $rootScope.bloqueopantalla = false;
                                                        $scope.obtenerData();
                                                        SweetAlert.swal("Lista Eliminada!.", "", "success");

                                                        break;
                                                }
                                            }
                                        });

                                    });
                                }
                            })
                        }
                    })
            }



            $scope.confirmaLista = function () {
                spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/web/Lists?select=*,Fields/Title&$filter=title eq 't" + $rootScope.anioLista + "'&$expand=Fields ").then(function (resp_sup) {
                    if (resp_sup.d.results.length > 0) {

                        $scope.resultadoLista = resp_sup.d.results[0].Fields.results;
                        for (let i = 0; i < $scope.resultadoLista.length; i++) {
                            if ($scope.resultadoLista[i].EntityPropertyName == "TotalGDI") {

                                $scope.getGDIForNull();
                                break;
                            }

                            if (i == ($scope.resultadoLista.length - 1)) {
                                $rootScope.bloqueopantalla = false;
                                $scope.obtenerData();
                                SweetAlert.swal("Lista Eliminada!.", "", "success");
                            }
                        }

                    }
                })
            };

            $scope.getGDIForNull = function () {
                $rootScope.datatableGDI = []
                $scope.columnsGetGDI = "ID,TotalGDI,TotalObjNegocios,TotalObjPersonas,TotalCompetencias,SumaObjetivos";
                $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('t" + $rootScope.anioLista + "')/Items?$select=" + $scope.columnsGetGDI + "&$top=5000";
                $rootScope.getDataGDIForNull($scope.urlGetBase);

            }


            $rootScope.nullGDI = function () {


                $scope.arrayGDINull = [];

                for (let i = 0; i < $rootScope.gdiNull.length; i++) {

                    var data = {

                        '__metadata': {

                            'type': "SP.Data.T" + $rootScope.anioLista + "ListItem"

                        },

                        'TotalGDI': null,
                        'TotalObjNegocios': null,
                        'TotalObjPersonas': null,
                        'TotalCompetencias': null,
                        'SumaObjetivos': null,
                    };


                    $scope.arrayGDINull.push({
                        "endpoint": "lists/getbytitle('t" + $rootScope.anioLista + "')/items(" + $scope.gdiNull[i].ID + ")",
                        "data": data
                    })

                }


                $scope.actualizaNull(0, 100);


            }

            $scope.actualizaNull = function (indice, termino) {


                let batchExecutor = new RestBatchExecutor(_spPageContextInfo.webAbsoluteUrl);
                var commands = [];
                for (indice; indice < termino; indice++) {
                    var batchRequest;
                    batchRequest = new BatchRequest();
                    batchRequest.verb = "MERGE";
                    batchRequest.headers = {
                        'If-Match': "*"
                    };

                    batchRequest.endpoint = _spPageContextInfo.webAbsoluteUrl + "/_api/web/" + $scope.arrayGDINull[indice].endpoint;
                    batchRequest.payload = $scope.arrayGDINull[indice].data;

                    commands.push({
                        indice: batchExecutor.loadChangeRequest(batchRequest)
                    });
                }

                console.log(new Date().toLocaleString() + " NULL actualiza Command pushed: End ID " + indice);

                batchExecutor.executeAsync().done(function (result) {

                    console.log(new Date().toLocaleString() + " Termino batch: " + new Date().toISOString());
                    let _termino = indice + $rootScope.intervalBatch;
                    if ($scope.arrayGDINull.length < _termino) {
                        _termino = $scope.arrayGDINull.length;
                    }
                    //verificar termino recursividad
                    if ($scope.arrayGDINull.length == indice) {
                        console.log("termino el proceso $batch");
                        $rootScope.bloqueopantalla = false;
                        $scope.obtenerData();
                        SweetAlert.swal("Lista Eliminada!.", "", "success");

                    } else {
                        $scope.actualizaNull(indice, _termino);
                    }
                }).fail(function (err) {
                    console.log("ERROR EN BATCH EXECUTOR: " + new Date().toISOString());
                });
            }



            $scope.obtenerData = function () {

                //Obtener listas creadas            
                spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/Web/Lists?$select=Author/Title,Title,Id,ItemCount,LastItemUserModifiedDate&$expand=Author").then(function (checkLista) {
                    $scope._dataLoad = [];


                    for (let i = 0; i < $rootScope.anioCarga.length; i++) {
                        let _anio = $rootScope.anioCarga[i].anio;
                        for (let index = 0; index < checkLista.d.results.length; index++) {

                            if (checkLista.d.results[index].Title == "o" + _anio) {
                                $scope._dataLoad.push({
                                    'anio': _anio,
                                    'lista': 'objetivos',
                                    'estado': true,
                                    'items': checkLista.d.results[index].ItemCount,
                                    'mod': checkLista.d.results[index].Author.Title,
                                    'fechamod': checkLista.d.results[index].LastItemUserModifiedDate
                                });
                            }
                            if (checkLista.d.results[index].Title == "c" + _anio) {
                                $scope._dataLoad.push({
                                    'anio': _anio,
                                    'lista': 'competencias',
                                    'estado': true,
                                    'items': checkLista.d.results[index].ItemCount,
                                    'mod': checkLista.d.results[index].Author.Title,
                                    'fechamod': checkLista.d.results[index].LastItemUserModifiedDate
                                });
                            }
                            if (checkLista.d.results[index].Title == "t" + _anio) {
                                $scope._dataLoad.push({
                                    'anio': _anio,
                                    'lista': 'totalgdi',
                                    'estado': true,
                                    'items': checkLista.d.results[index].ItemCount,
                                    'mod': checkLista.d.results[index].Author.Title,
                                    'fechamod': checkLista.d.results[index].LastItemUserModifiedDate
                                });
                            }
                        }
                    }

                    var groupedData = $scope._dataLoad.reduce(function (result, current) {
                        if (typeof current['anio'] === 'undefined')
                            current['anio'] = "All";

                        result[current['anio']] = result[current['anio']] || [];


                        if (current['lista'] == "objetivos") {
                            result[current['anio']]["objetivos"] = [];
                            result[current['anio']]['objetivos'].push({
                                'estado': current['estado'],
                                'items': current['items'],
                                'mod': current['mod'],
                                'fechamod': current['fechamod']
                            });
                        }
                        if (current['lista'] == "competencias") {
                            result[current['anio']]["competencias"] = [];
                            result[current['anio']]['competencias'].push({
                                'estado': current['estado'],
                                'items': current['items'],
                                'mod': current['mod'],
                                'fechamod': current['fechamod']
                            });
                        }
                        if (current['lista'] == "totalgdi") {
                            result[current['anio']]["totalgdi"] = [];
                            result[current['anio']]['totalgdi'].push({
                                'estado': current['estado'],
                                'items': current['items'],
                                'mod': current['mod'],
                                'fechamod': current['fechamod']
                            });
                        }

                        return result;
                    }, {});

                    //data agrupada por año                  
                    $scope._dataLoad = groupedData;

                })
                //end obtener data

            }

            //init
            $scope.obtenerData();


            $scope.calculos = function (anioCalc) {
                ;

                $rootScope.arrayCampos = [{
                        "nombreCampo": "TotalGDI",
                        "estado": false
                    },
                    {
                        "nombreCampo": "TotalObjNegocios",
                        "estado": false
                    },
                    {
                        "nombreCampo": "TotalObjPersonas",
                        "estado": false
                    },
                    {
                        "nombreCampo": "TotalCompetencias",
                        "estado": false
                    },
                    {
                        "nombreCampo": "SumaObjetivos",
                        "estado": false
                    }
                ]

                $rootScope.bloqueopantalla = true;
                // $rootScope.obteniendoDatos = true;

                $rootScope.anioCalculo = parseInt(anioCalc);


                $rootScope.datatableObjetivos = []
                $rootScope.datatableCompetencias = []
                $rootScope.datatableGDI = []

                $rootScope.objetivosCalculoTerminado = false;
                $rootScope.competenciasCalculoTerminado = false;
                $rootScope.gdiCalculoTerminado = false;


                $scope.columnsGetObjetivos = "ID,ID_x0020_de_x0020_objetivo,ID_x0020_de_x0020_usuario_x0020_,Supervisor_x0020_Nombre,Supervisor_x0020_Apellidos,Estado,Evaluado_x0020_Nombre,Evaluado_x0020_Apellidos,Categor_x00ed_a_x0020_de_x0020_o,Nombre_x0020_de_x0020_objetivo,Ponderaci_x00f3_n_x0020_de_x0020,Meta,Cumplimiento,OData__x0025__x0020_Final_x0020_de_x00,Indicador,Real,Tipo_x0020_de_x0020_C_x00e1_lcul";
                $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('o" + $rootScope.anioCalculo + "')/Items?$select=" + $scope.columnsGetObjetivos + "&$top=5000";
                $rootScope.getDataObjetivos($scope.urlGetBase)


                //llamado lista
                spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/web/Lists?select=*,Fields/Title&$filter=title eq 't" + $rootScope.anioCalculo + "'&$expand=Fields ").then(function (resp_sup) {
                    if (resp_sup.d.results.length > 0) {
                        //arrego de columnas de lista
                        $scope.resultFields = resp_sup.d.results[0].Fields.results;

                        //fvenegas code
                        for (let f = 0; f < $scope.resultFields.length; f++) {
                            switch ($scope.resultFields[f].EntityPropertyName) {
                                case "TotalGDI":
                                    $rootScope.arrayCampos.filter(x => x.nombreCampo == "TotalGDI")[0].estado = true;
                                    break;
                                case "TotalObjNegocios":
                                    $rootScope.arrayCampos.filter(x => x.nombreCampo == "TotalObjNegocios")[0].estado = true;
                                    break;
                                case "TotalObjPersonas":
                                    $rootScope.arrayCampos.filter(x => x.nombreCampo == "TotalObjPersonas")[0].estado = true;
                                    break;
                                case "TotalCompetencias":
                                    $rootScope.arrayCampos.filter(x => x.nombreCampo == "TotalCompetencias")[0].estado = true;
                                    break;
                                case "SumaObjetivos":
                                    $rootScope.arrayCampos.filter(x => x.nombreCampo == "SumaObjetivos")[0].estado = true;
                                    break;
                            }
                        }

                        if ($rootScope.arrayCampos.filter(x => x.estado == false).length == 0) { //estan todos los campos
                            $rootScope.llamadoGDI();
                        } else {

                            //CREACION EN CASCADA DE COLUMNAS !!
                            if ($rootScope.arrayCampos[0].estado == false) {
                                spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('t" + $rootScope.anioCalculo + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 9,'Title':'" + $rootScope.arrayCampos[0].nombreCampo + "'}").then(function (data) {

                                    if ($rootScope.arrayCampos[1].estado == false) {
                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('t" + $rootScope.anioCalculo + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 9,'Title':'" + $rootScope.arrayCampos[1].nombreCampo + "'}").then(function (data) {

                                            if ($rootScope.arrayCampos[2].estado == false) {
                                                spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('t" + $rootScope.anioCalculo + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 9,'Title':'" + $rootScope.arrayCampos[2].nombreCampo + "'}").then(function (data) {

                                                    if ($rootScope.arrayCampos[3].estado == false) {
                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('t" + $rootScope.anioCalculo + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 9,'Title':'" + $rootScope.arrayCampos[3].nombreCampo + "'}").then(function (data) {

                                                            if ($rootScope.arrayCampos[4].estado == false) {
                                                                spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('t" + $rootScope.anioCalculo + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 9,'Title':'" + $rootScope.arrayCampos[4].nombreCampo + "'}").then(function (data) {
                                                                    $rootScope.llamadoGDI();
                                                                });
                                                            }
                                                        });
                                                    }
                                                });
                                            }
                                        });
                                    }
                                });
                            }
                        }
                        //FIN fvenegas code
                    }

                });









                // esta bien el llamado
                $scope.columnsGetCompetencias = "ID,Title,ID_x0020_de_x0020_documento,Nombre_x0020_de_x0020_la_x0020_p,ID_x0020_de_x0020_usuario_x0020_,Evaluado_x0020_Nombre,Evaluado_x0020_Apellidos,Supervisor_x0020_Nombre,Supervisor_x0020_Apellidos,Evaluado_x0020_Sociedad,Evaluado_x0020_Unidad_x0020_de_x,Nombre_x0020_de_x0020_la_x0020_c,Pro_x0028_Autocalificaci_x00f3_n,Pro_x0028_Calificaci_x00f3_n_x00,Nombre_x0020_del_x0020_paso_x002";
                $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('c" + $rootScope.anioCalculo + "')/Items?$select=" + $scope.columnsGetCompetencias + "&$top=5000";
                $rootScope.getDataCompetencias($scope.urlGetBase);






                $rootScope.llamadoGDI = function () {

                    $scope.columnsGetGDI = "ID,Evaluado_x0020__x00c1_rea_x0020_,Supervisor_x0020_Nombre,Supervisor_x0020_Apellidos,Calificaci_x00f3_n_x0020_global_,Evaluado_x0020_Sociedad,Evaluado_x0020_Unidad_x0020_de_x,Nombre_x0020_de_x0020_la_x0020_p,ID_x0020_de_x0020_usuario_x0020_,TotalGDI,TotalObjNegocios,TotalObjPersonas,TotalCompetencias,SumaObjetivos";
                    $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('t" + $rootScope.anioCalculo + "')/Items?$select=" + $scope.columnsGetGDI + "&$top=5000";
                    $rootScope.getDataGDI($scope.urlGetBase);

                }


            }

            $rootScope.procesarCalculos = function () {
                var _N_total_Negocio = $scope.datatableObjetivos.filter(x => x.Categor_x00ed_a_x0020_de_x0020_o == "Negocio" && x.OData__x0025__x0020_Final_x0020_de_x00 >= 0 && x.Estado == "Completado");
                var _N_total_Personas = $scope.datatableObjetivos.filter(x => x.Categor_x00ed_a_x0020_de_x0020_o == "Personas" && x.OData__x0025__x0020_Final_x0020_de_x00 >= 0 && x.Estado == "Completado");
                var CompetenciasCalc = $scope.datatableCompetencias.filter(x => x.Pro_x0028_Calificaci_x00f3_n_x00 >= 0);
                var _N_total_Objetivos = $scope.datatableObjetivos.filter(x => x.OData__x0025__x0020_Final_x0020_de_x00 >= 0 && x.Estado == "Completado");

                var _N_total_Negocio_idUnico = []
                var _N_total_Personas_idUnico = []
                var _CompetenciasCalc_idUnico = []
                var _N_total_Objetivos_idUnico = []




                var QregistrosO = 1
                for (let a = 0; a < _N_total_Objetivos.length; a++) {

                    var _sumObjetivos = (parseFloat(_N_total_Objetivos[a].OData__x0025__x0020_Final_x0020_de_x00) * parseFloat(_N_total_Objetivos[a].Ponderaci_x00f3_n_x0020_de_x0020)) / 100;

                    if (_N_total_Objetivos_idUnico.length == 0) {
                        _N_total_Objetivos_idUnico.push({
                            "idUsarioPropietario": _N_total_Objetivos[a].ID_x0020_de_x0020_usuario_x0020_,
                            "calculoObjetivos": _sumObjetivos,
                            "Qregistros": QregistrosO
                        })

                    } else {

                        var registroExiste = false;
                        var registroExisteIndex = 0;

                        for (let b = 0; b < _N_total_Objetivos_idUnico.length; b++) {

                            if (_N_total_Objetivos_idUnico[b].idUsarioPropietario == _N_total_Objetivos[a].ID_x0020_de_x0020_usuario_x0020_) {

                                registroExiste = true;
                                registroExisteIndex = b

                                break;

                            }

                        }

                        if (registroExiste) {

                            _N_total_Objetivos_idUnico[registroExisteIndex].calculoObjetivos += _sumObjetivos;
                            _N_total_Objetivos_idUnico[registroExisteIndex].Qregistros += QregistrosO

                        } else {


                            _N_total_Objetivos_idUnico.push({
                                "idUsarioPropietario": _N_total_Objetivos[a].ID_x0020_de_x0020_usuario_x0020_,
                                "calculoObjetivos": _sumObjetivos,
                                "Qregistros": 1
                            })
                        }
                    };




                } //fin ciclo calculo de negocio


                //ciclo calculo de negocio Ponderaci_x00f3_n_x0020_de_x0020

                var QregistrosN = 1
                for (let i = 0; i < _N_total_Negocio.length; i++) {

                    var _sumNegocio = (parseFloat(_N_total_Negocio[i].OData__x0025__x0020_Final_x0020_de_x00) * parseFloat(_N_total_Negocio[i].Ponderaci_x00f3_n_x0020_de_x0020)) / 100;
                    var _ponderacion = parseFloat(_N_total_Negocio[i].Ponderaci_x00f3_n_x0020_de_x0020);
                    if (_N_total_Negocio_idUnico.length == 0) {
                        _N_total_Negocio_idUnico.push({
                            "idUsarioPropietario": _N_total_Negocio[i].ID_x0020_de_x0020_usuario_x0020_,
                            "calculoObjetivos": _sumNegocio,
                            "calculo70": (_sumNegocio / 70) * 100,
                            "Qregistros": QregistrosN,
                            "Ponderacion": _ponderacion
                        })

                    } else {

                        var registroExiste = false;
                        var registroExisteIndex = 0;

                        for (let j = 0; j < _N_total_Negocio_idUnico.length; j++) {

                            if (_N_total_Negocio_idUnico[j].idUsarioPropietario == _N_total_Negocio[i].ID_x0020_de_x0020_usuario_x0020_) {

                                registroExiste = true;
                                registroExisteIndex = j

                                break;

                            }

                        }

                        if (registroExiste) {

                            _N_total_Negocio_idUnico[registroExisteIndex].calculoObjetivos += _sumNegocio;
                            _N_total_Negocio_idUnico[registroExisteIndex].calculo70 += (_sumNegocio / 70) * 100;
                            _N_total_Negocio_idUnico[registroExisteIndex].Qregistros += QregistrosN;
                            _N_total_Negocio_idUnico[registroExisteIndex].Ponderacion += _ponderacion;

                        } else {


                            _N_total_Negocio_idUnico.push({
                                "idUsarioPropietario": _N_total_Negocio[i].ID_x0020_de_x0020_usuario_x0020_,
                                "calculoObjetivos": _sumNegocio,
                                "calculo70": (_sumNegocio / 70) * 100,
                                "Qregistros": 1,
                                "Ponderacion": _ponderacion
                            })
                        }
                    };


                } //fin ciclo calculo de negocio



                //ciclo calculo de personas
                var QregistrosP = 1
                for (let k = 0; k < _N_total_Personas.length; k++) {


                    var _sumPersonas = (parseFloat(_N_total_Personas[k].OData__x0025__x0020_Final_x0020_de_x00) * parseFloat(_N_total_Personas[k].Ponderaci_x00f3_n_x0020_de_x0020)) / 100;
                    var __ponderacion = parseFloat(_N_total_Personas[k].Ponderaci_x00f3_n_x0020_de_x0020);

                    if (_N_total_Personas_idUnico.length == 0) {

                        _N_total_Personas_idUnico.push({
                            "idUsarioPropietario": _N_total_Personas[k].ID_x0020_de_x0020_usuario_x0020_,
                            "calculoObjetivos": _sumPersonas,
                            "calculo70": (_sumPersonas / 30) * 100,
                            "Qregistros": QregistrosP,
                            "Ponderacion": __ponderacion
                        })

                    } else {

                        var registroExiste = false;
                        var registroExisteIndex = 0;

                        for (let l = 0; l < _N_total_Personas_idUnico.length; l++) {

                            if (_N_total_Personas_idUnico[l].idUsarioPropietario == _N_total_Personas[k].ID_x0020_de_x0020_usuario_x0020_) {

                                registroExiste = true;
                                registroExisteIndex = l

                                break;

                            }

                        }

                        if (registroExiste) {

                            _N_total_Personas_idUnico[registroExisteIndex].calculoObjetivos += _sumPersonas;
                            _N_total_Personas_idUnico[registroExisteIndex].calculo70 += (_sumPersonas / 30) * 100;
                            _N_total_Personas_idUnico[registroExisteIndex].Qregistros += QregistrosP;
                            _N_total_Personas_idUnico[registroExisteIndex].Ponderacion += __ponderacion;;

                        } else {

                            _N_total_Personas_idUnico.push({
                                "idUsarioPropietario": _N_total_Personas[k].ID_x0020_de_x0020_usuario_x0020_,
                                "calculoObjetivos": _sumPersonas,
                                "calculo70": (_sumPersonas / 30) * 100,
                                "Qregistros": QregistrosP,
                                "Ponderacion": __ponderacion
                            })
                        }
                    }
                } //fin ciclo calculo de personas

                for (let clicloNegocio = 0; clicloNegocio < _N_total_Negocio_idUnico.length; clicloNegocio++) {

                    if (Math.round(_N_total_Negocio_idUnico[clicloNegocio].Ponderacion) == 100) {

                        _N_total_Negocio_idUnico[clicloNegocio].registroOk = "Sí"
                    }

                    if (Math.round(_N_total_Negocio_idUnico[clicloNegocio].Ponderacion) == 70) {

                        _N_total_Negocio_idUnico[clicloNegocio].registroOk = "Sí"
                    }


                }

                for (let cicloPersona = 0; cicloPersona < _N_total_Personas_idUnico.length; cicloPersona++) {

                    if (Math.round(_N_total_Personas_idUnico[cicloPersona].Ponderacion) == 0) {

                        _N_total_Personas_idUnico[cicloPersona].registroOk = "Sí"
                    }

                    if (Math.round(_N_total_Personas_idUnico[cicloPersona].Ponderacion) == 30) {

                        _N_total_Personas_idUnico[cicloPersona].registroOk = "Sí"
                    }

                }


                //ciclo calculo de competencias
                var ContadorCompetencias = 1
                for (let m = 0; m < CompetenciasCalc.length; m++) {

                    var _sumCompetencias = parseInt(CompetenciasCalc[m].Pro_x0028_Calificaci_x00f3_n_x00)

                    if (_CompetenciasCalc_idUnico.length == 0) {

                        _CompetenciasCalc_idUnico.push({
                            "idUsarioPropietario": CompetenciasCalc[m].ID_x0020_de_x0020_usuario_x0020_,
                            "CalificacionOficial": _sumCompetencias,
                            "Qregistros": ContadorCompetencias,
                            "PromedioCompetencias": 0
                        })

                    } else {

                        var registroExiste = false;
                        var registroExisteIndex = 0;

                        for (let n = 0; n < _CompetenciasCalc_idUnico.length; n++) {

                            if (_CompetenciasCalc_idUnico[n].idUsarioPropietario == CompetenciasCalc[m].ID_x0020_de_x0020_usuario_x0020_) {

                                registroExiste = true;
                                registroExisteIndex = n

                                break;

                            }
                        }

                        if (registroExiste) {

                            _CompetenciasCalc_idUnico[registroExisteIndex].CalificacionOficial += _sumCompetencias;
                            _CompetenciasCalc_idUnico[registroExisteIndex].Qregistros += ContadorCompetencias

                        } else {

                            _CompetenciasCalc_idUnico.push({

                                "idUsarioPropietario": CompetenciasCalc[m].ID_x0020_de_x0020_usuario_x0020_,
                                "CalificacionOficial": _sumCompetencias,
                                "Qregistros": ContadorCompetencias,
                                "PromedioCompetencias": 0

                            })
                        }
                    };
                } //fin ciclo calculo de competencias

                // calcula promedio de competencias
                for (let o = 0; o < _CompetenciasCalc_idUnico.length; o++) {

                    _CompetenciasCalc_idUnico[o].PromedioCompetencias = _CompetenciasCalc_idUnico[o].CalificacionOficial / _CompetenciasCalc_idUnico[o].Qregistros

                } // fin calcula promedio de competencias


                $scope.putArrayBatch = [];


                for (let p = 0; p < $rootScope.gdiCalculo.length; p++) {

                    for (let r = 0; r < _N_total_Negocio_idUnico.length; r++) {

                        if (_N_total_Negocio_idUnico[r].idUsarioPropietario == $rootScope.gdiCalculo[p].ID_x0020_de_x0020_usuario_x0020_ && _N_total_Negocio_idUnico[r].registroOk == "Sí") {

                            if ($rootScope.gdiCalculo[p].Nombre_x0020_de_x0020_la_x0020_p.endsWith('Líderes')) {

                                // batchRequest.payload = { '__metadata': { 'type': 'SP.Data.' + lista + 'ListItem' }};
                                var data = {

                                    '__metadata': {

                                        'type': "SP.Data.T" + $rootScope.anioCalculo + "ListItem"

                                    },

                                    'TotalObjNegocios': _N_total_Negocio_idUnico[r].calculo70
                                };

                                // spsservice.put_data("lists/getbytitle('GDI" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[p].ID + ")", data);

                                $scope.putArrayBatch.push({
                                    "endpoint": "lists/getbytitle('t" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[p].ID + ")",
                                    "data": data
                                })


                            } else {

                                var data = {
                                    '__metadata': {
                                        'type': "SP.Data.T" + $rootScope.anioCalculo + "ListItem"
                                    },
                                    'TotalObjNegocios': _N_total_Negocio_idUnico[r].calculoObjetivos
                                };

                                // spsservice.put_data("lists/getbytitle('GDI" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[p].ID + ")", data);

                                $scope.putArrayBatch.push({
                                    "endpoint": "lists/getbytitle('t" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[p].ID + ")",
                                    "data": data

                                })

                            }
                        }
                    }
                }


                // ################### Actualización de cálculos en lista GDI. TotalObjPersonas ###################################

                for (let q = 0; q < $rootScope.gdiCalculo.length; q++) {

                    for (let s = 0; s < _N_total_Personas_idUnico.length; s++) {

                        if (_N_total_Personas_idUnico[s].idUsarioPropietario == $rootScope.gdiCalculo[q].ID_x0020_de_x0020_usuario_x0020_ && _N_total_Personas_idUnico[s].registroOk == "Sí") {

                            if ($rootScope.gdiCalculo[q].Nombre_x0020_de_x0020_la_x0020_p.endsWith('Líderes')) {

                                var data = {

                                    '__metadata': {
                                        'type': "SP.Data.T" + $rootScope.anioCalculo + "ListItem"
                                    },
                                    'TotalObjPersonas': _N_total_Personas_idUnico[s].calculo70
                                };

                                // spsservice.put_data("lists/getbytitle('GDI" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[q].ID + ")", data);
                                $scope.putArrayBatch.push({
                                    "endpoint": "lists/getbytitle('t" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[q].ID + ")",
                                    "data": data
                                })

                            } else {

                                var data = {
                                    '__metadata': {
                                        'type': "SP.Data.T" + $rootScope.anioCalculo + "ListItem"
                                    },
                                    'TotalObjPersonas': _N_total_Personas_idUnico[s].calculoObjetivos
                                };

                                // spsservice.put_data("lists/getbytitle('GDI" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[q].ID + ")", data);
                                $scope.putArrayBatch.push({
                                    "endpoint": "lists/getbytitle('t" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[q].ID + ")",
                                    "data": data,
                                })
                            }
                        }
                    }
                }


                // ################### Actualización de cálculos en lista GDI. TotalCompetencias ###################################
                for (let t = 0; t < $rootScope.gdiCalculo.length; t++) {

                    for (let v = 0; v < _CompetenciasCalc_idUnico.length; v++) {

                        if (_CompetenciasCalc_idUnico[v].idUsarioPropietario == $rootScope.gdiCalculo[t].ID_x0020_de_x0020_usuario_x0020_) {

                            var data = {
                                '__metadata': {
                                    'type': "SP.Data.T" + $rootScope.anioCalculo + "ListItem"
                                },
                                'TotalCompetencias': _CompetenciasCalc_idUnico[v].PromedioCompetencias
                            };
                            // spsservice.put_data("lists/getbytitle('GDI" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[t].ID + ")", data);
                            $scope.putArrayBatch.push({
                                "endpoint": "lists/getbytitle('t" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[t].ID + ")",
                                "data": data
                            })
                        }
                    }
                }


                //#### actualiza sumaObjetivos
                for (let x = 0; x < $rootScope.gdiCalculo.length; x++) {


                    for (let z = 0; z < _N_total_Objetivos_idUnico.length; z++) {

                        if (_N_total_Objetivos_idUnico[z].idUsarioPropietario == $rootScope.gdiCalculo[x].ID_x0020_de_x0020_usuario_x0020_) {

                            var data = {
                                '__metadata': {
                                    'type': "SP.Data.T" + $rootScope.anioCalculo + "ListItem"
                                },
                                'SumaObjetivos': _N_total_Objetivos_idUnico[z].calculoObjetivos
                            };
                            // spsservice.put_data("lists/getbytitle('GDI" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[x].ID + ")", data);
                            $scope.putArrayBatch.push({
                                "endpoint": "lists/getbytitle('t" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[x].ID + ")",
                                "data": data
                            })
                        }
                    }
                }

                ;
                $scope.putBatch(0, 100);


            }

            $scope.putBatch = function (indice, termino) {


                $scope.putArrayBatch;

                let batchExecutor = new RestBatchExecutor(_spPageContextInfo.webAbsoluteUrl);
                var commands = [];
                for (indice; indice < termino; indice++) {
                    var batchRequest;
                    batchRequest = new BatchRequest();
                    batchRequest.verb = "MERGE";
                    batchRequest.headers = {
                        'If-Match': "*"
                    };


                    ;
                    batchRequest.endpoint = _spPageContextInfo.webAbsoluteUrl + "/_api/web/" + $scope.putArrayBatch[indice].endpoint;
                    batchRequest.payload = $scope.putArrayBatch[indice].data;
                    // batchRequest.payload[$scope.putArrayBatch[indice].nombreCampo] = $scope.putArrayBatch[indice].valorCampo
                    commands.push({
                        indice: batchExecutor.loadChangeRequest(batchRequest)
                    });
                }

                console.log(new Date().toLocaleString() + " Command pushed: End ID " + indice);

                batchExecutor.executeAsync().done(function (result) {

                    console.log(new Date().toLocaleString() + " Termino batch: " + new Date().toISOString());
                    let _termino = indice + $rootScope.intervalBatch;
                    if ($scope.putArrayBatch.length < _termino) {
                        _termino = $scope.putArrayBatch.length;
                    }
                    //verificar termino recursividad
                    if ($scope.putArrayBatch.length == indice) {
                        console.log("termino el proceso $batch");
                        $scope.columnsGetGDI = "ID,Evaluado_x0020__x00c1_rea_x0020_,Supervisor_x0020_Nombre,Supervisor_x0020_Apellidos,Calificaci_x00f3_n_x0020_global_,Evaluado_x0020_Sociedad,Evaluado_x0020_Unidad_x0020_de_x,Nombre_x0020_de_x0020_la_x0020_p,ID_x0020_de_x0020_usuario_x0020_,TotalGDI,TotalObjNegocios,TotalObjPersonas,TotalCompetencias,SumaObjetivos";
                        $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('t" + $rootScope.anioCalculo + "')/Items?$select=" + $scope.columnsGetGDI + "&$top=5000";
                        $rootScope.getDataGDICalculos($scope.urlGetBase);

                    } else {
                        $scope.putBatch(indice, _termino);
                    }
                }).fail(function (err) {
                    console.log("ERROR EN BATCH EXECUTOR: " + new Date().toISOString());
                });
            }

            $rootScope.putBatchTotalGDI = function () {


                $scope.putArrayGDI = []

                $rootScope.gdiCalculoPutBatch;

                for (let c = 0; c < $rootScope.gdiCalculoPutBatch.length; c++) {

                    if ($rootScope.gdiCalculoPutBatch[c].Nombre_x0020_de_x0020_la_x0020_p.endsWith('Líderes')) {

                        var data = {
                            '__metadata': {
                                'type': "SP.Data.T" + $rootScope.anioCalculo + "ListItem"
                            },
                            'TotalGDI': (($rootScope.gdiCalculoPutBatch[c].SumaObjetivos * 0.75) + ($rootScope.gdiCalculoPutBatch[c].TotalCompetencias * 0.25))
                        };

                        $scope.putArrayGDI.push({
                            "endpoint": "lists/getbytitle('t" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculoPutBatch[c].ID + ")",
                            "data": data
                        })

                    } else {

                        var data = {
                            '__metadata': {
                                'type': "SP.Data.T" + $rootScope.anioCalculo + "ListItem"
                            },
                            'TotalGDI': (($rootScope.gdiCalculoPutBatch[c].SumaObjetivos * 0.5) + ($rootScope.gdiCalculoPutBatch[c].TotalCompetencias * 0.5))
                        };

                        $scope.putArrayGDI.push({
                            "endpoint": "lists/getbytitle('t" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculoPutBatch[c].ID + ")",
                            "data": data
                        })

                    }
                }


                // PASAR EL AÑO
                $scope.BatchTotalGDIActualiza(0, 100);

            }

            $scope.BatchTotalGDIActualiza = function (indice, termino) {


                $scope.putArrayGDI;


                let batchExecutor = new RestBatchExecutor(_spPageContextInfo.webAbsoluteUrl);
                var commands = [];
                for (indice; indice < termino; indice++) {
                    var batchRequest;
                    batchRequest = new BatchRequest();
                    batchRequest.verb = "MERGE";
                    batchRequest.headers = {
                        'If-Match': "*"
                    };

                    batchRequest.endpoint = _spPageContextInfo.webAbsoluteUrl + "/_api/web/" + $scope.putArrayGDI[indice].endpoint;
                    batchRequest.payload = $scope.putArrayGDI[indice].data;
                    // batchRequest.payload[$scope.putArrayGDI[indice].nombreCampo] = $scope.putArrayGDI[indice].valorCampo
                    commands.push({
                        indice: batchExecutor.loadChangeRequest(batchRequest)
                    });
                }

                console.log(new Date().toLocaleString() + " GDI actualiza Command pushed: End ID " + indice);

                batchExecutor.executeAsync().done(function (result) {

                    console.log(new Date().toLocaleString() + " Termino batch: " + new Date().toISOString());
                    let _termino = indice + $rootScope.intervalBatch;
                    if ($scope.putArrayGDI.length < _termino) {
                        _termino = $scope.putArrayGDI.length;
                    }
                    //verificar termino recursividad
                    if ($scope.putArrayGDI.length == indice) {
                        console.log("termino el proceso $batch");
                        // pasar el año hasta la última función

                        $scope.createForDashboard();

                    } else {
                        $scope.BatchTotalGDIActualiza(indice, _termino);
                    }
                }).fail(function (err) {
                    console.log("ERROR EN BATCH EXECUTOR: " + new Date().toISOString());
                });
            }

            $scope.createForDashboard = function () {
                ;

                // spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('Dashboard')/Items?$select=ID&$filter=Ano eq 2018").then(function (resp_sup) {
                spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('Dashboard')/Items?$select=ID&$filter=Ano eq " + $rootScope.anioCalculo).then(function (resp_sup) {
                    if (resp_sup.d.results.length == 0) {
                        //insert
                        var data = {
                            '__metadata': {
                                'type': 'SP.Data.DashboardListItem'
                            },
                            'Ano': anio,
                            'N_total_GDI': 0,
                            'Promedio_GDI': 0,
                            'Min_GDI': 0,
                            'Mediana_GDI': 0,
                            'Max_GDI': 0,
                            "N_total_Negocio": 0,
                            "Promedio_Negocio": 0,
                            "Min_Negocio": 0,
                            "Mediana_Negocio": 0,
                            "Max_Negocio": 0,
                            "N_total_Persona": 0,
                            "Promedio_Persona": 0,
                            "Min_Persona": 0,
                            "Mediana_Persona": 0,
                            "Max_Persona": 0,
                            "N_total_Competencia": 0,
                            "Promedio_Competencia": 0,
                            "Min_Competencia": 0,
                            "Mediana_Competencia": 0,
                            "Max_Competencia": 0,

                        };
                        spsservice.post_data("lists/getbytitle('Dashboard')/items", data);

                        // traer información actualizada
                        $scope.columnsGetGDI = "ID,Evaluado_x0020__x00c1_rea_x0020_,Supervisor_x0020_Nombre,Supervisor_x0020_Apellidos,Calificaci_x00f3_n_x0020_global_,Evaluado_x0020_Sociedad,Evaluado_x0020_Unidad_x0020_de_x,Nombre_x0020_de_x0020_la_x0020_p,ID_x0020_de_x0020_usuario_x0020_,TotalGDI,TotalObjNegocios,TotalObjPersonas,TotalCompetencias,SumaObjetivos";
                        $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('t" + $rootScope.anioCalculo + "')/Items?$select=" + $scope.columnsGetGDI + "&$top=5000";
                        // $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('GDI2018')/Items?$select=" + $scope.columnsGetGDI + "&$top=5000";
                        $rootScope.getDataGDIForDashboard($scope.urlGetBase, $rootScope.anioCalculo);



                    } else {
                        //update

                        $scope.columnsGetGDI = "ID,Evaluado_x0020__x00c1_rea_x0020_,Supervisor_x0020_Nombre,Supervisor_x0020_Apellidos,Calificaci_x00f3_n_x0020_global_,Evaluado_x0020_Sociedad,Evaluado_x0020_Unidad_x0020_de_x,Nombre_x0020_de_x0020_la_x0020_p,ID_x0020_de_x0020_usuario_x0020_,TotalGDI,TotalObjNegocios,TotalObjPersonas,TotalCompetencias,SumaObjetivos";
                        $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('t" + $rootScope.anioCalculo + "')/Items?$select=" + $scope.columnsGetGDI + "&$top=5000";
                        // $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('GDI2018')/Items?$select=" + $scope.columnsGetGDI + "&$top=5000";
                        $rootScope.getDataGDIForDashboard($scope.urlGetBase, $rootScope.anioCalculo)

                    }
                })

            }

            $rootScope.putDashboard = function () {

                ;

                //Campos en nulo


                var arrayDashboarGDI = $rootScope.forDashboard.filter(x => x.TotalGDI >= 0 && x.TotalGDI != null && x.AplicaCalculo == "Sí" && x.TotalCompetencias != null);
                debugger;
                var arrayDashboarNegocio = $rootScope.forDashboard.filter(x => x.TotalObjNegocios >= 0 && x.TotalObjNegocios != null && x.AplicaCalculo == "Sí");
                var arrayDashboarPersona = $rootScope.forDashboard.filter(x => x.TotalObjPersonas >= 0 && x.TotalObjPersonas != null && x.AplicaCalculo == "Sí");
                var arrayDashboarCompetencias = $rootScope.forDashboard.filter(x => x.TotalCompetencias >= 0 && x.TotalCompetencias != null && x.AplicaCalculo == "Sí");

                // #region Calculos GDI
                arrayMedianaGDI = []
                sumGDI = 0
                promedioGDI = 0;

                for (let i = 0; i < arrayDashboarGDI.length; i++) {
                    arrayMedianaGDI.push(arrayDashboarGDI[i].TotalGDI)
                    sumGDI = sumGDI + arrayDashboarGDI[i].TotalGDI;

                    if (i == (arrayDashboarGDI.length - 1)) {

                        promedioGDI = parseFloat(sumGDI / arrayDashboarGDI.length).toFixed(2)

                    }
                }

                var maxGDI = Math.max.apply(Math, arrayDashboarGDI.map(function (o) {
                    return o.TotalGDI;
                }))


                var minGDI = Math.min.apply(Math, arrayDashboarGDI.map(function (o) {
                    return o.TotalGDI;
                }))


                arrayMedianaGDI.sort((a, b) => a - b);
                let lowMiddle = Math.floor((arrayMedianaGDI.length - 1) / 2);
                let highMiddle = Math.ceil((arrayMedianaGDI.length - 1) / 2);
                let median = (arrayMedianaGDI[lowMiddle] + arrayMedianaGDI[highMiddle]) / 2;
                medianaGDI = median;

                console.log("Resumen GDI, Promedio: " + promedioGDI + " Minima: " + minGDI + " Mediana: " + medianaGDI + " Máxima: " + maxGDI)

                //#endregion Calculos GDI


                // #region Calculos Negocio

                arrayMedianaNegocio = []
                sumNegocio = 0
                promedioNegocio = 0;

                for (let j = 0; j < arrayDashboarNegocio.length; j++) {

                    arrayMedianaNegocio.push(arrayDashboarNegocio[j].TotalObjNegocios)
                    sumNegocio = sumNegocio + arrayDashboarNegocio[j].TotalObjNegocios;

                    if (j == (arrayDashboarNegocio.length - 1)) {

                        promedioNegocio = parseFloat(sumNegocio / arrayDashboarNegocio.length).toFixed(2)

                    }
                }

                var maxNegocio = Math.max.apply(Math, arrayDashboarNegocio.map(function (o) {
                    return o.TotalObjNegocios;
                }))


                var minNegocio = Math.min.apply(Math, arrayDashboarNegocio.map(function (o) {
                    return o.TotalObjNegocios;
                }))

                arrayMedianaNegocio.sort((a, b) => a - b);
                let lowMiddle2 = Math.floor((arrayMedianaNegocio.length - 1) / 2);
                let highMiddle2 = Math.ceil((arrayMedianaNegocio.length - 1) / 2);
                let median2 = (arrayMedianaNegocio[lowMiddle2] + arrayMedianaNegocio[highMiddle2]) / 2;
                medianaNegocio = median2;

                console.log("Resumen Negocio, Promedio: " + promedioNegocio + " Minima: " + minNegocio + " Mediana: " + medianaNegocio + " Máxima: " + maxNegocio)

                // #endregion Calculos Negocio

                // #region calculos persona
                arrayMedianaPersona = []
                sumPersona = 0
                promedioPersona = 0;

                for (let k = 0; k < arrayDashboarPersona.length; k++) {

                    arrayMedianaPersona.push(arrayDashboarPersona[k].TotalObjPersonas)
                    sumPersona = sumPersona + arrayDashboarPersona[k].TotalObjPersonas;

                    if (k == (arrayDashboarPersona.length - 1)) {

                        promedioPersona = parseFloat(sumPersona / arrayDashboarPersona.length).toFixed(2)

                    }
                }

                var maxPersona = Math.max.apply(Math, arrayDashboarPersona.map(function (o) {
                    return o.TotalObjPersonas;
                }))


                var minPersona = Math.min.apply(Math, arrayDashboarPersona.map(function (o) {
                    return o.TotalObjPersonas;
                }))


                arrayMedianaPersona.sort((a, b) => a - b);
                let lowMiddle3 = Math.floor((arrayMedianaPersona.length - 1) / 2);
                let highMiddle3 = Math.ceil((arrayMedianaPersona.length - 1) / 2);
                let median3 = (arrayMedianaPersona[lowMiddle3] + arrayMedianaPersona[highMiddle3]) / 2;
                medianaPersona = median3;

                console.log("Resumen Personas, Promedio: " + promedioPersona + " Minima: " + minPersona + " Mediana: " + medianaPersona + " Máxima: " + maxPersona)

                // #endregion calculos persona


                // #region calculos competencias

                arrayMedianaCompetencias = []
                sumCompetencias = 0
                promedioCompetencias = 0;

                for (let l = 0; l < arrayDashboarCompetencias.length; l++) {

                    arrayMedianaCompetencias.push(arrayDashboarCompetencias[l].TotalCompetencias)
                    sumCompetencias = sumCompetencias + arrayDashboarCompetencias[l].TotalCompetencias;

                    if (l == (arrayDashboarCompetencias.length - 1)) {

                        promedioCompetencias = parseFloat(sumCompetencias / arrayDashboarCompetencias.length).toFixed(2)

                    }
                }

                var maxCompetencias = Math.max.apply(Math, arrayDashboarCompetencias.map(function (o) {
                    return o.TotalCompetencias;
                }))

                var minCompetencias = Math.min.apply(Math, arrayDashboarCompetencias.map(function (o) {
                    return o.TotalCompetencias;
                }))

                arrayMedianaCompetencias.sort((a, b) => a - b);
                let lowMiddle4 = Math.floor((arrayMedianaCompetencias.length - 1) / 2);
                let highMiddle4 = Math.ceil((arrayMedianaCompetencias.length - 1) / 2);
                let median4 = (arrayMedianaCompetencias[lowMiddle4] + arrayMedianaCompetencias[highMiddle4]) / 2;
                medianaCompetencias = median4;

                console.log("Resumen Competencias, Promedio: " + promedioCompetencias + " Minima: " + minCompetencias + " Mediana: " + medianaCompetencias + " Máxima: " + maxCompetencias)

                // #endregion calculos competencias

                // put en lista



                spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('Dashboard')/Items?$select=ID&$filter=Ano eq " + $rootScope.anioCalculo).then(function (resp_sup) {
                    // spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('Dashboard')/Items?$select=ID&$filter=Ano eq 2018").then(function (resp_sup) {
                    if (resp_sup.d.results.length > 0) {
                        var data = {
                            '__metadata': {
                                'type': 'SP.Data.DashboardListItem'
                            },
                            'Ano': $rootScope.anioCalculo,
                            'N_total_GDI': arrayDashboarGDI.length, // largo total gdi
                            'Promedio_GDI': parseFloat(promedioGDI).toFixed(2),
                            'Min_GDI': parseFloat(minGDI.toFixed(2)),
                            'Mediana_GDI': parseFloat(medianaGDI.toFixed(2)),
                            'Max_GDI': parseFloat(maxGDI.toFixed(2)),
                            "N_total_Negocio": $scope.datatableObjetivos.filter(x => x.Categor_x00ed_a_x0020_de_x0020_o == "Negocio" && x.OData__x0025__x0020_Final_x0020_de_x00 >= 0).length,
                            "Promedio_Negocio": parseFloat(promedioNegocio).toFixed(2),
                            "Min_Negocio": parseFloat(minNegocio.toFixed(2)),
                            "Mediana_Negocio": parseFloat(medianaNegocio.toFixed(2)),
                            "Max_Negocio": parseFloat(maxNegocio.toFixed(2)),
                            "N_total_Persona": $scope.datatableObjetivos.filter(x => x.Categor_x00ed_a_x0020_de_x0020_o == "Personas" && x.OData__x0025__x0020_Final_x0020_de_x00 >= 0).length,
                            "Promedio_Persona": parseFloat(promedioPersona),
                            "Min_Persona": parseFloat(minPersona.toFixed(2)),
                            "Mediana_Persona": parseFloat(medianaPersona.toFixed(2)),
                            "Max_Persona": parseFloat(maxPersona.toFixed(2)),
                            "N_total_Competencia": $scope.datatableCompetencias.filter(x => x.Pro_x0028_Calificaci_x00f3_n_x00 >= 0).length,
                            "Promedio_Competencia": parseFloat(promedioCompetencias),
                            "Min_Competencia": parseFloat(minCompetencias.toFixed(2)),
                            "Mediana_Competencia": parseFloat(medianaCompetencias.toFixed(2)),
                            "Max_Competencia": parseFloat(maxCompetencias.toFixed(2)),

                        };

                        spsservice.put_data("lists/getbytitle('Dashboard')/items(" + resp_sup.d.results[0].ID + ")", data);
                        alert("Calculos actualizados");
                        $rootScope.bloqueopantalla = false;
                    }

                })

            }

        })

}(angular.module('spsmodule')));