(function (app) {
    app
        .controller('administracionController', function ($scope, SweetAlert, $rootScope, spsservice, $route, $location) {
            $rootScope.menuActivo();
            $scope.checkObjetivos = false;
            $scope.checkCompetencias = false;
            $scope.checkGDI = false;

            // crea arrglo vacio
            $scope.dataObjetivos = [];

            var objetivosColum = "ID,IdObjetivo,Guid0,NombreDeUsuario,Nombre,Apellido,IdUsuarioPropietarioObjetivo,PropietarioNombreUsuario,PropietarioRun,PropietarioNombre,PropietarioApellidos,PropietarioJobCode,AreaDePersonal,Categoria,Numeracion,Objetivo,Indicador,Meta,Ponderacion,TipoDeCalculo,Real,Cumplimiento,PorcentajeFinalCumplimiento,PropietarioDelObjetivoGerenciaSu,NombreDeUsuarioSupervisor,NombreDelSupervisor,Sociedad,UnidadDeNegocio,CalculoObjetivos,anio"


            var competenciasColum = "ID,Estado,IdDelDocumento,FechaCreacionForm,NombrePlantillaForm,IdUsuarioEvaluado,NombreEvaluado,ApellidosEvaluado,IdUsuarioSupervisor,NombreSupervisor,ApellidosSupervisor,EvaluadoSociedad,EvaluadoUnidadNegocio,NombreDeLaCompetencia,AutocalificacionDeCompetencia,CalificacionOficialCompetencia,NombrePasoItinerarioCFGRegional,anio"

            var GDIColums = "ID,Estado,IdDelDocumento,FechaCreacionForm,NombrePlantillaForm,IdUsuarioEvaluado,NombreEvaluado,EvaluadoRun,NombreUsuarioEvaluado,EvaluadoApellidos,EvaluadoJobCode,EvaluadoGerencia_x002f_Subgerenc,EvaluadoSociedad,EvaluadoUnidadDeNegocio,EvaluadoUnidadDeNegocio,NombreSupervisor,ApellidosSupervisor,CalificacionGlobalDesempe_x00f1_,TotalGDI,TotalObjNegocios,TotalObjPersonas,TotalCompetencias,anio"

            $rootScope.procesando = false;
            $scope.progresobatch = 0;

            $scope.SelectFile = function (file, nombreLista) {
                $scope.SelectedFile = file;
                $scope.archivoLista = nombreLista
            };






            $scope.CreateListColumnList = function (listName, tipoCampo, nombreCampo) {
                $.ajax({
                    url: _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + listName + "')/fields",
                    type: "POST",
                    data: "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': " + tipoCampo + ",'Title':'" + nombreCampo + "'}",
                    headers: {
                        "Accept": "application/json;odata=verbose",
                        "Content-Type": "application/json;odata=verbose",
                        "X-RequestDigest": $("#__REQUESTDIGEST").val()
                    },
                    success: function (data, status, xhr) {
                        console.log("Success");
                    },
                    error: function (xhr, status, error) {
                        console.log("Failed");
                    }
                });
            }

            $scope.eliminarLista = function (lista, anioLista) {

                spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/Web/Lists?select=Id&$filter=title eq '" + lista + +anioLista + "'").then(function (checkLista) {
                    if (checkLista.d.results.length == 0) {
                        alert("Ops..." + lista + +anioLista + " no existe")
                    } else {
                        spsservice.delete_list(_spPageContextInfo.webAbsoluteUrl + "/_api/Web/Lists(guid'" + checkLista.d.results[0].Id + "')").then(function () {
                            alert("lista " + lista + +anioLista + " eliminada");
                            $route.reload();
                        });
                    }
                })
            }


            // #region ELIMINAR BATCH DINAMICO
            $scope.deleteBatch = function (lista, anio) {

                $rootScope.bloqueopantalla = true;

                $scope.registrosEliminarBatch = [];
                $scope.listaEliminarBatch = lista;
                $scope.anioEliminar = anio;

                spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/Web/Lists?$filter=title eq '" + $scope.listaEliminarBatch + $scope.anioEliminar + "'").then(function (checkLista) {

                    if (checkLista.d.results.length == 0) {

                        SweetAlert.swal("Ops...", "Periodo " + $scope.anioEliminar + " no existe", "warning");
                        $rootScope.bloqueopantalla = false;

                    } else {

                        $scope.getDataDeleteBatch(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('" + $scope.listaEliminarBatch + anio + "')/Items?$select=ID&$top=5000");
                    }
                })
            }

            $scope.deleteProcessBatch = function (indice, termino) {


                $scope.progresobatch = parseInt(((indice * 100) / $scope.registrosEliminarBatch.length));
                $scope.progresobatch = $scope.progresobatch >= 100 ? 100 : $scope.progresobatch;
                $('.progress-bar').css('width', $scope.progresobatch + '%');
                $("#theBar").html($scope.progresobatch + '%');


                let batchExecutor = new RestBatchExecutor(_spPageContextInfo.webAbsoluteUrl);
                var commands = []
                for (indice; indice < termino; indice++) {
                    var batchRequest;
                    batchRequest = new BatchRequest();
                    batchRequest.verb = "DELETE";
                    batchRequest.headers = {
                        'If-Match': "*"
                    };
                    batchRequest.endpoint = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/GetByTitle('" + $scope.listaEliminarBatch + $scope.anioEliminar + "')/items(" + $scope.registrosEliminarBatch[indice].ID + ")";
                    batchRequest.payload = {
                        '__metadata': {
                            'type': 'SP.Data.' + $scope.listaEliminarBatch + $scope.anioEliminar + 'ListItem'
                        }
                    };
                    commands.push({
                        indice: batchExecutor.loadChangeRequest(batchRequest)
                    });
                }

                console.log(new Date().toLocaleString() + " Command pushed: End ID " + indice);

                batchExecutor.executeAsync().done(function () {
                    console.log(new Date().toLocaleString() + " Termino batch: " + new Date().toISOString());
                    let _termino = indice + $rootScope.intervalBatch;
                    if ($scope.registrosEliminarBatch.length < _termino) {
                        _termino = $scope.registrosEliminarBatch.length;
                    }

                    //verificar termino recursividad
                    if ($scope.registrosEliminarBatch.length == indice) {
                        console.log("termino el proceso $batch");

                        SweetAlert.swal("Eliminación terminada!.", "", "success");
                        $('.progress-bar').css('width', '0%');
                        $("#theBar").html('0%');
                        $rootScope.bloqueopantalla = false;
                    } else {
                        $scope.deleteProcessBatch(indice, _termino);
                    }

                }).fail(function (err) {
                    console.log("ERROR EN BATCH EXECUTOR: " + new Date().toISOString());
                    $rootScope.bloqueopantalla = false;
                });
            }

            $scope.getDataDeleteBatch = function (query) {
                spsservice.get_type(query).then(function (resp_sup) {
                    $scope.registrosEliminarBatch = $scope.registrosEliminarBatch.concat(resp_sup.d.results);
                    if (resp_sup.d.__next) {
                        url = resp_sup.d.__next;
                        $scope.getDataDeleteBatch(resp_sup.d.__next);
                    } else {
                        if ($scope.registrosEliminarBatch.length == 0) {
                            SweetAlert.swal("Ops...", "No hay registros en el periodo", "warning");
                            $rootScope.bloqueopantalla = false;
                        } else {
                            $scope.deleteProcessBatch(0, $rootScope.intervalBatch);
                        }
                    }
                })
            }
            // #endregion  FIN ELIMINAR BATCH


            // #region CARGA BATCH ####################################################################################################################
            $scope.UploadBatch = function (lista) {

                if ($scope.SelectedFile != null) {

                    var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.xls|.xlsx)$/;
                    if (regex.test($scope.SelectedFile.name.toLowerCase())) {
                        if (typeof (FileReader) != "undefined") {
                            var reader = new FileReader();
                            //For Browsers other than IE.
                            if (reader.readAsBinaryString) {
                                reader.onload = function (e) {
                                    $scope.listaBatchProcess = lista;
                                    $scope.ProcessExcelCargaBatch(e.target.result);
                                };
                                reader.readAsBinaryString($scope.SelectedFile);
                            } else {
                                //For IE Browser.
                                reader.onload = function (e) {
                                    var data = "";
                                    var bytes = new Uint8Array(e.target.result);
                                    for (var i = 0; i < bytes.byteLength; i++) {
                                        data += String.fromCharCode(bytes[i]);
                                    }
                                    $scope.listaBatchProcess = lista;
                                    $scope.ProcessExcelCargaBatch(e.target.result);
                                };
                                reader.readAsArrayBuffer($scope.SelectedFile);
                            }
                        } else {
                            alert("This browser does not support HTML5.");
                            $rootScope.procesando = false;
                            $rootScope.bloqueopantalla = false;
                        }
                    } else {
                        alert("Please upload a valid Excel file.");
                        $rootScope.procesando = false;
                        $rootScope.bloqueopantalla = false;
                    }

                } else {
                    alert("debe seleccionar archivo")
                }



            }

            $scope.ProcessExcelCargaBatch = function (data) {


                //agregar confirmación 
                SweetAlert.swal({
                        title: "¿Está seguro de cargar " + $scope.listaBatchProcess + "?",
                        text: "No se puede revertir esta operación. No debe actualizar la página hasta que el proceso haya finalizado.",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#16AB39",
                        confirmButtonText: "Si, cargar!",
                        cancelButtonText: "Salir",
                        closeOnConfirm: true
                    },



                    function (isConfirm) {


                        if (isConfirm) {
                            $rootScope.bloqueopantalla = true;
                            var workbook = XLSX.read(data, {
                                type: 'binary'
                            });
                            var firstSheet = workbook.SheetNames[0];
                            $scope._excelRowsBatch = XLSX.utils.sheet_to_row_object_array(workbook.Sheets[firstSheet]);

                            if ($scope._excelRowsBatch.length > 0) {
                                // $scope.$apply(function () {

                                if ($scope.anioObjetivos != null && $scope.listaBatchProcess == "Objetivos") {

                                    $scope.anocheck = $scope.anioObjetivos
                                }
                                if ($scope.anioCompetencias != null && $scope.listaBatchProcess == "Competencias") {

                                    $scope.anocheck = $scope.anioCompetencias;
                                }
                                if ($scope.anioGDI != null && $scope.listaBatchProcess == "GDI") {

                                    $scope.anocheck = $scope.anioGDI;
                                }

                                $scope.anocheck;

                                //Checkear lista
                                spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/Web/Lists?$filter=title eq '" + $scope.listaBatchProcess + $scope.anocheck + "'").then(function (checkLista) {
                                    if (checkLista.d.results.length == 0) { //No existe la lista                        

                                        //Crear lista
                                        var siteUrl = _spPageContextInfo.webAbsoluteUrl;
                                        var fullUrl = siteUrl + "/_api/web/lists";
                                        $.ajax({
                                            url: fullUrl,
                                            type: "POST",
                                            data: JSON.stringify({
                                                '__metadata': {
                                                    'type': 'SP.List'
                                                },
                                                'BaseTemplate': 100,
                                                'Title': $scope.listaBatchProcess + $scope.anocheck
                                            }),
                                            headers: {
                                                "accept": "application/json;odata=verbose",
                                                "content-type": "application/json;odata=verbose",
                                                "X-RequestDigest": $("#__REQUESTDIGEST").val()
                                            },
                                            success: function (data) {
                                                switch ($scope.listaBatchProcess) {
                                                    case "Objetivos":
                                                        // #region camposObjetivos
                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'IdObjetivo'}").then(function (data) {
                                                            spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'NombreDelSupervisor'}").then(function (data) {
                                                                spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'ApellidosDelSupervisor'}").then(function (data) {
                                                                    spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'IdUsuarioPropietarioObjetivo'}").then(function (data) {
                                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'PropietarioNombre'}").then(function (data) {
                                                                            spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'PropietarioApellidos'}").then(function (data) {
                                                                                spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'PropietarioNombreUsuario'}").then(function (data) {
                                                                                    spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'NombrePlantillaForm'}").then(function (data) {
                                                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'IdDelDocumento'}").then(function (data) {
                                                                                            spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'Estado'}").then(function (data) {
                                                                                                spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'Categoria'}").then(function (data) {
                                                                                                    spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 3,'Title':'NombreDeObjetivo'}").then(function (data) {
                                                                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'Ponderacion'}").then(function (data) {
                                                                                                            spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'Meta'}").then(function (data) {
                                                                                                                spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 3,'Title':'MetricaDeObjetivos'}").then(function (data) {
                                                                                                                    spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'CalificacionOficialObjetivo'}").then(function (data) {
                                                                                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'Analytics'}").then(function (data) {
                                                                                                                            spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'Cumplimiento'}").then(function (data) {
                                                                                                                                spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'PorcentajeFinalCumplimiento'}").then(function (data) {
                                                                                                                                    spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 3,'Title':'Indicador'}").then(function (data) {
                                                                                                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'Real'}").then(function (data) {
                                                                                                                                            spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'TipoDeCalculo'}").then(function (data) {
                                                                                                                                                spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 9,'Title':'CalculoObjetivos'}").then(function (data) {
                                                                                                                                                    spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 9,'Title':'anio'}").then(function (data) {
                                                                                                                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'ActivoEliminado'}").then(function (data) {
                                                                                                                                                            spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'IdUsuarioSupervisor'}").then(function (data) {
                                                                                                                                                                //llamado a funcion recursiva                                                                                                                                                    
                                                                                                                                                                $scope.postBatch(0, $rootScope.intervalBatch);
                                                                                                                                                            });
                                                                                                                                                        });
                                                                                                                                                    });
                                                                                                                                                });
                                                                                                                                            });
                                                                                                                                        });
                                                                                                                                    });
                                                                                                                                });
                                                                                                                            });
                                                                                                                        });
                                                                                                                    });
                                                                                                                });
                                                                                                            });
                                                                                                        });
                                                                                                    });
                                                                                                });
                                                                                            });
                                                                                        });
                                                                                    });
                                                                                });
                                                                            });
                                                                        });
                                                                    });
                                                                });
                                                            });
                                                        });
                                                        // #endregion camposObjetivos                                                
                                                        break;

                                                    case "Competencias":
                                                        // #region camposCompetencias
                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioCompetencias + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'Estado'}").then(function (data) {
                                                            spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioCompetencias + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'IdDelDocumento'}").then(function (data) {
                                                                spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioCompetencias + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'FechaCreacionForm'}").then(function (data) {
                                                                    spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioCompetencias + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'NombrePlantillaForm'}").then(function (data) {
                                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioCompetencias + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'IdUsuarioEvaluado'}").then(function (data) {
                                                                            spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioCompetencias + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'NombreEvaluado'}").then(function (data) {
                                                                                spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioCompetencias + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'ApellidosEvaluado'}").then(function (data) {
                                                                                    spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioCompetencias + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'IdUsuarioSupervisor'}").then(function (data) {
                                                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioCompetencias + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'NombreSupervisor'}").then(function (data) {
                                                                                            spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioCompetencias + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'ApellidosSupervisor'}").then(function (data) {
                                                                                                spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioCompetencias + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'EvaluadoSociedad'}").then(function (data) {
                                                                                                    spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioCompetencias + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'EvaluadoUnidadNegocio'}").then(function (data) {
                                                                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioCompetencias + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'NombreDeLaCompetencia'}").then(function (data) {
                                                                                                            spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioCompetencias + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 9,'Title':'AutocalificacionDeCompetencia'}").then(function (data) {
                                                                                                                spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioCompetencias + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 9,'Title':'CalificacionOficialCompetencia'}").then(function (data) {
                                                                                                                    spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioCompetencias + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 9,'Title':'anio'}").then(function (data) {
                                                                                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioCompetencias + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'NombrePasoItinerarioCFGRegional'}").then(function (data) {
                                                                                                                            //llamado a funcion recursiva
                                                                                                                            $scope.postBatch(0, $rootScope.intervalBatch);
                                                                                                                        });
                                                                                                                    });
                                                                                                                });
                                                                                                            });
                                                                                                        });
                                                                                                    });
                                                                                                });
                                                                                            });
                                                                                        });
                                                                                    });
                                                                                });
                                                                            });
                                                                        });
                                                                    });
                                                                });
                                                            });
                                                        });

                                                        // #endregion camposCompetencias                                                


                                                        break;

                                                    case "GDI":
                                                        // #region camposGDI
                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'Estado'}").then(function (data) {
                                                            spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'IdDelDocumento'}").then(function (data) {
                                                                spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'FechaCreacionForm'}").then(function (data) {
                                                                    spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'NombrePlantillaForm'}").then(function (data) {
                                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'IdUsuarioEvaluado'}").then(function (data) {
                                                                            spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'NombreEvaluado'}").then(function (data) {
                                                                                spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'EvaluadoRun'}").then(function (data) {
                                                                                    spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'NombreUsuarioEvaluado'}").then(function (data) {
                                                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'EvaluadoApellidos'}").then(function (data) {
                                                                                            spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'EvaluadoJobCode'}").then(function (data) {
                                                                                                spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'EvaluadoGerencia_x002f_Subgerenc'}").then(function (data) {
                                                                                                    spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'EvaluadoSociedad'}").then(function (data) {
                                                                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'EvaluadoUnidadDeNegocio'}").then(function (data) {
                                                                                                            spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'EvaluadoAreaDePersonal'}").then(function (data) {
                                                                                                                spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'NombreSupervisor'}").then(function (data) {
                                                                                                                    spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'ApellidosSupervisor'}").then(function (data) {
                                                                                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'CalificacionGlobalDesempe_x00f1_'}").then(function (data) {
                                                                                                                            spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'PasoDelItinerario'}").then(function (data) {
                                                                                                                                spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 2,'Title':'EstadoUsuario'}").then(function (data) {
                                                                                                                                    spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 9,'Title':'TotalGDI'}").then(function (data) {
                                                                                                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 9,'Title':'TotalObjNegocios'}").then(function (data) {
                                                                                                                                            spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 9,'Title':'TotalObjPersonas'}").then(function (data) {
                                                                                                                                                spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 9,'Title':'anio'}").then(function (data) {
                                                                                                                                                    spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 9,'Title':'TotalCompetencias'}").then(function (data) {
                                                                                                                                                        spsservice.create_columnList(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/fields", "{'__metadata':{'type': 'SP.Field'},'FieldTypeKind': 9,'Title':'SumaObjetivos'}").then(function (data) { //llamado a funcion recursiva

                                                                                                                                                            $scope.postBatch(0, $rootScope.intervalBatch);
                                                                                                                                                        });
                                                                                                                                                    });
                                                                                                                                                });
                                                                                                                                            });
                                                                                                                                        });
                                                                                                                                    });
                                                                                                                                });
                                                                                                                            });
                                                                                                                        });
                                                                                                                    });
                                                                                                                });
                                                                                                            });
                                                                                                        });
                                                                                                    });
                                                                                                });
                                                                                            });
                                                                                        });
                                                                                    });
                                                                                });
                                                                            });
                                                                        });
                                                                    });
                                                                });
                                                            });
                                                        });
                                                        // #endregion camposGDI                                                
                                                        break;
                                                }
                                            },
                                            error: function (data) {
                                                // 
                                                console.log("nok" + data);
                                                $rootScope.bloqueopantalla = false;
                                            }
                                        });
                                    } else { //lista ok
                                        //llamado a funcion recursiva
                                        $scope.postBatch(0, $rootScope.intervalBatch);
                                    }
                                });
                            }
                        }
                    });
            }

            $scope.postBatch = function (indice, termino) {

                $scope.progresobatch = parseInt(((indice * 100) / $scope._excelRowsBatch.length));
                $scope.progresobatch = $scope.progresobatch >= 100 ? 100 : $scope.progresobatch;
                $('.progress-bar').css('width', $scope.progresobatch + '%');
                $("#theBar").html($scope.progresobatch + '%');

                let batchExecutor = new RestBatchExecutor(_spPageContextInfo.webAbsoluteUrl);
                var commands = [];
                for (indice; indice < termino; indice++) {
                    var batchRequest;
                    batchRequest = new BatchRequest();
                    batchRequest.verb = "POST";
                    batchRequest.headers = {
                        'If-Match': "*"
                    };

                    switch ($scope.listaBatchProcess) {
                        case "TestBatch":
                            batchRequest.payload["Title"] = $scope._excelRowsBatch[indice]["ID de objetivo"];
                            batchRequest.payload["Anio"] = 2018;
                            break;

                        case "Objetivos":
                            //             

                            batchRequest.endpoint = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/GetByTitle('" + $scope.listaBatchProcess + $scope.anioObjetivos + "')/items";
                            batchRequest.payload = {
                                '__metadata': {
                                    'type': 'SP.Data.' + $scope.listaBatchProcess + $scope.anioObjetivos + 'ListItem'
                                }
                            };
                            batchRequest.payload['IdObjetivo'] = $scope._excelRowsBatch[indice]["ID de objetivo"];
                            batchRequest.payload['IdUsuarioSupervisor'] = $scope._excelRowsBatch[indice]["ID de usuario del supervisor"];
                            batchRequest.payload['NombreDelSupervisor'] = $scope._excelRowsBatch[indice]["Supervisor Nombre"];
                            batchRequest.payload['ApellidosDelSupervisor'] = $scope._excelRowsBatch[indice]["Supervisor Apellidos"];
                            batchRequest.payload['IdUsuarioPropietarioObjetivo'] = $scope._excelRowsBatch[indice]["ID de usuario del evaluado"];
                            batchRequest.payload['PropietarioNombre'] = $scope._excelRowsBatch[indice]["Evaluado Nombre"];
                            batchRequest.payload['PropietarioApellidos'] = $scope._excelRowsBatch[indice]["Evaluado Apellidos"];
                            batchRequest.payload['PropietarioNombreUsuario'] = $scope._excelRowsBatch[indice]["Propietario del objetivo Nombre de usuario"];
                            batchRequest.payload['NombrePlantillaForm'] = $scope._excelRowsBatch[indice]["Nombre de la plantilla de formulario"];
                            batchRequest.payload['IdDelDocumento'] = $scope._excelRowsBatch[indice]["ID de documento"];
                            batchRequest.payload['Estado'] = $scope._excelRowsBatch[indice]["Estado"];
                            batchRequest.payload['Categoria'] = $scope._excelRowsBatch[indice]["Categoría de objetivo"];
                            batchRequest.payload['NombreDeObjetivo'] = $scope._excelRowsBatch[indice]["Nombre de objetivo"];
                            batchRequest.payload['Ponderacion'] = $scope._excelRowsBatch[indice]["Ponderación de objetivo"];
                            batchRequest.payload['Meta'] = $scope._excelRowsBatch[indice]["Meta"];
                            batchRequest.payload['MetricaDeObjetivos'] = $scope._excelRowsBatch[indice]["Métrica de objetivos"];
                            batchRequest.payload['CalificacionOficialObjetivo'] = $scope._excelRowsBatch[indice]["Calificación oficial de objetivo"];
                            batchRequest.payload['Analytics'] = $scope._excelRowsBatch[indice]["ANALYTICS_LIST_VIEW_BUILDER_SUBDOMAIN_goal_goal#OBJ_EXT#FIELD12"];
                            batchRequest.payload['Cumplimiento'] = $scope._excelRowsBatch[indice]["Cumplimiento"];
                            batchRequest.payload['PorcentajeFinalCumplimiento'] = $scope._excelRowsBatch[indice]["% Final de Cumplimiento"];
                            batchRequest.payload['ActivoEliminado'] = $scope._excelRowsBatch[indice]["Activo/Eliminado"];
                            batchRequest.payload['Indicador'] = $scope._excelRowsBatch[indice]["Indicador"].replace(/(?:\r\n|\r|\n)/g, " ");
                            batchRequest.payload['Real'] = $scope._excelRowsBatch[indice]["Real"];
                            batchRequest.payload['TipoDeCalculo'] = $scope._excelRowsBatch[indice]["Tipo de Cálculo"];
                            batchRequest.payload["anio"] = $scope.anioObjetivos;
                            //batchRequest.payload['CalculoObjetivos'] = (parseFloat($scope._excelRowsBatch[indice]["% Final de Cumplimiento"]) * parseFloat($scope._excelRowsBatch[indice]["Ponderación de objetivo"])) / 100

                            break;

                        case "Competencias":


                            batchRequest.endpoint = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/GetByTitle('" + $scope.listaBatchProcess + $scope.anioCompetencias + "')/items";
                            batchRequest.payload = {
                                '__metadata': {
                                    'type': 'SP.Data.' + $scope.listaBatchProcess + $scope.anioCompetencias + 'ListItem'
                                }
                            };
                            batchRequest.payload['Estado'] = $scope._excelRowsBatch[indice]["Estado"];
                            batchRequest.payload['IdDelDocumento'] = $scope._excelRowsBatch[indice]["ID de documento"];
                            batchRequest.payload['FechaCreacionForm'] = $scope._excelRowsBatch[indice]["Fecha de creación de formulario"];
                            batchRequest.payload['NombrePlantillaForm'] = $scope._excelRowsBatch[indice]["Nombre de la plantilla de formulario"];
                            batchRequest.payload['IdUsuarioEvaluado'] = $scope._excelRowsBatch[indice]["ID de usuario del evaluado"];
                            batchRequest.payload['NombreEvaluado'] = $scope._excelRowsBatch[indice]["Evaluado Nombre"];
                            batchRequest.payload['ApellidosEvaluado'] = $scope._excelRowsBatch[indice]["Evaluado Apellidos"];
                            batchRequest.payload['IdUsuarioSupervisor'] = $scope._excelRowsBatch[indice]["ID de usuario del supervisor"];
                            batchRequest.payload['NombreSupervisor'] = $scope._excelRowsBatch[indice]["Supervisor Nombre"];
                            batchRequest.payload['ApellidosSupervisor'] = $scope._excelRowsBatch[indice]["Supervisor Apellidos"];
                            batchRequest.payload['EvaluadoSociedad'] = $scope._excelRowsBatch[indice]["Evaluado Sociedad"];
                            batchRequest.payload['EvaluadoUnidadNegocio'] = $scope._excelRowsBatch[indice]["Evaluado Unidad de Negocio"];
                            batchRequest.payload['NombreDeLaCompetencia'] = $scope._excelRowsBatch[indice]["Nombre de la competencia (específico de la configuración regional)"];
                            // Qué hacer con los campos con texto "Sin calificación"?
                            batchRequest.payload['AutocalificacionDeCompetencia'] = parseInt($scope._excelRowsBatch[indice]["Pro(Autocalificación de competencia)"]) == "Sin Calificación" ? null : parseInt($scope._excelRowsBatch[indice]["Pro(Autocalificación de competencia)"]);
                            batchRequest.payload['CalificacionOficialCompetencia'] = parseInt($scope._excelRowsBatch[indice]["Pro(Calificación oficial de competencia)"]) == "Sin Calificación" ? null : parseInt($scope._excelRowsBatch[indice]["Pro(Calificación oficial de competencia)"]);
                            batchRequest.payload['NombrePasoItinerarioCFGRegional'] = $scope._excelRowsBatch[indice]["Nombre del paso del itinerario (específico de la configuración regional)"];
                            batchRequest.payload["anio"] = $scope.anioCompetencias;
                            break;

                        case "GDI":

                            batchRequest.endpoint = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/GetByTitle('" + $scope.listaBatchProcess + $scope.anioGDI + "')/items";
                            batchRequest.payload = {
                                '__metadata': {
                                    'type': 'SP.Data.' + $scope.listaBatchProcess + $scope.anioGDI + 'ListItem'
                                }
                            };
                            batchRequest.payload['Estado'] = $scope._excelRowsBatch[indice]["Estado"];
                            batchRequest.payload['IdDelDocumento'] = $scope._excelRowsBatch[indice]["ID de documento"];
                            batchRequest.payload['FechaCreacionForm'] = $scope._excelRowsBatch[indice]["Fecha de creación de formulario"];
                            batchRequest.payload['NombrePlantillaForm'] = $scope._excelRowsBatch[indice]["Nombre de la plantilla de formulario"];
                            batchRequest.payload['IdUsuarioEvaluado'] = $scope._excelRowsBatch[indice]["ID de usuario del evaluado"];
                            batchRequest.payload['NombreEvaluado'] = $scope._excelRowsBatch[indice]["Evaluado Nombre de usuario"];
                            batchRequest.payload['EvaluadoRun'] = $scope._excelRowsBatch[indice]["Evaluado RUN"];
                            batchRequest.payload['NombreUsuarioEvaluado'] = $scope._excelRowsBatch[indice]["Evaluado Nombre"];
                            batchRequest.payload['EvaluadoApellidos'] = $scope._excelRowsBatch[indice]["Evaluado Apellidos"];
                            batchRequest.payload['EvaluadoJobCode'] = $scope._excelRowsBatch[indice]["Evaluado Job Code"];
                            batchRequest.payload['EvaluadoGerencia_x002f_Subgerenc'] = $scope._excelRowsBatch[indice]["Evaluado Gerencia/Subgerencia"];
                            batchRequest.payload['EvaluadoSociedad'] = $scope._excelRowsBatch[indice]["Evaluado Sociedad"];
                            batchRequest.payload['EvaluadoUnidadDeNegocio'] = $scope._excelRowsBatch[indice]["Evaluado Unidad de Negocio"];
                            batchRequest.payload['EvaluadoAreaDePersonal'] = $scope._excelRowsBatch[indice]["Evaluado Área de personal"];
                            batchRequest.payload['NombreSupervisor'] = $scope._excelRowsBatch[indice]["Supervisor Nombre"];
                            batchRequest.payload['ApellidosSupervisor'] = $scope._excelRowsBatch[indice]["Supervisor Apellidos"];
                            batchRequest.payload['CalificacionGlobalDesempe_x00f1_'] = $scope._excelRowsBatch[indice]["Calificación global de desempeño"];
                            batchRequest.payload['PasoDelItinerario'] = $scope._excelRowsBatch[indice]["Nombre del paso del itinerario (específico de la configuración regional)"];
                            batchRequest.payload['EstadoUsuario'] = $scope._excelRowsBatch[indice]["Estado de usuario"];
                            batchRequest.payload['TotalGDI'] = $scope._excelRowsBatch[indice]["TOTAL GDI"];
                            batchRequest.payload['TotalObjNegocios'] = $scope._excelRowsBatch[indice]["TOTAL OBJ NEGOCIOS"];
                            batchRequest.payload['TotalObjPersonas'] = $scope._excelRowsBatch[indice]["TOTAL OBJ PERSONAS"];
                            batchRequest.payload['TotalCompetencias'] = $scope._excelRowsBatch[indice]["TOTAL COMPETENCIAS"];
                            batchRequest.payload["anio"] = $scope.anioGDI;
                            break;


                    }

                    commands.push({
                        indice: batchExecutor.loadChangeRequest(batchRequest)
                    });
                }

                console.log(new Date().toLocaleString() + " Command pushed: End ID " + indice);

                batchExecutor.executeAsync().done(function (result) {

                    console.log(new Date().toLocaleString() + " Termino batch: " + new Date().toISOString());
                    let _termino = indice + $rootScope.intervalBatch;
                    if ($scope._excelRowsBatch.length < _termino) {
                        _termino = $scope._excelRowsBatch.length;
                    }
                    //verificar termino recursividad
                    if ($scope._excelRowsBatch.length == indice) {
                        console.log("termino el proceso $batch");
                        SweetAlert.swal("Carga terminada!.", "", "success");

                        $('.progress-bar').css('width', '0%');
                        $("#theBar").html('0%');
                        $rootScope.bloqueopantalla = false;
                        $route.reload();

                        //contr



                        //Actualizar registros de Dashboard &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
                        var _anio = 1999;

                    } else {
                        // setTimeout(function(){$scope.postBatch(data, indice, _termino)}, 1000);


                        $scope.postBatch(indice, _termino);
                    }
                }).fail(function (err) {
                    console.log("ERROR EN BATCH EXECUTOR: " + new Date().toISOString());
                    $rootScope.bloqueopantalla = false;
                });
            }
            // #endregion END CARGA BATCH ####################################################################################################################




            $scope.getDataObjetivosBatch = function (query) {
                spsservice.get_type(query).then(function (resp_sup) {
                    $scope.dataObjetivosBatch = $scope.dataObjetivosBatch.concat(resp_sup.d.results);

                    if (resp_sup.d.__next) {
                        url = resp_sup.d.__next;
                        $scope.getDataObjetivosBatch(resp_sup.d.__next);
                    } else { //fin recursividad

                        //elimino batch
                        if ($scope.dataObjetivosBatch.length > 0) {
                            $scope.postBatch($scope._excelRowsBatch, 0, $rootScope.intervalBatch);
                        } else {
                            $scope.postBatch($scope._excelRowsBatch, 0, $rootScope.intervalBatch);
                        }
                    }
                })
            }

            $scope.calculos = function () {

                debugger;
                $rootScope.bloqueopantalla = true;



                $scope.listaActualizarBatch = "t";
                $rootScope.anioCalculo = $scope.anioCalculo;
                // $rootScope.obteniendoDatos = true;

                $rootScope.datatableObjetivos = []
                $rootScope.datatableCompetencias = []
                $rootScope.datatableGDI = []

                $rootScope.objetivosCalculoTerminado = false;
                $rootScope.competenciasCalculoTerminado = false;
                $rootScope.gdiCalculoTerminado = false;


                spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/Web/Lists?$filter=title eq 'o" + $rootScope.anioCalculo + "'").then(function (checkListaCalc) {
                        if (checkListaCalc.d.results.length > 0) {

                            spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/Web/Lists?$filter=title eq 'c" + $rootScope.anioCalculo + "'").then(function (checkListaCalc) {
                                if (checkListaCalc.d.results.length > 0) {


                                    spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/Web/Lists?$filter=title eq 't" + $rootScope.anioCalculo + "'").then(function (checkListaCalc) {
                                        if (checkListaCalc.d.results.length > 0) { /// proceso de listas OK


                                            $scope.columnsGetObjetivos = "ID,ID_x0020_de_x0020_objetivo,ID_x0020_de_x0020_usuario_x0020_,Supervisor_x0020_Nombre,Supervisor_x0020_Apellidos,Evaluado_x0020_Nombre,Evaluado_x0020_Apellidos,Categor_x00ed_a_x0020_de_x0020_o,Nombre_x0020_de_x0020_objetivo,Ponderaci_x00f3_n_x0020_de_x0020,Meta,Cumplimiento,OData__x0025__x0020_Final_x0020_de_x00,Indicador,Real,Tipo_x0020_de_x0020_C_x00e1_lcul";
                                            $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('o" + $rootScope.anioCalculo + "')/Items?$select=" + $scope.columnsGetObjetivos + "&$top=5000";
                                            $rootScope.getDataObjetivos($scope.urlGetBase)

                                            $scope.columnsGetCompetencias = "ID,Title,ID_x0020_de_x0020_documento,Nombre_x0020_de_x0020_la_x0020_p,ID_x0020_de_x0020_usuario_x0020_,Evaluado_x0020_Nombre,Evaluado_x0020_Apellidos,Supervisor_x0020_Nombre,Supervisor_x0020_Apellidos,Evaluado_x0020_Sociedad,Evaluado_x0020_Unidad_x0020_de_x,Nombre_x0020_de_x0020_la_x0020_c,Pro_x0028_Autocalificaci_x00f3_n,Pro_x0028_Calificaci_x00f3_n_x00,Nombre_x0020_del_x0020_paso_x002";
                                            $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('c" + $rootScope.anioCalculo + "')/Items?$select=" + $scope.columnsGetCompetencias + "&$top=5000";
                                            $rootScope.getDataCompetencias($scope.urlGetBase);

                                            $scope.columnsGetGDI = "ID,Evaluado_x0020__x00c1_rea_x0020_,Supervisor_x0020_Nombre,Supervisor_x0020_Apellidos,Calificaci_x00f3_n_x0020_global_,Evaluado_x0020_Sociedad,Evaluado_x0020_Unidad_x0020_de_x,Nombre_x0020_de_x0020_la_x0020_p,ID_x0020_de_x0020_usuario_x0020_";
                                            $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('t" + $rootScope.anioCalculo + "')/Items?$select=" + $scope.columnsGetGDI + "&$top=5000";
                                            $rootScope.getDataGDI($scope.urlGetBase);


                                        } else {
                                            alert('Lista de GDI no encontrada');
                                            $rootScope.bloqueopantalla = false;
                                        }
                                    });
                                } else {
                                    alert('Lista de Competencias no encontrada');
                                    $rootScope.bloqueopantalla = false;
                                }
                            });
                        } else {
                            alert('Lista de Objetivos no encontrada')
                            $rootScope.bloqueopantalla = false;
                        }
                    }



                );




                // cuando la validación de las listas está correcta.


            }



            $rootScope.procesarCalculos = function () {

               // #######################Sacar los registros con -999999 

                var _N_total_Negocio = $scope.datatableObjetivos.filter(x => x.Categor_x00ed_a_x0020_de_x0020_o == "Negocio" && x.OData__x0025__x0020_Final_x0020_de_x00 >= 0);
                var _N_total_Personas = $scope.datatableObjetivos.filter(x => x.Categor_x00ed_a_x0020_de_x0020_o == "Personas" && x.OData__x0025__x0020_Final_x0020_de_x00 >= 0);
                var CompetenciasCalc = $scope.datatableCompetencias.filter(x => x.Pro_x0028_Calificaci_x00f3_n_x00 >= 0);
                var _N_total_Objetivos = $scope.datatableObjetivos.filter(x => x.OData__x0025__x0020_Final_x0020_de_x00 >= 0);

                var _N_total_Negocio_idUnico = []
                var _N_total_Personas_idUnico = []
                var _CompetenciasCalc_idUnico = []
                var _N_total_Objetivos_idUnico = []




                var QregistrosO = 1
                for (let a = 0; a < _N_total_Objetivos.length; a++) {

                    var _sumObjetivos = (parseFloat(_N_total_Objetivos[a].OData__x0025__x0020_Final_x0020_de_x00) * parseFloat(_N_total_Objetivos[a].Ponderaci_x00f3_n_x0020_de_x0020)) / 100;

                    if (_N_total_Objetivos_idUnico.length == 0) {
                        _N_total_Objetivos_idUnico.push({
                            "idUsarioPropietario": _N_total_Objetivos[a].ID_x0020_de_x0020_usuario_x0020_,
                            "calculoObjetivos": _sumObjetivos,
                            "Qregistros": QregistrosO
                        })

                    } else {

                        var registroExiste = false;
                        var registroExisteIndex = 0;

                        for (let b = 0; b < _N_total_Objetivos_idUnico.length; b++) {

                            if (_N_total_Objetivos_idUnico[b].idUsarioPropietario == _N_total_Objetivos[a].ID_x0020_de_x0020_usuario_x0020_) {

                                registroExiste = true;
                                registroExisteIndex = b

                                break;

                            }

                        }

                        if (registroExiste) {

                            _N_total_Objetivos_idUnico[registroExisteIndex].calculoObjetivos += _sumObjetivos;
                            _N_total_Objetivos_idUnico[registroExisteIndex].Qregistros += QregistrosO

                        } else {


                            _N_total_Objetivos_idUnico.push({
                                "idUsarioPropietario": _N_total_Objetivos[a].ID_x0020_de_x0020_usuario_x0020_,
                                "calculoObjetivos": _sumObjetivos,
                                "Qregistros": 1
                            })
                        }
                    };

                } //fin ciclo calculo de negocio



                //ciclo calculo de negocio

                var QregistrosN = 1
                for (let i = 0; i < _N_total_Negocio.length; i++) {

                    var _sumNegocio = (parseFloat(_N_total_Negocio[i].OData__x0025__x0020_Final_x0020_de_x00) * parseFloat(_N_total_Negocio[i].Ponderaci_x00f3_n_x0020_de_x0020)) / 100;

                    if (_N_total_Negocio_idUnico.length == 0) {
                        _N_total_Negocio_idUnico.push({
                            "idUsarioPropietario": _N_total_Negocio[i].ID_x0020_de_x0020_usuario_x0020_,
                            "calculoObjetivos": _sumNegocio,
                            "calculo70": _sumNegocio * 0.70,
                            "Qregistros": QregistrosN
                        })

                    } else {

                        var registroExiste = false;
                        var registroExisteIndex = 0;

                        for (let j = 0; j < _N_total_Negocio_idUnico.length; j++) {

                            if (_N_total_Negocio_idUnico[j].idUsarioPropietario == _N_total_Negocio[i].ID_x0020_de_x0020_usuario_x0020_) {

                                registroExiste = true;
                                registroExisteIndex = j

                                break;

                            }

                        }

                        if (registroExiste) {

                            _N_total_Negocio_idUnico[registroExisteIndex].calculoObjetivos += _sumNegocio;
                            _N_total_Negocio_idUnico[registroExisteIndex].calculo70 += _sumNegocio / 0.70
                            _N_total_Negocio_idUnico[registroExisteIndex].Qregistros += QregistrosN

                        } else {


                            _N_total_Negocio_idUnico.push({
                                "idUsarioPropietario": _N_total_Negocio[i].ID_x0020_de_x0020_usuario_x0020_,
                                "calculoObjetivos": _sumNegocio,
                                "calculo70": _sumNegocio / 0.70,
                                "Qregistros": 1
                            })
                        }
                    };

                } //fin ciclo calculo de negocio




                //ciclo calculo de personas

                var QregistrosP = 1
                for (let k = 0; k < _N_total_Personas.length; k++) {


                    var _sumPersonas = (parseFloat(_N_total_Personas[k].OData__x0025__x0020_Final_x0020_de_x00) * parseFloat(_N_total_Personas[k].Ponderaci_x00f3_n_x0020_de_x0020)) / 100;

                    if (_N_total_Personas_idUnico.length == 0) {

                        _N_total_Personas_idUnico.push({
                            "idUsarioPropietario": _N_total_Personas[k].ID_x0020_de_x0020_usuario_x0020_,
                            "calculoObjetivos": _sumPersonas,
                            "calculo70": _sumPersonas / 0.70,
                            "Qregistros": QregistrosP
                        })

                    } else {

                        var registroExiste = false;
                        var registroExisteIndex = 0;

                        for (let l = 0; l < _N_total_Personas_idUnico.length; l++) {

                            if (_N_total_Personas_idUnico[l].idUsarioPropietario == _N_total_Personas[k].ID_x0020_de_x0020_usuario_x0020_) {

                                registroExiste = true;
                                registroExisteIndex = l

                                break;

                            }

                        }

                        if (registroExiste) {

                            _N_total_Personas_idUnico[registroExisteIndex].calculoObjetivos += _sumPersonas;
                            _N_total_Personas_idUnico[registroExisteIndex].calculo70 += _sumPersonas / 0.70
                            _N_total_Personas_idUnico[registroExisteIndex].Qregistros += QregistrosP

                        } else {

                            _N_total_Personas_idUnico.push({
                                "idUsarioPropietario": _N_total_Personas[k].ID_x0020_de_x0020_usuario_x0020_,
                                "calculoObjetivos": _sumPersonas,
                                "calculo70": _sumPersonas / 0.70,
                                "Qregistros": QregistrosP
                            })
                        }
                    };
                } //fin ciclo calculo de personas




                //ciclo calculo de competencias


                var ContadorCompetencias = 1
                for (let m = 0; m < CompetenciasCalc.length; m++) {

                    var _sumCompetencias = parseInt(CompetenciasCalc[m].Pro_x0028_Calificaci_x00f3_n_x00)

                    if (_CompetenciasCalc_idUnico.length == 0) {

                        _CompetenciasCalc_idUnico.push({
                            "idUsarioPropietario": CompetenciasCalc[m].ID_x0020_de_x0020_usuario_x0020_,
                            "CalificacionOficial": _sumCompetencias,
                            "Qregistros": ContadorCompetencias,
                            "PromedioCompetencias": 0
                        })

                    } else {

                        var registroExiste = false;
                        var registroExisteIndex = 0;

                        for (let n = 0; n < _CompetenciasCalc_idUnico.length; n++) {

                            if (_CompetenciasCalc_idUnico[n].idUsarioPropietario == CompetenciasCalc[m].ID_x0020_de_x0020_usuario_x0020_) {

                                registroExiste = true;
                                registroExisteIndex = n

                                break;

                            }
                        }

                        if (registroExiste) {

                            _CompetenciasCalc_idUnico[registroExisteIndex].CalificacionOficial += _sumCompetencias;
                            _CompetenciasCalc_idUnico[registroExisteIndex].Qregistros += ContadorCompetencias

                        } else {

                            _CompetenciasCalc_idUnico.push({

                                "idUsarioPropietario": CompetenciasCalc[m].ID_x0020_de_x0020_usuario_x0020_,
                                "CalificacionOficial": _sumCompetencias,
                                "Qregistros": ContadorCompetencias,
                                "PromedioCompetencias": 0

                            })
                        }
                    };
                } //fin ciclo calculo de competencias

                // calcula promedio de competencias
                for (let o = 0; o < _CompetenciasCalc_idUnico.length; o++) {

                    _CompetenciasCalc_idUnico[o].PromedioCompetencias = _CompetenciasCalc_idUnico[o].CalificacionOficial / _CompetenciasCalc_idUnico[o].Qregistros

                } // fin calcula promedio de competencias




                $scope.putArrayBatch = [];



                // ################### Actualización de cálculos en lista GDI. ###################################


                // ################### Actualización de cálculos en lista GDI. TotalObjNegocios ###################################
                for (let p = 0; p < $rootScope.gdiCalculo.length; p++) {

                    for (let r = 0; r < _N_total_Negocio_idUnico.length; r++) {

                        if ($rootScope.gdiCalculo[p].ID_x0020_de_x0020_usuario_x0020_ == _N_total_Negocio_idUnico[r].idUsarioPropietario) {

                            if ($rootScope.gdiCalculo[p].Nombre_x0020_de_x0020_la_x0020_p.endsWith('Líderes')) {

                                // batchRequest.payload = { '__metadata': { 'type': 'SP.Data.' + lista + 'ListItem' }};
                                var data = {

                                    '__metadata': {

                                        'type': "SP.Data.t" + $rootScope.anioCalculo + "ListItem"

                                    },

                                    'TotalObjNegocios': _N_total_Negocio_idUnico[r].calculo70
                                };

                                // spsservice.put_data("lists/getbytitle('GDI" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[p].ID + ")", data);

                                $scope.putArrayBatch.push({
                                    "endpoint": "lists/getbytitle('t" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[p].ID + ")",
                                    "data": data
                                })


                            } else {

                                var data = {
                                    '__metadata': {
                                        'type': "SP.Data.t" + $rootScope.anioCalculo + "ListItem"
                                    },
                                    'TotalObjNegocios': _N_total_Negocio_idUnico[r].calculoObjetivos
                                };

                                // spsservice.put_data("lists/getbytitle('GDI" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[p].ID + ")", data);

                                $scope.putArrayBatch.push({
                                    "endpoint": "lists/getbytitle('t" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[p].ID + ")",
                                    "data": data

                                })

                            }
                        }
                    }
                }




                // ################### Actualización de cálculos en lista GDI. TotalObjPersonas ###################################

                for (let q = 0; q < $rootScope.gdiCalculo.length; q++) {

                    for (let s = 0; s < _N_total_Personas_idUnico.length; s++) {

                        if ($rootScope.gdiCalculo[q].ID_x0020_de_x0020_usuario_x0020_ == _N_total_Personas_idUnico[s].idUsarioPropietario) {

                            if ($rootScope.gdiCalculo[q].Nombre_x0020_de_x0020_la_x0020_p.endsWith('Líderes')) {

                                var data = {

                                    '__metadata': {
                                        'type': "SP.Data.t" + $rootScope.anioCalculo + "ListItem"
                                    },
                                    'TotalObjPersonas': _N_total_Personas_idUnico[s].calculo70
                                };

                                // spsservice.put_data("lists/getbytitle('GDI" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[q].ID + ")", data);
                                $scope.putArrayBatch.push({
                                    "endpoint": "lists/getbytitle('t" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[q].ID + ")",
                                    "data": data
                                })

                            } else {

                                var data = {
                                    '__metadata': {
                                        'type': "SP.Data.t" + $rootScope.anioCalculo + "ListItem"
                                    },
                                    'TotalObjPersonas': _N_total_Personas_idUnico[s].calculoObjetivos
                                };

                                // spsservice.put_data("lists/getbytitle('GDI" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[q].ID + ")", data);
                                $scope.putArrayBatch.push({
                                    "endpoint": "lists/getbytitle('t" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[q].ID + ")",
                                    "data": data,
                                })
                            }
                        }
                    }
                }



                // ################### Actualización de cálculos en lista GDI. TotalCompetencias ###################################
                for (let t = 0; t < $rootScope.gdiCalculo.length; t++) {

                    for (let v = 0; v < _CompetenciasCalc_idUnico.length; v++) {

                        if ($rootScope.gdiCalculo[t].ID_x0020_de_x0020_usuario_x0020_ == _CompetenciasCalc_idUnico[v].idUsarioPropietario) {

                            var data = {
                                '__metadata': {
                                    'type': "SP.Data.t" + $rootScope.anioCalculo + "ListItem"
                                },
                                'TotalCompetencias': _CompetenciasCalc_idUnico[v].PromedioCompetencias
                            };
                            // spsservice.put_data("lists/getbytitle('GDI" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[t].ID + ")", data);
                            $scope.putArrayBatch.push({
                                "endpoint": "lists/getbytitle('t" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[t].ID + ")",
                                "data": data
                            })
                        }
                    }
                }


                //#### actualiza sumaObjetivos
                for (let x = 0; x < $rootScope.gdiCalculo.length; x++) {


                    for (let z = 0; z < _N_total_Objetivos_idUnico.length; z++) {

                        if ($rootScope.gdiCalculo[x].ID_x0020_de_x0020_usuario_x0020_ == _N_total_Objetivos_idUnico[z].idUsarioPropietario) {

                            var data = {
                                '__metadata': {
                                    'type': "SP.Data.t" + $rootScope.anioCalculo + "ListItem"
                                },
                                'SumaObjetivos': _N_total_Objetivos_idUnico[z].calculoObjetivos
                            };
                            // spsservice.put_data("lists/getbytitle('GDI" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[x].ID + ")", data);
                            $scope.putArrayBatch.push({
                                "endpoint": "lists/getbytitle('t" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculo[x].ID + ")",
                                "data": data
                            })
                        }
                    }
                }


                $scope.putBatch(0, 100);


            }


            $scope.putBatch = function (indice, termino) {

                let batchExecutor = new RestBatchExecutor(_spPageContextInfo.webAbsoluteUrl);
                var commands = [];
                for (indice; indice < termino; indice++) {
                    var batchRequest;
                    batchRequest = new BatchRequest();
                    batchRequest.verb = "MERGE";
                    batchRequest.headers = {
                        'If-Match': "*"
                    };

                    batchRequest.endpoint = _spPageContextInfo.webAbsoluteUrl + "/_api/web/" + $scope.putArrayBatch[indice].endpoint;
                    batchRequest.payload = $scope.putArrayBatch[indice].data;
                    // batchRequest.payload[$scope.putArrayBatch[indice].nombreCampo] = $scope.putArrayBatch[indice].valorCampo
                    commands.push({
                        indice: batchExecutor.loadChangeRequest(batchRequest)
                    });
                }

                console.log(new Date().toLocaleString() + " Command pushed: End ID " + indice);

                batchExecutor.executeAsync().done(function (result) {

                    console.log(new Date().toLocaleString() + " Termino batch: " + new Date().toISOString());
                    let _termino = indice + $rootScope.intervalBatch;
                    if ($scope.putArrayBatch.length < _termino) {
                        _termino = $scope.putArrayBatch.length;
                    }
                    //verificar termino recursividad
                    if ($scope.putArrayBatch.length == indice) {
                        console.log("termino el proceso $batch");
                        $scope.columnsGetGDI = "ID,Evaluado_x0020__x00c1_rea_x0020_,Supervisor_x0020_Nombre,Supervisor_x0020_Apellidos,Calificaci_x00f3_n_x0020_global_,Evaluado_x0020_Sociedad,Evaluado_x0020_Unidad_x0020_de_x,Nombre_x0020_de_x0020_la_x0020_p,ID_x0020_de_x0020_usuario_x0020_,TotalGDI,TotalObjNegocios,TotalObjPersonas,TotalCompetencias,SumaObjetivos";                        
                        $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('t" + $rootScope.anioCalculo + "')/Items?$select=" + $scope.columnsGetGDI + "&$top=5000";
                        $rootScope.getDataGDICalculos($scope.urlGetBase);

                    } else {
                        $scope.putBatch(indice, _termino);
                    }
                }).fail(function (err) {
                    console.log("ERROR EN BATCH EXECUTOR: " + new Date().toISOString());
                });
            }


            $rootScope.putBatchTotalGDI = function () {
                debugger

                $scope.putArrayGDI = []

                $rootScope.gdiCalculoPutBatch;

                for (let c = 0; c < $rootScope.gdiCalculoPutBatch.length; c++) {

                    if ($rootScope.gdiCalculoPutBatch[c].Nombre_x0020_de_x0020_la_x0020_p.endsWith('Líderes')) {

                        var data = {
                            '__metadata': {
                                'type': "SP.Data.GDI" + $rootScope.anioCalculo + "ListItem"
                            },
                            'TotalGDI': (($rootScope.gdiCalculoPutBatch[c].SumaObjetivos * 0.75) + ($rootScope.gdiCalculoPutBatch[c].TotalCompetencias * 0.25))
                        };

                        $scope.putArrayGDI.push({
                            "endpoint": "lists/getbytitle('GDI" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculoPutBatch[c].ID + ")",
                            "data": data
                        })

                    } else {

                        var data = {
                            '__metadata': {
                                'type': "SP.Data.GDI" + $rootScope.anioCalculo + "ListItem"
                            },
                            'TotalGDI': (($rootScope.gdiCalculoPutBatch[c].SumaObjetivos * 0.5) + ($rootScope.gdiCalculoPutBatch[c].TotalCompetencias * 0.5))
                        };

                        $scope.putArrayGDI.push({
                            "endpoint": "lists/getbytitle('GDI" + $rootScope.anioCalculo + "')/items(" + $rootScope.gdiCalculoPutBatch[c].ID + ")",
                            "data": data
                        })

                    }
                }


                // PASAR EL AÑO
                $scope.BatchTotalGDIActualiza(0, 100);

            }



            $scope.BatchTotalGDIActualiza = function (indice, termino) {

                $scope.putArrayGDI;

                let batchExecutor = new RestBatchExecutor(_spPageContextInfo.webAbsoluteUrl);
                var commands = [];
                for (indice; indice < termino; indice++) {
                    var batchRequest;
                    batchRequest = new BatchRequest();
                    batchRequest.verb = "MERGE";
                    batchRequest.headers = {
                        'If-Match': "*"
                    };

                    batchRequest.endpoint = _spPageContextInfo.webAbsoluteUrl + "/_api/web/" + $scope.putArrayGDI[indice].endpoint;
                    batchRequest.payload = $scope.putArrayGDI[indice].data;
                    // batchRequest.payload[$scope.putArrayGDI[indice].nombreCampo] = $scope.putArrayGDI[indice].valorCampo
                    commands.push({
                        indice: batchExecutor.loadChangeRequest(batchRequest)
                    });
                }

                console.log(new Date().toLocaleString() + " GDI actualiza Command pushed: End ID " + indice);

                batchExecutor.executeAsync().done(function (result) {

                    console.log(new Date().toLocaleString() + " Termino batch: " + new Date().toISOString());
                    let _termino = indice + $rootScope.intervalBatch;
                    if ($scope.putArrayGDI.length < _termino) {
                        _termino = $scope.putArrayGDI.length;
                    }
                    //verificar termino recursividad
                    if ($scope.putArrayGDI.length == indice) {
                        console.log("termino el proceso $batch");
                        // pasar el año hasta la última función

                        $scope.createForDashboard();

                    } else {
                        $scope.BatchTotalGDIActualiza(indice, _termino);
                    }
                }).fail(function (err) {
                    console.log("ERROR EN BATCH EXECUTOR: " + new Date().toISOString());
                });
            }

            $scope.createForDashboard = function () {
                debugger;

                // spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('Dashboard')/Items?$select=ID&$filter=Ano eq 2018").then(function (resp_sup) {
                spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('Dashboard')/Items?$select=ID&$filter=Ano eq " + $rootScope.anioCalculo).then(function (resp_sup) {
                    if (resp_sup.d.results.length == 0) {
                        //insert
                        var data = {
                            '__metadata': {
                                'type': 'SP.Data.DashboardListItem'
                            },
                            'Ano': anio,
                            'N_total_GDI': 0,
                            'Promedio_GDI': 0,
                            'Min_GDI': 0,
                            'Mediana_GDI': 0,
                            'Max_GDI': 0,
                            "N_total_Negocio": 0,
                            "Promedio_Negocio": 0,
                            "Min_Negocio": 0,
                            "Mediana_Negocio": 0,
                            "Max_Negocio": 0,
                            "N_total_Persona": 0,
                            "Promedio_Persona": 0,
                            "Min_Persona": 0,
                            "Mediana_Persona": 0,
                            "Max_Persona": 0,
                            "N_total_Competencia": 0,
                            "Promedio_Competencia": 0,
                            "Min_Competencia": 0,
                            "Mediana_Competencia": 0,
                            "Max_Competencia": 0,

                        };
                        spsservice.post_data("lists/getbytitle('Dashboard')/items", data);

                        // traer información actualizada
                        $scope.columnsGetGDI = "ID,Evaluado_x0020__x00c1_rea_x0020_,Supervisor_x0020_Nombre,Supervisor_x0020_Apellidos,Calificaci_x00f3_n_x0020_global_,Evaluado_x0020_Sociedad,Evaluado_x0020_Unidad_x0020_de_x,Nombre_x0020_de_x0020_la_x0020_p,ID_x0020_de_x0020_usuario_x0020_,TotalGDI,TotalObjNegocios,TotalObjPersonas,TotalCompetencias,SumaObjetivos";
                        $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('GDI" + $rootScope.anioCalculo + "')/Items?$select=" + $scope.columnsGetGDI + "&$top=5000";
                        // $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('GDI2018')/Items?$select=" + $scope.columnsGetGDI + "&$top=5000";
                        $rootScope.getDataGDIForDashboard($scope.urlGetBase);



                    } else {
                        //update

                        $scope.columnsGetGDI = "ID,Evaluado_x0020__x00c1_rea_x0020_,Supervisor_x0020_Nombre,Supervisor_x0020_Apellidos,Calificaci_x00f3_n_x0020_global_,Evaluado_x0020_Sociedad,Evaluado_x0020_Unidad_x0020_de_x,Nombre_x0020_de_x0020_la_x0020_p,ID_x0020_de_x0020_usuario_x0020_,TotalGDI,TotalObjNegocios,TotalObjPersonas,TotalCompetencias,SumaObjetivos";
                        $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('GDI" + $rootScope.anioCalculo + "')/Items?$select=" + $scope.columnsGetGDI + "&$top=5000";
                        // $scope.urlGetBase = _spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('GDI2018')/Items?$select=" + $scope.columnsGetGDI + "&$top=5000";
                        $rootScope.getDataGDIForDashboard($scope.urlGetBase)

                    }
                })

            }

            $rootScope.putDashboard = function () {

                debugger;

                //Campos en nulo


                var arrayDashboarGDI = $rootScope.forDashboard.filter(x => x.TotalGDI >= 0 && x.TotalGDI != null);
                var arrayDashboarNegocio = $rootScope.forDashboard.filter(x => x.TotalObjNegocios >= 0 && x.TotalObjNegocios != null);
                var arrayDashboarPersona = $rootScope.forDashboard.filter(x => x.TotalObjPersonas >= 0 && x.TotalObjPersonas != null);
                var arrayDashboarCompetencias = $rootScope.forDashboard.filter(x => x.TotalCompetencias >= 0 && x.TotalCompetencias != null);

                // #region Calculos GDI
                arrayMedianaGDI = []
                sumGDI = 0
                promedioGDI = 0;

                for (let i = 0; i < arrayDashboarGDI.length; i++) {
                    arrayMedianaGDI.push(arrayDashboarGDI[i].TotalGDI)
                    sumGDI = sumGDI + arrayDashboarGDI[i].TotalGDI;

                    if (i == (arrayDashboarGDI.length - 1)) {

                        promedioGDI = parseFloat(sumGDI / arrayDashboarGDI.length).toFixed(2)

                    }
                }

                var maxGDI = Math.max.apply(Math, arrayDashboarGDI.map(function (o) {
                    return o.TotalGDI;
                }))


                var minGDI = Math.min.apply(Math, arrayDashboarGDI.map(function (o) {
                    return o.TotalGDI;
                }))


                arrayMedianaGDI.sort((a, b) => a - b);
                let lowMiddle = Math.floor((arrayMedianaGDI.length - 1) / 2);
                let highMiddle = Math.ceil((arrayMedianaGDI.length - 1) / 2);
                let median = (arrayMedianaGDI[lowMiddle] + arrayMedianaGDI[highMiddle]) / 2;
                medianaGDI = median;

                console.log("Resumen GDI, Promedio: " + promedioGDI + " Minima: " + minGDI + " Mediana: " + medianaGDI + " Máxima: " + maxGDI)

                //#endregion Calculos GDI


                // #region Calculos Negocio

                arrayMedianaNegocio = []
                sumNegocio = 0
                promedioNegocio = 0;

                for (let j = 0; j < arrayDashboarNegocio.length; j++) {

                    arrayMedianaNegocio.push(arrayDashboarNegocio[j].TotalObjNegocios)
                    sumNegocio = sumNegocio + arrayDashboarNegocio[j].TotalObjNegocios;

                    if (j == (arrayDashboarNegocio.length - 1)) {

                        promedioNegocio = parseFloat(sumNegocio / arrayDashboarNegocio.length).toFixed(2)

                    }
                }

                var maxNegocio = Math.max.apply(Math, arrayDashboarNegocio.map(function (o) {
                    return o.TotalObjNegocios;
                }))


                var minNegocio = Math.min.apply(Math, arrayDashboarNegocio.map(function (o) {
                    return o.TotalObjNegocios;
                }))

                arrayMedianaNegocio.sort((a, b) => a - b);
                let lowMiddle2 = Math.floor((arrayMedianaNegocio.length - 1) / 2);
                let highMiddle2 = Math.ceil((arrayMedianaNegocio.length - 1) / 2);
                let median2 = (arrayMedianaNegocio[lowMiddle2] + arrayMedianaNegocio[highMiddle2]) / 2;
                medianaNegocio = median2;

                console.log("Resumen Negocio, Promedio: " + promedioNegocio + " Minima: " + minNegocio + " Mediana: " + medianaNegocio + " Máxima: " + maxNegocio)

                // #endregion Calculos Negocio

                // #region calculos persona
                arrayMedianaPersona = []
                sumPersona = 0
                promedioPersona = 0;

                for (let k = 0; k < arrayDashboarPersona.length; k++) {

                    arrayMedianaPersona.push(arrayDashboarPersona[k].TotalObjPersonas)
                    sumPersona = sumPersona + arrayDashboarPersona[k].TotalObjPersonas;

                    if (k == (arrayDashboarPersona.length - 1)) {

                        promedioPersona = parseFloat(sumPersona / arrayDashboarPersona.length).toFixed(2)

                    }
                }

                var maxPersona = Math.max.apply(Math, arrayDashboarPersona.map(function (o) {
                    return o.TotalObjPersonas;
                }))


                var minPersona = Math.min.apply(Math, arrayDashboarPersona.map(function (o) {
                    return o.TotalObjPersonas;
                }))


                // arrayMedianaNegocio.sort((a, b) => a - b);
                // let lowMiddle2 = Math.floor((arrayMedianaNegocio.length - 1) / 2);
                // let highMiddle2 = Math.ceil((arrayMedianaNegocio.length - 1) / 2);
                // let median2 = (arrayMedianaNegocio[lowMiddle2] + arrayMedianaNegocio[highMiddle2]) / 2;
                // medianaNegocio = median2;

                arrayMedianaPersona.sort((a, b) => a - b);
                let lowMiddle3 = Math.floor((arrayMedianaPersona.length - 1) / 2);
                let highMiddle3 = Math.ceil((arrayMedianaPersona.length - 1) / 2);
                let median3 = (arrayMedianaPersona[lowMiddle3] + arrayMedianaPersona[highMiddle3]) / 2;
                medianaPersona = median3;

                console.log("Resumen Personas, Promedio: " + promedioPersona + " Minima: " + minPersona + " Mediana: " + medianaPersona + " Máxima: " + maxPersona)

                // #endregion calculos persona


                // #region calculos competencias

                arrayMedianaCompetencias = []
                sumCompetencias = 0
                promedioCompetencias = 0;

                for (let l = 0; l < arrayDashboarCompetencias.length; l++) {

                    arrayMedianaCompetencias.push(arrayDashboarCompetencias[l].TotalCompetencias)
                    sumCompetencias = sumCompetencias + arrayDashboarCompetencias[l].TotalCompetencias;

                    if (l == (arrayDashboarCompetencias.length - 1)) {

                        promedioCompetencias = parseFloat(sumCompetencias / arrayDashboarCompetencias.length).toFixed(2)

                    }
                }

                var maxCompetencias = Math.max.apply(Math, arrayDashboarCompetencias.map(function (o) {
                    return o.TotalCompetencias;
                }))

                var minCompetencias = Math.min.apply(Math, arrayDashboarCompetencias.map(function (o) {
                    return o.TotalCompetencias;
                }))

                arrayMedianaCompetencias.sort((a, b) => a - b);
                let lowMiddle4 = Math.floor((arrayMedianaCompetencias.length - 1) / 2);
                let highMiddle4 = Math.ceil((arrayMedianaCompetencias.length - 1) / 2);
                let median4 = (arrayMedianaCompetencias[lowMiddle4] + arrayMedianaCompetencias[highMiddle4]) / 2;
                medianaCompetencias = median4;

                console.log("Resumen Competencias, Promedio: " + promedioCompetencias + " Minima: " + minCompetencias + " Mediana: " + medianaCompetencias + " Máxima: " + maxCompetencias)

                // #endregion calculos competencias

                // put en lista



                spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('Dashboard')/Items?$select=ID&$filter=Ano eq " + $rootScope.anioCalculo).then(function (resp_sup) {
                    // spsservice.get_type(_spPageContextInfo.webAbsoluteUrl + "/_api/web/lists/getbytitle('Dashboard')/Items?$select=ID&$filter=Ano eq 2018").then(function (resp_sup) {
                    if (resp_sup.d.results.length > 0) {
                        var data = {
                            '__metadata': {
                                'type': 'SP.Data.DashboardListItem'
                            },
                            'Ano': $rootScope.anioCalculo,
                            'N_total_GDI': arrayDashboarGDI.length, // largo total gdi
                            'Promedio_GDI': parseFloat(promedioGDI).toFixed(2),
                            'Min_GDI': parseFloat(minGDI.toFixed(2)),
                            'Mediana_GDI': parseFloat(medianaGDI.toFixed(2)),
                            'Max_GDI': parseFloat(maxGDI.toFixed(2)),
                            "N_total_Negocio": $scope.datatableObjetivos.filter(x => x.Categor_x00ed_a_x0020_de_x0020_o == "Negocio" && x.OData__x0025__x0020_Final_x0020_de_x00 >= 0).length,
                            "Promedio_Negocio": parseFloat(promedioNegocio).toFixed(2),
                            "Min_Negocio": parseFloat(minNegocio.toFixed(2)),
                            "Mediana_Negocio": parseFloat(medianaNegocio.toFixed(2)),
                            "Max_Negocio": parseFloat(maxNegocio.toFixed(2)),
                            "N_total_Persona": $scope.datatableObjetivos.filter(x => x.Categor_x00ed_a_x0020_de_x0020_o == "Personas" && x.OData__x0025__x0020_Final_x0020_de_x00 >= 0).length,
                            "Promedio_Persona": parseFloat(promedioPersona),
                            "Min_Persona": parseFloat(minPersona.toFixed(2)),
                            "Mediana_Persona": parseFloat(medianaPersona.toFixed(2)),
                            "Max_Persona": parseFloat(maxPersona.toFixed(2)),
                            "N_total_Competencia": $scope.datatableCompetencias.filter(x => x.Pro_x0028_Calificaci_x00f3_n_x00 >= 0).length,
                            "Promedio_Competencia": parseFloat(promedioCompetencias),
                            "Min_Competencia": parseFloat(minCompetencias.toFixed(2)),
                            "Mediana_Competencia": parseFloat(medianaCompetencias.toFixed(2)),
                            "Max_Competencia": parseFloat(maxCompetencias.toFixed(2)),

                        };

                        spsservice.put_data("lists/getbytitle('Dashboard')/items(" + resp_sup.d.results[0].ID + ")", data);
                        alert("Calculos actualizados");
                        $rootScope.bloqueopantalla = false;
                    }

                })

            }


        })
}(angular.module('spsmodule')));