(function () {

  angular.module('spsmodule', ['ui.bootstrap', 'ngRoute', 'ngSanitize', 'ngAnimate', 'oitozero.ngSweetAlert', 'ui.select'])


    .config(["$routeProvider", function ($routeProvider) {
      $routeProvider.when("/", {
          templateUrl: "../SitePages/pages/inicio.html",
          controller: "HomeController"
        })
        //Asuntos
        .when("/Asuntos", {
          templateUrl: "../SitePages/pages/asuntos/asuntos.html",
          controller: "listar"
        })
        .when("/CrearAsunto", {
          templateUrl: "../SitePages/pages/asuntos/creaAsunto.html",
          controller: "CrearAsuntoController"
        })
        .when("/Asunto/:id", {
          templateUrl: "../SitePages/pages/asuntos/detalleAsunto.html",
          controller: "DetalleAsuntoController",
          resolve: {
            id: function ($route) {
              return $route.current.params.id;
            }
          }
        })

        //Stakeholders
        .when("/Stakeholders", {
          templateUrl: "../SitePages/pages/stakeholders/stakeholders.html",
          controller: "listar"
        })
        .when("/CrearStakeholder", {
          templateUrl: "../SitePages/pages/stakeholders/creaStakeholder.html",
          controller: "CrearStakeholderController"
        })
        .when("/Stakeholder/:id", {
          templateUrl: "../SitePages/pages/stakeholders/detalleStakeholder.html",
          controller: "DetalleStakeHolderController",
          resolve: {
            id: function ($route) {
              return $route.current.params.id;
            }
          }
        })
        
        //Skyview
        .when("/Skyview", {
          templateUrl: "../SitePages/pages/skyview/skyview.html",
          controller: "ListarSkyviewController"
        })
        .when("/agendarVisita", {
          templateUrl: "../SitePages/pages/skyview/crearVisita.html",
          controller: "CrearVisitaController"
        })
        .when("/Visita/:id", {
          templateUrl: "../SitePages/pages/skyview/detalleSkyview.html",
          controller: "detalleSkyview",
          resolve: {
            id: function ($route) {
              return $route.current.params.id;
            }
          }
        })

        //Actividades
        .when("/Actividades", {
          templateUrl: "../SitePages/pages/actividades/listar.html",
          controller: "ActividadesController"
        })

        //Reportes
        .when("/Reportes", {
          templateUrl: "../SitePages/pages/reportes/acciones.html",
          controller: "ReportesAccionesController"
        })
                       
        //Reunion Funcionarios publicos
        .when("/CrearReunion", {
          templateUrl: "../SitePages/pages/detalleReunion.html",
          controller: "CrearReunionesController"
        })
        .when("/CrearReunionComunidades", {
          templateUrl: "../SitePages/pages/detalleReunionComunidades.html",
          controller: "CrearReunionesComunidadesController"
        })
        .when("/ReunionesComunidades", {
          templateUrl: "../SitePages/pages/reunionesComunidades.html",
          controller: "listar"
        })
       
    }])



    .filter('propsFilter', function () {
      return function (items, props) {
        var out = [];

        if (angular.isArray(items)) {
          var keys = Object.keys(props);

          items.forEach(function (item) {
            var itemMatches = false;

            for (var i = 0; i < keys.length; i++) {
              var prop = keys[i];
              var text = props[prop].toLowerCase();
              if (item[prop].toString().toLowerCase().indexOf(text) !== -1) {
                itemMatches = true;
                break;
              }
            }

            if (itemMatches) {
              out.push(item);
            }
          });
        } else {
          // Let the output be the input untouched
          out = items;
        }

        return out;
      };
    })


    .filter('propsFilterOrganizaciones', function () {
      return function (items, props) {
        var out = [];

        if (angular.isArray(items)) {
          var keys = Object.keys(props);

          items.forEach(function (item) {
            var itemMatches = false;

            for (var i = 0; i < keys.length; i++) {
              var prop = keys[i];
              var text = props[prop].toLowerCase();
              if (item[prop].toString().toLowerCase().indexOf(text) !== -1) {
                itemMatches = true;
                break;
              }
            }

            if (itemMatches) {
              out.push(item);
            }
          });
        } else {
          // Let the output be the input untouched
          out = items;
        }

        return out;
      };
    })


    .filter('Filesize', function () {
      return function (size) {
        if (isNaN(size))
          size = 0;

        if (size < 1024)
          return size + ' Bytes';

        size /= 1024;

        if (size < 1024)
          return size.toFixed(2) + ' Kb';

        size /= 1024;

        if (size < 1024)
          return size.toFixed(2) + ' Mb';

        size /= 1024;

        if (size < 1024)
          return size.toFixed(2) + ' Gb';

        size /= 1024;

        return size.toFixed(2) + ' Tb';
      };
    })


    .directive('capitalize', function () {
      return {
        require: 'ngModel',
        link: function (scope, element, attrs, modelCtrl) {
          var capitalize = function (inputValue) {
            if (inputValue == undefined) inputValue = '';
            var capitalized = inputValue.toUpperCase();
            if (capitalized !== inputValue) {
              // see where the cursor is before the update so that we can set it back
              var selection = element[0].selectionStart;
              modelCtrl.$setViewValue(capitalized);
              modelCtrl.$render();
              // set back the cursor after rendering
              element[0].selectionStart = selection;
              element[0].selectionEnd = selection;
            }
            return capitalized;
          }
          modelCtrl.$parsers.push(capitalize);
          capitalize(scope[attrs.ngModel]); // capitalize initial value
        }
      }
    })



})();